/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;

public class InstanceClsesPanel
extends SelectableContainer {
    private Project _project;
    private SelectableTree _clsTree;
    private LabeledComponent _labeledComponent;

    public InstanceClsesPanel(Project project) {
        this._project = project;
        this.add((Component)this.createHeaderPanel(), "North");
        this._labeledComponent = this.createClsesPanel();
        this.add((Component)this._labeledComponent, "Center");
        this.setSelectable(this._clsTree);
    }

    private JComponent createHeaderPanel() {
        JLabel jLabel = ComponentFactory.createLabel(this._project.getName());
        jLabel.setIcon(Icons.getProjectIcon());
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent headerComponent = new HeaderComponent(string, string2, jLabel);
        headerComponent.setColor(Colors.getClsColor());
        return headerComponent;
    }

    private LabeledComponent createClsesPanel() {
        Cls cls = this._project.getKnowledgeBase().getRootCls();
        this._clsTree = ComponentFactory.createSelectableTree(null, new ParentChildRoot(cls));
        this._clsTree.setLargeModel(true);
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        frameRenderer.setDisplayDirectInstanceCount(!this._project.getSuppressInstanceCounting());
        this._clsTree.setCellRenderer(frameRenderer);
        this._clsTree.setSelectionRow(0);
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane(this._clsTree));
        labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        labeledComponent.addHeaderButton(this.getViewClsAction());
        labeledComponent.setFooterComponent(new ClsTreeFinder(this._project.getKnowledgeBase(), this._clsTree));
        return labeledComponent;
    }

    public JTree getDropComponent() {
        return this._clsTree;
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object object) {
                Cls cls = (Cls)object;
                InstanceClsesPanel.this._project.show(cls);
            }
        };
    }

    public void setSelectedCls(Cls cls) {
        List list = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setSelectedObjectPath(this._clsTree, list);
    }
}

