/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;

public class ClsListWidget
extends AbstractListWidget {
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            ClsListWidget.this.repaint();
        }

        public void nameChanged(FrameEvent frameEvent) {
            ClsListWidget.this.repaint();
        }
    };

    protected void addButtons(LabeledComponent labeledComponent, Action action) {
        this.addButton(action);
        this.addButton(this.getAddClsesAction());
        this.addButton(this.getRemoveClsesAction());
    }

    public void dispose() {
        super.dispose();
        this.removeListener();
    }

    protected Action getAddClsesAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){

            public void onAdd() {
                ClsListWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    protected Action getRemoveClsesAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                ClsListWidget.this.handleRemoveAction(collection);
            }
        };
        return this._removeAction;
    }

    protected Action getViewInstanceAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object object) {
                ClsListWidget.this.handleViewAction((Cls)object);
            }
        };
    }

    protected void handleAddAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedParents(this.getSlot());
        this.addItems(DisplayUtilities.pickClses((Component)this, this.getKnowledgeBase(), collection));
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(Cls cls) {
        this.showInstance(cls);
    }

    public void initialize() {
        super.initialize();
        this.addButtons(this.getLabeledComponent(), this.getViewInstanceAction());
        this.setRenderer(FrameRenderer.createInstance());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            Collection collection;
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            boolean bl2 = valueType.equals(ValueType.CLS);
            if (valueType.equals(ValueType.INSTANCE) && !(collection = cls.getTemplateSlotAllowedClses(slot)).isEmpty()) {
                boolean bl3 = true;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && bl3) {
                    Cls cls2 = (Cls)iterator.next();
                    bl3 = cls2.isClsMetaCls();
                }
                bl2 = bl3;
            }
            boolean bl4 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl4;
        }
        return bl;
    }

    protected void removeListener() {
        for (Instance instance : this.getValues()) {
            instance.removeFrameListener(this._instanceListener);
        }
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        ClsListWidget.setAllowed(this._addAction, bl);
        ClsListWidget.setAllowed(this._removeAction, bl);
    }

    public void setValues(Collection collection) {
        this.removeListener();
        for (Instance instance : collection) {
            instance.addFrameListener(this._instanceListener);
        }
        super.setValues(collection);
    }
}

