/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JList;

public class ClsFieldWidget
extends AbstractSlotWidget {
    private JList _list;
    private Instance _instance;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            ClsFieldWidget.this.repaint();
        }

        public void nameChanged(FrameEvent frameEvent) {
            ClsFieldWidget.this.repaint();
        }
    };

    public void addButton(LabeledComponent labeledComponent, Action action) {
        this.addButtonConfiguration(action);
        if (this.displayButton(action)) {
            labeledComponent.addHeaderButton(action);
        }
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        this.addButton(labeledComponent, this.getViewClsAction());
        this.addButton(labeledComponent, this.getSelectClsAction());
        this.addButton(labeledComponent, this.getRemoveClsAction());
    }

    public JList createList() {
        SelectableList selectableList = ComponentFactory.createSingleItemList(this.getDoubleClickAction());
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        return selectableList;
    }

    public void dispose() {
        super.dispose();
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
    }

    protected Action getRemoveClsAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){

            public void onRemove(Object object) {
                ClsFieldWidget.this.handleRemoveAction();
            }
        };
        return this._removeAction;
    }

    protected Action getSelectClsAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){

            public void onAdd() {
                ClsFieldWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._instance);
    }

    public Collection getValues() {
        return CollectionUtilities.createList(this._instance);
    }

    protected Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object object) {
                ClsFieldWidget.this.handleViewAction((Instance)object);
            }
        };
    }

    protected void handleAddAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedParents(this.getSlot());
        Cls cls = DisplayUtilities.pickCls((Component)this, this.getKnowledgeBase(), collection);
        if (cls != null) {
            this.setDisplayedInstance(cls);
        }
    }

    protected void handleRemoveAction() {
        this.removeDisplayedInstance();
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), this._list);
        this.addButtons(labeledComponent);
        this.add(labeledComponent);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = cls.getTemplateSlotValueType(slot) == ValueType.CLS;
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && !bl3;
        }
        return bl;
    }

    protected void removeDisplayedInstance() {
        this.replaceInstance(null);
        this.updateList();
        this.valueChanged();
    }

    protected void replaceInstance(Instance instance) {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        this._instance = instance;
        if (this._instance != null) {
            this._instance.addFrameListener(this._instanceListener);
        }
        this.notifySelectionListeners();
    }

    protected void setDisplayedInstance(Instance instance) {
        this.replaceInstance(instance);
        this.updateList();
        this.valueChanged();
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        ClsFieldWidget.setAllowed(this._addAction, bl);
        ClsFieldWidget.setAllowed(this._removeAction, bl);
    }

    public void setValues(Collection collection) {
        Instance instance = (Instance)CollectionUtilities.getFirstItem(collection);
        this.replaceInstance(instance);
        this.updateList();
    }

    protected void updateList() {
        ComponentUtilities.setListValues(this._list, CollectionUtilities.createCollection(this._instance));
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = super.createWidgetConfigurationPanel();
        widgetConfigurationPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return widgetConfigurationPanel;
    }
}

