/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.CacheImpl;
import edu.stanford.smi.protege.util.transaction.LosslessCache;
import edu.stanford.smi.protege.util.transaction.LosslessCacheImpl;
import edu.stanford.smi.protege.util.transaction.TransactionCache;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCacheImpl<V, R>
extends TransactionCache<V, R> {
    private TransactionMonitor transactionMonitor;
    private TransactionIsolationLevel level;
    private boolean disabled = false;

    public TransactionCacheImpl(TransactionMonitor transactionMonitor) {
        super(new CacheImpl());
        this.transactionMonitor = transactionMonitor;
    }

    @Override
    public boolean inTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.inTransaction();
    }

    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        if (this.level == null) {
            if (this.transactionMonitor == null) {
                this.level = TransactionIsolationLevel.NONE;
            }
            try {
                this.level = this.transactionMonitor.getTransationIsolationLevel();
            }
            catch (TransactionException transactionException) {
                this.disabled = true;
                Log.getLogger().log(Level.WARNING, "Could not determine trahsaction isolation level", transactionException);
                Log.getLogger().warning("Caching disabled");
            }
        }
        return this.level;
    }

    public void resetTransactionIsolationLevel() {
        this.level = null;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public LosslessCache createSessionCache(RemoteSession remoteSession) {
        return new LosslessCacheImpl();
    }
}

