/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ResizingLayout
implements LayoutManager2 {
    public static final String HORIZONTAL_STRETCHER = "horizonal_stretcher";
    public static final String VERTICAL_STRETCHER = "vertical_strecher";
    public static final String FILLING_VERTICALLY = "filling_vertically";
    public static final String FILLING_HORIZONTALLY = "filling_horizontally";
    public static final boolean VERTICAL_FILL_DEFAULT = false;
    public static final boolean HORIZONTAL_FILL_DEFAULT = true;
    private Dimension _previousSize;
    private boolean _resizeVerticallyOverride;

    public void addLayoutComponent(Component component, Object object) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private static Component getHorizontalStretcher(Container container) {
        return (Component)((JComponent)container).getClientProperty(HORIZONTAL_STRETCHER);
    }

    public void setResizeVertically(boolean bl) {
        this._resizeVerticallyOverride = bl;
    }

    private boolean getIsFillingVertically(Container container) {
        return this._resizeVerticallyOverride || ResizingLayout.getBooleanClientProperty(container, FILLING_VERTICALLY, false);
    }

    private static boolean getIsFillingHorizontally(Container container) {
        return ResizingLayout.getBooleanClientProperty(container, FILLING_HORIZONTALLY, true);
    }

    private static boolean getBooleanClientProperty(Container container, String string, boolean bl) {
        Boolean bl2 = (Boolean)((JComponent)container).getClientProperty(string);
        return bl2 == null ? bl : bl2;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public static Dimension getSize(Container container) {
        Dimension dimension = new Dimension();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Rectangle rectangle = container.getComponent(i).getBounds();
            dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
            dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
        }
        return dimension;
    }

    private static Component getVerticalStretcher(Container container) {
        return (Component)((JComponent)container).getClientProperty(VERTICAL_STRETCHER);
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        boolean bl = ResizingLayout.getIsFillingHorizontally(container);
        boolean bl2 = this.getIsFillingVertically(container);
        Component component = ResizingLayout.getVerticalStretcher(container);
        Component component2 = ResizingLayout.getHorizontalStretcher(container);
        Dimension dimension2 = container.getSize();
        Dimension dimension3 = dimension = this._previousSize == null ? this.preferredLayoutSize(container) : this._previousSize;
        if (!dimension2.equals(dimension)) {
            Point point = new Point();
            if (component2 != null) {
                point.x = component2.getX() + component2.getWidth();
            }
            if (component != null) {
                point.y = component.getY() + component.getHeight();
            }
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component3 = container.getComponent(i);
                ResizingLayout.resize(component3, dimension, dimension2, point, component2, bl, component, bl2);
            }
        }
        this._previousSize = dimension2;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(10000, 10000);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension();
    }

    public Dimension preferredLayoutSize(Container container) {
        return ResizingLayout.getSize(container);
    }

    public void removeLayoutComponent(Component component) {
    }

    private static void resize(Component component, Dimension dimension, Dimension dimension2, Point point, Component component2, boolean bl, Component component3, boolean bl2) {
        Rectangle rectangle = component.getBounds();
        if (bl) {
            if (component2 == null) {
                rectangle.x = ResizingLayout.rescale(rectangle.x, dimension2.width, dimension.width);
                rectangle.width = ResizingLayout.rescale(rectangle.width, dimension2.width, dimension.width);
            } else if (component == component2) {
                rectangle.width += dimension2.width - dimension.width;
            } else if (rectangle.x >= point.x) {
                rectangle.x += dimension2.width - dimension.width;
            }
        }
        if (bl2) {
            if (component3 == null) {
                rectangle.y = ResizingLayout.rescale(rectangle.y, dimension2.height, dimension.height);
                rectangle.height = ResizingLayout.rescale(rectangle.height, dimension2.height, dimension.height);
            } else if (component == component3) {
                rectangle.height += dimension2.height - dimension.height;
            } else if (rectangle.y >= point.y) {
                rectangle.y += dimension2.height - dimension.height;
            }
        }
        component.setBounds(rectangle);
    }

    private static int rescale(int n, int n2, int n3) {
        return (int)Math.round((double)n * (double)n2 / (double)n3);
    }
}

