/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockStepper<X extends Enum> {
    private static transient Logger log = Log.getLogger(LockStepper.class);
    private X testStage;
    private Object lock = new Object();
    private Object passedObject;

    public LockStepper(X start) {
        this.testStage = start;
    }

    public Object waitForStage(X stage) {
        return this.waitForStage(stage, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object waitForStage(X stage, int timeout) throws AssertionFailedError {
        Object object = this.lock;
        synchronized (object) {
            while (!this.stageReached(stage)) {
                try {
                    if (timeout <= 0) {
                        this.lock.wait();
                        continue;
                    }
                    this.lock.wait(timeout);
                }
                catch (InterruptedException e) {
                    Assert.fail("Execution interrupted");
                }
            }
            if (this.passedObject instanceof AssertionFailedError) {
                Assert.fail("Exception in alternate thread - see logs...");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Wait for state " + stage + " complete");
            }
            return this.passedObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stageAchieved(X stage, Object o) {
        Object object = this.lock;
        synchronized (object) {
            this.testStage = stage;
            this.passedObject = o;
            this.lock.notifyAll();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Achieved state " + stage);
        }
    }

    public void exceptionOffMainThread(X stage, Throwable failure) {
        Log.getLogger().log(Level.SEVERE, "Exception in other thread", failure);
        AssertionFailedError fail = new AssertionFailedError("Exception in other thread");
        fail.initCause(failure);
        this.stageAchieved(stage, fail);
    }

    private boolean stageReached(X stage) {
        return ((Enum)this.testStage).ordinal() >= ((Enum)stage).ordinal();
    }
}

