/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.SessionEvent;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;
import java.util.Collection;

public abstract class AbstractEvent
extends SessionEvent
implements Localizable {
    private int _eventType;
    private Object _source;
    private Object _argument1;
    private Object _argument2;
    private Object _argument3;
    private long _timeStamp;
    private String _userName;

    protected AbstractEvent(Object object, int n) {
        this(object, n, null, null, null);
    }

    protected AbstractEvent(Object object, int n, Object object2) {
        this(object, n, object2, null, null);
    }

    protected AbstractEvent(Object object, int n, Object object2, Object object3) {
        this(object, n, object2, object3, null);
    }

    protected AbstractEvent(Object object, int n, Object object2, Object object3, Object object4) {
        super(object);
        if (object instanceof Serializable) {
            this._source = object;
        }
        this._eventType = n;
        this._argument1 = object2;
        this._argument2 = object3;
        this._argument3 = object4;
        this._timeStamp = System.currentTimeMillis();
        this._userName = this.getUserName();
    }

    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this._source, knowledgeBase);
        LocalizeUtils.localize(this._argument1, knowledgeBase);
        LocalizeUtils.localize(this._argument2, knowledgeBase);
        LocalizeUtils.localize(this._argument3, knowledgeBase);
    }

    protected void setSource(Object object) {
        this._source = object;
        this.source = object;
    }

    public Object getArgument() {
        return this.getArgument1();
    }

    public Object getArgument1() {
        return this._argument1;
    }

    public Object getArgument2() {
        return this._argument2;
    }

    public Object getArgument3() {
        return this._argument3;
    }

    public int getEventType() {
        return this._eventType;
    }

    public Object getSource() {
        return this._source == null ? super.getSource() : this._source;
    }

    public String toString() {
        String string = StringUtilities.getClassName(this);
        return string + "(" + this.getSource() + ", " + this._eventType + ", " + this.getArgument1() + ", " + this.getArgument2() + ", " + this.getUserName() + ", " + this.getTimeStamp() + ")";
    }

    public int hashCode() {
        return HashUtils.getHash(this.source, this._argument1, this._argument2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof AbstractEvent) {
            AbstractEvent abstractEvent = (AbstractEvent)object;
            bl = this._timeStamp == abstractEvent._timeStamp && this._userName.equals(abstractEvent._userName) && AbstractEvent.equals(this.source, abstractEvent.source) && AbstractEvent.equals(this._argument1, abstractEvent._argument1) && AbstractEvent.equals(this._argument2, abstractEvent._argument2) && AbstractEvent.equals(this._argument3, abstractEvent._argument3);
        }
        return bl;
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = object instanceof Collection && object2 instanceof Collection ? CollectionUtilities.equalsSet((Collection)object, (Collection)object2) : SystemUtilities.equals(object, object2);
        return bl;
    }

    public void setTimeStamp(long l) {
        this._timeStamp = l;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public String getUserName() {
        if (this._userName != null) {
            return this._userName;
        }
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this._userName = remoteSession != null ? remoteSession.getUserName() : ApplicationProperties.getUserName();
        return this._userName;
    }
}

