/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.test.TestUtilities;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class InstanceDisplay_Test
extends APITestCase {
    private void deleteAllStickies() {
        KnowledgeBase kb = this.getDomainKB();
        Cls cls = kb.getCls(":INSTANCE-ANNOTATION");
        for (Instance instance : new ArrayList<Instance>(cls.getInstances())) {
            kb.deleteInstance(instance);
        }
    }

    private JFrame loadIntoFrame(String instanceName) {
        JFrame frame1 = new JFrame();
        InstanceDisplay id = new InstanceDisplay(this.getProject());
        frame1.getContentPane().add(id);
        Instance instance = this.getInstance(instanceName);
        InstanceDisplay_Test.assertNotNull((String)("instance exists: " + instanceName), (Object)instance);
        id.setInstance(instance, null);
        frame1.pack();
        frame1.setVisible(true);
        Toolkit.getDefaultToolkit().sync();
        SystemUtilities.sleepMsec(100);
        return frame1;
    }

    private static void pressMessageOK() {
        Thread t = new Thread(){

            public void run() {
                try {
                    ModalDialog dialog = null;
                    while (dialog == null) {
                        dialog = ModalDialog.getCurrentDialog();
                        if (dialog != null) {
                            InstanceDisplay_Test.pressButton(dialog, Icons.getYesIcon());
                            return;
                        }
                        SystemUtilities.sleepMsec(100);
                    }
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.INFO, "Exception caught", t);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private static void pressButton(Component c, Icon icon) {
        TestUtilities.pressButton(c, icon);
    }

    public void testYellowStickyCreation() {
        this.deleteAllStickies();
        String frameName = this.createCls().getName();
        JFrame frame1 = this.loadIntoFrame(frameName);
        int frameCount = this.getFrameCount();
        InstanceDisplay_Test.pressButton(frame1, Icons.getCreateClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"frame count", (int)(frameCount + 1), (int)this.getFrameCount());
        JInternalFrame inf = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, frame1);
        InstanceDisplay_Test.assertNotNull((String)"internal frame", (Object)inf);
        JTextArea area = (JTextArea)ComponentUtilities.getDescendentOfClass(JTextArea.class, inf);
        InstanceDisplay_Test.assertNotNull((String)"text area", (Object)area);
        area.setText("This is a test - " + System.currentTimeMillis());
        JFrame frame2 = this.loadIntoFrame(frameName);
        Point loc = frame2.getLocation();
        loc.x += 200;
        frame2.setLocation(loc);
        ComponentUtilities.dispose(frame1);
        ComponentUtilities.dispose(frame2);
        this.deleteAllStickies();
    }

    public void testYellowStickyDeletion() {
        this.deleteAllStickies();
        String frameName = this.createCls().getName();
        JFrame frame = this.loadIntoFrame(frameName);
        int count = this.getFrameCount();
        InstanceDisplay_Test.pressButton(frame, Icons.getCreateClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"added sticky", (int)(count + 1), (int)this.getFrameCount());
        InstanceDisplay_Test.pressMessageOK();
        InstanceDisplay_Test.pressButton(frame, Icons.getDeleteClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"deleted sticky", (int)count, (int)this.getFrameCount());
        ComponentUtilities.dispose(frame);
        this.deleteAllStickies();
    }

    public void testYellowStickyLocationSave() {
        String frameName = this.createCls().getName();
        JFrame frame1 = this.loadIntoFrame(frameName);
        InstanceDisplay_Test.pressButton(frame1, Icons.getCreateClsNoteIcon());
        final JInternalFrame iFrame = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, frame1);
        JTextArea area = (JTextArea)ComponentUtilities.getDescendentOfClass(JTextArea.class, iFrame);
        area.setText("This is a test - " + System.currentTimeMillis());
        final Point loc = iFrame.getLocation();
        loc.x += 100;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    iFrame.setLocation(loc);
                }
            });
        }
        catch (InterruptedException e) {
            InstanceDisplay_Test.fail();
        }
        catch (InvocationTargetException e) {
            InstanceDisplay_Test.fail();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    iFrame.setLocation(loc);
                }
            });
        }
        catch (InterruptedException e) {
            InstanceDisplay_Test.fail();
        }
        catch (InvocationTargetException e) {
            InstanceDisplay_Test.fail();
        }
        ComponentUtilities.dispose(frame1);
        JFrame frame2 = this.loadIntoFrame(frameName);
        JInternalFrame iFrame2 = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, frame2);
        InstanceDisplay_Test.assertEquals((String)"within project", (Object)loc, (Object)iFrame2.getLocation());
        ComponentUtilities.dispose(frame2);
        InstanceDisplay_Test.saveAndReload();
        JFrame frame3 = this.loadIntoFrame(frameName);
        JInternalFrame iFrame3 = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, frame3);
        InstanceDisplay_Test.assertEquals((String)"after reload", (Object)loc, (Object)iFrame3.getLocation());
        ComponentUtilities.dispose(frame3);
        this.deleteAllStickies();
    }
}

