/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class IconDialog
extends JDialog {
    Icon[] icons = new Icon[]{null, Icons.getAddIcon(), Icons.getRemoveIcon(), Icons.getCreateIcon(), Icons.getDeleteIcon(), Icons.getViewIcon(), Icons.getViewInstanceReferencersIcon(), Icons.getUpIcon(), Icons.getDownIcon(), Icons.getCreateInstanceNoteIcon(), Icons.getDeleteInstanceNoteIcon(), null, Icons.getClsIcon(), Icons.getClsIcon(false, true, false, false), Icons.getClsIcon(true, false, false, false), Icons.getClsIcon(true, true, false, false), Icons.getFacetIcon(), Icons.getInstanceIcon(), Icons.getSlotIcon(), Icons.getSlotIcon(true, false, false, false), Icons.getSlotIcon(false, true, false, false), Icons.getSlotIcon(true, true, false, false), Icons.getViewSlotIcon(), Icons.getViewSlotAtClassIcon(), Icons.getRemoveSlotOverrideIcon(), null, Icons.getFormIcon(), Icons.getRelayoutIcon(), Icons.getLayoutLikeOtherFormIcon(), Icons.getFormIcon(true), Icons.getRemoveCustomizationsIcon()};
    String[] iconText = new String[]{"General Icons", "Add, attach, or select", "Remove selected object from view but not from the knowledge base", "Create a class, slot, or instance", "Delete selected class, slot, or instance from the knowledge base", "View selected class, slot, or instance", "Display references to selected class, slot, or instance", "Move selected item up in list", "Move selected item down in list", "Create note", "Delete note", "Frame Icons", "Class", "Abstract class (a class with no instances)", "Metaclass", "Abstract metaclass", "Facet", "Instance", "Slot", "Inherited slot", "Overridden slot", "Overridden inherited slot", "View selected slots", "View selected slots at class", "Remove slot override", "Form Icons", "Form", "Default layout with current widgets", "Layout like form...", "Customized Form", "Remove all customizations"};

    public IconDialog() {
        this((Frame)null, "", false);
    }

    public IconDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.init();
            this.pack();
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private int getMaxHeight() {
        int n = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int n2;
            if (this.icons[i] == null || (n2 = this.icons[i].getIconHeight()) <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getMaxWidth() {
        int n = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            int n2;
            if (this.icons[i] == null || (n2 = this.icons[i].getIconWidth()) <= n) continue;
            n = n2;
        }
        return n;
    }

    private JTextField getTextHeader(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEnabled(false);
        jTextField.setBackground(this.getBackground());
        jTextField.setDisabledTextColor(this.getForeground());
        jTextField.setBorder(null);
        jTextField.setFont(new Font("Dialog", 1, 14));
        return jTextField;
    }

    private void init() {
        JComponent jComponent;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new GridLayout(this.icons.length, 1));
        int n = this.getMaxWidth();
        int n2 = this.getMaxHeight();
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < this.icons.length; ++i) {
            jPanel = new JPanel(new BorderLayout(15, 0));
            if (this.icons[i] == null) {
                jComponent = this.getTextHeader(this.iconText[i]);
                jPanel.add((Component)jComponent, "Center");
            } else {
                jComponent = ComponentFactory.createLabel(this.icons[i], 0);
                jComponent.setPreferredSize(dimension);
                jPanel.add((Component)jComponent, "West");
                JLabel jLabel = ComponentFactory.createLabel(this.iconText[i], 2);
                jPanel.add((Component)jLabel, "Center");
            }
            jPanel2.add(jPanel);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel = new JPanel(new FlowLayout(1));
        jComponent = new JButton("Close");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IconDialog.this.closeButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add(jComponent);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }
}

