/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ClipsProjectFactory;
import edu.stanford.smi.protege.test.TestUtilities;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class UITestCase
extends AbstractTestCase {
    public Project getProject() {
        return ProjectManager.getProjectManager().getCurrentProject();
    }

    public static void pressButton(Component c, Icon icon) {
        UITestCase.assertNotNull((Object)c);
        UITestCase.assertNotNull((Object)icon);
        TestUtilities.pressButton(c, icon);
    }

    protected static void pressToolBarButton(Icon icon) {
        JToolBar c = UITestCase.getSystemToolBar();
        UITestCase.assertNotNull((Object)c);
        UITestCase.pressButton(c, icon);
    }

    protected static JToolBar getSystemToolBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMainToolBar();
    }

    protected static Component getTopWindow() {
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        UITestCase.assertNotNull((Object)window);
        return window;
    }

    protected static Component getMainWindow() {
        return ProjectManager.getProjectManager().getMainPanel();
    }

    protected static void delaySeconds(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void sync() {
        Toolkit.getDefaultToolkit().sync();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InterruptedException e1) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected static void setLabeledComponentText(Component window, String labelText, String text) {
        UITestCase.assertNotNull((Object)window);
        UITestCase.sync();
        boolean set = false;
        for (LabeledComponent labeledComponent : ComponentUtilities.getDescendentsOfClass(LabeledComponent.class, window)) {
            String label = labeledComponent.getHeaderLabel().toLowerCase();
            if (!label.startsWith(labelText.toLowerCase())) continue;
            Component c = labeledComponent.getCenterComponent();
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            }
            UITestCase.assertTrue((boolean)(c instanceof JTextComponent));
            JTextComponent textComponent = (JTextComponent)c;
            textComponent.setText(text);
            set = true;
            break;
        }
        UITestCase.assertTrue((boolean)set);
        UITestCase.sync();
    }

    protected static void executeOnNextModalDialog(final Runnable runnable) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    ModalDialog dialog = null;
                    while (dialog == null) {
                        dialog = ModalDialog.getCurrentDialog();
                        if (dialog != null && dialog.isVisible()) {
                            UITestCase.sync();
                            SystemUtilities.sleepMsec(250);
                            runnable.run();
                            return;
                        }
                        SystemUtilities.sleepMsec(250);
                    }
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.INFO, "Exception caught", t);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected static void setSelectionOnTree(Icon icon, Object[] path) {
        TestUtilities.setSelectionOnTree(UITestCase.getMainWindow(), icon, path);
    }

    protected static Object[] getSelectionOnTree(Icon icon) {
        return TestUtilities.getSelectionOnTree(UITestCase.getMainWindow(), icon);
    }

    protected static JTree getTreeOnTab(Icon icon) {
        return TestUtilities.getTreeOnTab(UITestCase.getMainWindow(), icon);
    }

    protected static void unpressToolBarButton(Icon icon) {
        UITestCase.sync();
        AbstractButton button = UITestCase.getToolBarButton(icon);
        UITestCase.assertNotNull((Object)button);
        if (button.isSelected()) {
            button.doClick();
        }
    }

    protected static AbstractButton getToolBarButton(Icon icon) {
        return TestUtilities.getButton(UITestCase.getSystemToolBar(), icon);
    }

    static {
        ClipsProjectFactory factory = new ClipsProjectFactory();
        Project p = factory.createProject();
        p = factory.saveAndReloadProject(p);
        URI uri = p.getProjectURI();
        p.dispose();
        Application.main(new String[]{uri.toString()});
    }
}

