/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import junit.framework.Assert;

public class TestUtilities {
    public static AbstractButton getButton(Component parent, Icon icon) {
        AbstractButton iconButton = null;
        for (AbstractButton button : ComponentUtilities.getDescendentsOfClass(AbstractButton.class, parent)) {
            if (!icon.equals(button.getIcon())) continue;
            iconButton = button;
            break;
        }
        return iconButton;
    }

    public static void pressButton(Component parent, Icon icon) {
        AbstractButton button = TestUtilities.getButton(parent, icon);
        if (button == null) {
            Assert.fail((String)("No such button: " + icon));
        } else {
            button.doClick();
            SystemUtilities.sleepMsec(500);
        }
    }

    public static Component selectTab(Component parent, Icon icon) {
        Component component = null;
        JTabbedPane tabbedPane = (JTabbedPane)ComponentUtilities.getDescendentOfClass(JTabbedPane.class, parent);
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Icon tabIcon = tabbedPane.getIconAt(i);
            if (!icon.equals(tabIcon)) continue;
            component = tabbedPane.getComponentAt(i);
            tabbedPane.setSelectedIndex(i);
        }
        return component;
    }

    public static Component getLeftComponent(Component parent) {
        JSplitPane splitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, parent);
        return splitPane.getLeftComponent();
    }

    public static Component getRightComponent(Component parent) {
        JSplitPane splitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, parent);
        return splitPane.getLeftComponent();
    }

    public static Component getTopComponent(Component parent) {
        JSplitPane splitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, parent);
        return splitPane.getLeftComponent();
    }

    public static Component getBottomComponent(Component parent) {
        JSplitPane splitPane = (JSplitPane)ComponentUtilities.getDescendentOfClass(JSplitPane.class, parent);
        return splitPane.getLeftComponent();
    }

    public static JTree getTree(Component parent) {
        return (JTree)ComponentUtilities.getDescendentOfClass(JTree.class, parent);
    }

    public static InstanceDisplay getInstanceDisplay(Component parent) {
        return (InstanceDisplay)ComponentUtilities.getDescendentOfClass(InstanceDisplay.class, parent);
    }

    public static JTree getTreeOnTab(Component parent, Icon icon) {
        return TestUtilities.getTree(TestUtilities.getLeftComponent(TestUtilities.selectTab(parent, icon)));
    }

    public static void setSelectionOnTree(Component parent, Icon icon, Object[] userObjects) {
        JTree tree = TestUtilities.getTreeOnTab(parent, icon);
        ComponentUtilities.setSelectedObjectPath(tree, Arrays.asList(userObjects));
    }

    public static Object[] getSelectionOnTree(Component parent, Icon icon) {
        JTree tree = TestUtilities.getTreeOnTab(parent, icon);
        TreePath path = tree.getSelectionPath();
        return ComponentUtilities.getObjectPath(path).toArray();
    }

    public static InstanceDisplay getInstanceDisplayOnTab(Component parent, Icon icon) {
        return TestUtilities.getInstanceDisplay(TestUtilities.getRightComponent(TestUtilities.selectTab(parent, icon)));
    }
}

