/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ProjectFactory;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;

public abstract class AbstractProjectFactory
implements ProjectFactory {
    protected static void checkErrors(Collection c) {
        if (!c.isEmpty()) {
            for (Object o : c) {
                Log.getLogger().severe("Error: " + o.toString());
            }
            Assert.fail();
        }
    }

    private static File getTempDirectory() {
        return AbstractTestCase.getTempDirectory();
    }

    protected static URI getProjectURI() {
        URI projectURI = null;
        try {
            File tmpFile = File.createTempFile("test", ".pprj", AbstractProjectFactory.getTempDirectory());
            projectURI = tmpFile.toURI();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        return projectURI;
    }

    public Project saveAndReloadProject(Project project) {
        URI uri = project.getProjectURI();
        if (uri == null) {
            uri = AbstractProjectFactory.getProjectURI();
            project.setProjectURI(uri);
        }
        ArrayList errors = new ArrayList();
        int frameCount = project.getKnowledgeBase().getFrameCount();
        project.save(errors);
        AbstractProjectFactory.checkErrors(errors);
        project.dispose();
        project = Project.loadProjectFromURI(uri, errors);
        AbstractProjectFactory.checkErrors(errors);
        Assert.assertEquals((int)frameCount, (int)project.getKnowledgeBase().getFrameCount());
        return project;
    }
}

