/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.test.AbstractProjectFactory;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ClipsProjectFactory;
import edu.stanford.smi.protege.test.ProjectFactory;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.PropertyList;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class APITestCase
extends AbstractTestCase {
    private Collection _firedEvents = new ArrayList();
    private static Properties _junitProperties = null;
    private static final String DB_PREFIX = "junit.db.";
    private static DBType _dbType = DBType.Oracle;
    public static final String JUNIT_DB_DRIVER_PROPERTY = "driver";
    public static final String JUNIT_DB_TABLE_PROPERTY = "table";
    public static final String JUNIT_DB_USER_PROPERTY = "user";
    public static final String JUNIT_DB_PASSWORD_PROPERTY = "password";
    public static final String JUNIT_DB_URL_PROPERTY = "url";
    private static ProjectFactory _factory = new ClipsProjectFactory();
    private static Project _scratchProject = _factory.createProject();
    private static boolean _isFileProject = true;
    private static Set<DBType> informedDBConfigured = EnumSet.noneOf(DBType.class);
    private static boolean informedNoConfigurationFile = false;
    private static int callNumber = 0;

    protected void assertEventFired(int type) {
        APITestCase.assertTrue((this.getEventFired(type) != null ? 1 : 0) != 0);
    }

    protected AbstractEvent getEventFired(int type) {
        AbstractEvent matchEvent = null;
        Iterator i = this._firedEvents.iterator();
        while (i.hasNext() && matchEvent == null) {
            AbstractEvent event = (AbstractEvent)i.next();
            if (event.getEventType() != type) continue;
            matchEvent = event;
        }
        return matchEvent;
    }

    public void setUp() throws Exception {
        super.setUp();
        _factory = new ClipsProjectFactory();
        _isFileProject = true;
    }

    public final void tearDown() throws Exception {
        super.tearDown();
        if (_scratchProject != null) {
            Project p = _scratchProject;
            _scratchProject = null;
            p.dispose();
        }
    }

    protected void clearEvents() {
        this._firedEvents.clear();
    }

    protected int getEventCount() {
        return this._firedEvents.size();
    }

    private static void configureDBSources(PropertyList sources) {
        if (!APITestCase.dbConfigured()) {
            return;
        }
        DatabaseKnowledgeBaseFactory.setDriver(sources, APITestCase.getDBProperty(JUNIT_DB_DRIVER_PROPERTY));
        DatabaseKnowledgeBaseFactory.setTablename(sources, APITestCase.getDBProperty(JUNIT_DB_TABLE_PROPERTY));
        DatabaseKnowledgeBaseFactory.setUsername(sources, APITestCase.getDBProperty(JUNIT_DB_USER_PROPERTY));
        DatabaseKnowledgeBaseFactory.setPassword(sources, APITestCase.getDBProperty(JUNIT_DB_PASSWORD_PROPERTY));
        DatabaseKnowledgeBaseFactory.setURL(sources, APITestCase.getDBProperty(JUNIT_DB_URL_PROPERTY));
    }

    public static DBType chooseDBType() {
        DBType[] arr$ = DBType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DBType dbt;
            _dbType = dbt = arr$[i$];
            if (!APITestCase.dbConfigured()) continue;
            return _dbType;
        }
        return null;
    }

    public static boolean dbConfigured() {
        return APITestCase.dbConfigured(true);
    }

    public static boolean dbConfigured(boolean report) {
        Properties dbp = APITestCase.getJunitProperties();
        if (dbp == null) {
            return false;
        }
        String configured = APITestCase.getDBProperty("configured");
        if (configured == null || !configured.toLowerCase().equals("true")) {
            if (report && !informedDBConfigured.contains((Object)_dbType)) {
                System.out.println("Database Tests for " + (Object)((Object)_dbType) + " not configured");
                informedDBConfigured.add(_dbType);
            }
            return false;
        }
        if (report && !informedDBConfigured.contains((Object)_dbType)) {
            System.out.println("Database Tests for " + (Object)((Object)_dbType) + " configured");
            informedDBConfigured.add(_dbType);
        }
        return true;
    }

    public static String getDBProperty(String prop) {
        Properties dbp = APITestCase.getJunitProperties();
        return dbp.getProperty(DB_PREFIX + (Object)((Object)_dbType) + "." + prop);
    }

    public static Properties getJunitProperties() {
        if (_junitProperties != null) {
            return _junitProperties;
        }
        try {
            Properties dbp = new Properties();
            String dbPropertyFile = ApplicationProperties.getApplicationDirectory().getPath() + File.separator + "junit.properties";
            FileInputStream is = new FileInputStream(dbPropertyFile);
            dbp.load(is);
            _junitProperties = dbp;
            return _junitProperties;
        }
        catch (Exception e) {
            if (!informedNoConfigurationFile) {
                System.out.println("No configuration file for tests");
                informedNoConfigurationFile = true;
            }
            return null;
        }
    }

    public Project getProject() {
        if (_scratchProject == null) {
            _scratchProject = _factory.createProject();
        }
        return _scratchProject;
    }

    public static boolean isDatabaseProject() {
        return !_isFileProject && _scratchProject != null;
    }

    public static boolean isFileProject() {
        return _isFileProject && _scratchProject != null;
    }

    public static void closeProject() {
        if (_scratchProject != null) {
            _scratchProject.dispose();
            _scratchProject = null;
        }
    }

    private static Project createScratchDatabaseProject() {
        ArrayList errors = new ArrayList();
        Project project = new Project(null, (Collection)errors);
        URI uri = AbstractProjectFactory.getProjectURI();
        project.setProjectURI(uri);
        PropertyList sources = project.getSources();
        sources.setString("factory_class_name", DatabaseKnowledgeBaseFactory.class.getName());
        APITestCase.configureDBSources(sources);
        project.save(errors);
        APITestCase.checkErrors(errors);
        _scratchProject = Project.loadProjectFromURI(uri, errors);
        APITestCase.checkErrors(errors);
        return _scratchProject;
    }

    private static Project createScratchFileProject() {
        return _factory.createProject();
    }

    protected Slot getSlot(String name) {
        return this.getDomainKB().getSlot(name);
    }

    public static void init() {
        _scratchProject = null;
    }

    public void recordEventFired(AbstractEvent event) {
        this._firedEvents.add(event);
    }

    protected static void saveAndReload() {
        _scratchProject = _factory.saveAndReloadProject(_scratchProject);
    }

    protected static void setDatabaseProject() {
        _isFileProject = false;
        APITestCase.closeProject();
        _scratchProject = APITestCase.createScratchDatabaseProject();
    }

    protected static void setFileProject() {
        _isFileProject = true;
        APITestCase.closeProject();
        _scratchProject = APITestCase.createScratchFileProject();
    }

    protected Object getClientInformation(String name) {
        return this.getProject().getClientInformation(name);
    }

    protected void setClientInformation(String name, Object value) {
        this.getProject().setClientInformation(name, value);
    }

    public static void setProjectFactory(ProjectFactory factory) {
        _factory = factory;
    }

    public static void setDBType(DBType dbt) {
        _dbType = dbt;
    }

    public static DBType getDBType() {
        return _dbType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        Oracle,
        MySQL,
        MsAccess,
        PostGres,
        SQLServer;

    }
}

