/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCachingNarrowFrameStore
implements NarrowFrameStore {
    private Logger log = Log.getLogger(ValueCachingNarrowFrameStore.class);
    private NarrowFrameStore _delegate;
    private DatabaseFrameDb _framedb;
    private CacheMap<Frame, Map<Sft, List>> valuesMap = new CacheMap();
    private Map<RemoteSession, CacheMap<Frame, Map<Sft, List>>> transactedValuesMap = new HashMap<RemoteSession, CacheMap<Frame, Map<Sft, List>>>();
    private Map<RemoteSession, Set<Frame>> transactedWrites = new HashMap<RemoteSession, Set<Frame>>();
    private static final int LOAD_THRESHOLD = 10;

    public ValueCachingNarrowFrameStore(DatabaseFrameDb databaseFrameDb) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Constructing ValueCachingNarrowFrameStore with delegate " + databaseFrameDb);
        }
        this._delegate = databaseFrameDb;
        this._framedb = databaseFrameDb;
    }

    public void setFrameDb(DatabaseFrameDb databaseFrameDb) {
        this._framedb = databaseFrameDb;
    }

    public DatabaseFrameDb getFrameDb() {
        return this._framedb;
    }

    private CacheMap<Frame, Map<Sft, List>> getFrameToSftToValuesMap() {
        TransactionMonitor transactionMonitor;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getting frame to stf to values map (session = " + ServerFrameStore.getCurrentSession() + ")");
        }
        if (!(transactionMonitor = this.getTransactionStatusMonitor()).inTransaction()) {
            return this.valuesMap;
        }
        TransactionIsolationLevel transactionIsolationLevel = transactionMonitor.getTransationIsolationLevel();
        if (transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            return this.valuesMap;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getting session local map");
        }
        return this.transactedValuesMap.get(ServerFrameStore.getCurrentSession());
    }

    private void markWritten(Frame frame) {
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        if (!transactionMonitor.inTransaction()) {
            return;
        }
        TransactionIsolationLevel transactionIsolationLevel = transactionMonitor.getTransationIsolationLevel();
        if (transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            return;
        }
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        Set<Frame> set = this.transactedWrites.get(remoteSession);
        if (set == null) {
            set = new HashSet<Frame>();
            this.transactedWrites.put(remoteSession, set);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("frame = " + frame.getFrameID() + " modified in this transaction");
        }
        set.add(frame);
    }

    private Map<Sft, List> lookup(Frame frame) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Getting sft to list map for frame = " + frame.getFrameID());
        }
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        CacheMap<Frame, Map<Sft, List>> cacheMap = this.getFrameToSftToValuesMap();
        HashMap hashMap = (HashMap)cacheMap.get(frame);
        if (transactionMonitor.inTransaction() && transactionMonitor.getTransationIsolationLevel() == TransactionIsolationLevel.READ_COMMITTED && hashMap == null && this.valuesMap.get(frame) != null && (this.transactedWrites.get(frame) == null || !this.transactedWrites.get(frame).contains(ServerFrameStore.getCurrentSession()))) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Copying values from untransacted cache");
            }
            hashMap = new HashMap();
            for (Map.Entry entry : ((Map)this.valuesMap.get(frame)).entrySet()) {
                Sft sft = (Sft)entry.getKey();
                List list = (List)entry.getValue();
                hashMap.put(sft, new ArrayList(list));
            }
            cacheMap.put(frame, hashMap);
        }
        return hashMap;
    }

    private List lookup(Map<Sft, List> map, Slot slot, Facet facet, boolean bl) {
        Sft sft = new Sft(slot, facet, bl);
        List list = map.get(sft);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("finding values for map and slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
            if (list == null) {
                this.log.finest("null found");
            } else {
                for (Object e : list) {
                    if (e instanceof Frame) {
                        this.log.finest("\tFrame Value = " + ((Frame)e).getFrameID());
                        continue;
                    }
                    this.log.finest("Value = " + e);
                }
            }
        }
        return list;
    }

    private List lookup(Frame frame, Slot slot, Facet facet, boolean bl) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("finding values for frame = " + frame.getFrameID() + "and slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
        }
        List list = null;
        Map<Sft, List> map = this.lookup(frame);
        if (map != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Trying cache");
            }
            list = this.lookup(map, slot, facet, bl);
        }
        if (this.log.isLoggable(Level.FINE)) {
            if (list == null) {
                this.log.finest("null found");
            } else {
                for (Object e : list) {
                    if (e instanceof Frame) {
                        this.log.finest("\tFrame Value = " + ((Frame)e).getFrameID());
                        continue;
                    }
                    this.log.finest("Value = " + e);
                }
            }
        }
        return list;
    }

    private static boolean isSpecial(Slot slot, Facet facet, boolean bl) {
        return facet == null && !bl && ValueCachingNarrowFrameStore.equals(slot, Model.SlotID.DIRECT_INSTANCES);
    }

    private static boolean equals(Slot slot, FrameID frameID) {
        return slot.getFrameID().equals(frameID);
    }

    private List loadSpecialValuesIntoCache(Map<Sft, List> map, Frame frame, Slot slot, Facet facet, boolean bl) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("loading special values frame = " + frame.getFrameID() + " slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
        }
        List list = this._delegate.getValues(frame, slot, facet, bl);
        this.insert(map, slot, null, false, new ArrayList(list));
        return list;
    }

    private void setCacheValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        TransactionMonitor transactionMonitor2;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Setting cache values for frame = " + frame.getFrameID() + " slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
            if (collection == null) {
                this.log.finest("null values put");
            } else {
                for (TransactionMonitor transactionMonitor2 : collection) {
                    if (transactionMonitor2 instanceof Frame) {
                        this.log.finest("\tFrame Value = " + ((Frame)((Object)transactionMonitor2)).getFrameID());
                        continue;
                    }
                    this.log.finest("Value = " + transactionMonitor2);
                }
            }
        }
        Map<Sft, List> map = this.lookup(frame);
        transactionMonitor2 = this.getTransactionStatusMonitor();
        if (map != null) {
            this.insert(map, slot, facet, bl, new ArrayList(collection));
        }
    }

    private void insert(Map<Sft, List> map, Slot slot, Facet facet, boolean bl, List list) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Inserting cache values for  slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
        }
        if (list == null) {
            this.remove(map, slot, facet, bl);
        } else {
            map.put(new Sft(slot, facet, bl), list);
        }
    }

    private void remove(Map<Sft, List> map, Slot slot, Facet facet, boolean bl) {
        Sft sft = new Sft(slot, facet, bl);
        map.remove(sft);
    }

    private void addCacheValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        ArrayList arrayList;
        Object object;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Adding cache values for frame = " + frame.getFrameID() + " slot = " + slot.getFrameID() + " facet = " + (facet != null ? facet.getFrameID() : null) + " isTemplate = " + bl);
            if (collection == null) {
                this.log.finest("null values put");
            } else {
                object = collection.iterator();
                while (object.hasNext()) {
                    arrayList = object.next();
                    if (arrayList instanceof Frame) {
                        this.log.finest("\tFrame Value = " + ((Frame)((Object)arrayList)).getFrameID());
                        continue;
                    }
                    this.log.finest("Value = " + arrayList);
                }
            }
        }
        if ((object = this.lookup(frame)) != null) {
            arrayList = this.lookup((Map<Sft, List>)object, slot, facet, bl);
            if (arrayList == null) {
                if (!ValueCachingNarrowFrameStore.isSpecial(slot, facet, bl)) {
                    this.insert((Map<Sft, List>)object, slot, facet, bl, new ArrayList(collection));
                }
            } else {
                arrayList = new ArrayList(arrayList);
                arrayList.addAll(collection);
                this.insert((Map<Sft, List>)object, slot, facet, bl, arrayList);
            }
        }
    }

    private void removeCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        ArrayList arrayList;
        Map<Sft, List> map = this.lookup(frame);
        if (map != null && (arrayList = this.lookup(map, slot, facet, bl)) != null) {
            arrayList = new ArrayList(arrayList);
            arrayList.remove(object);
            this.insert(map, slot, facet, bl, arrayList);
        }
    }

    private void moveCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        ArrayList arrayList;
        Map<Sft, List> map = this.lookup(frame);
        if (map != null && (arrayList = this.lookup(map, slot, facet, bl)) != null) {
            arrayList = new ArrayList(arrayList);
            Object e = arrayList.remove(n);
            arrayList.add(n2, e);
            this.insert(map, slot, facet, bl, arrayList);
        }
    }

    private void deleteCacheFrame(Frame frame) {
        this.getFrameToSftToValuesMap().remove(frame);
        for (Frame frame2 : this.getFrameToSftToValuesMap().keySet()) {
            Map map = (Map)this.getFrameToSftToValuesMap().get(frame2);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                Sft sft = (Sft)entry.getKey();
                ArrayList arrayList = (ArrayList)entry.getValue();
                if (ValueCachingNarrowFrameStore.contains(sft, frame)) {
                    this.getFrameToSftToValuesMap().remove(frame2);
                    this.markWritten(frame2);
                    continue;
                }
                if (!arrayList.contains(frame)) continue;
                arrayList = new ArrayList(arrayList);
                arrayList.remove(frame);
                this.insert(map, sft.getSlot(), sft.getFacet(), sft.isTemplateSlot(), arrayList);
                this.markWritten(frame2);
            }
        }
    }

    private static boolean contains(Sft sft, Frame frame) {
        return frame.equals(sft.getSlot()) || frame.equals(sft.getFacet());
    }

    private Map<Sft, List> loadFrameIntoCache(Frame frame) {
        Map<Sft, List> map = this._framedb.getFrameValues(frame);
        this.getFrameToSftToValuesMap().put(frame, map);
        return map;
    }

    public void clearCache() {
        this.valuesMap.clear();
        for (CacheMap<Frame, Map<Sft, List>> cacheMap : this.transactedValuesMap.values()) {
            cacheMap.clear();
        }
        this.transactedWrites.clear();
    }

    @Override
    public String getName() {
        return this._delegate.getName();
    }

    @Override
    public void setName(String string) {
        this._delegate.setName(string);
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this._delegate;
    }

    @Override
    public FrameID generateFrameID() {
        return this._delegate.generateFrameID();
    }

    @Override
    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    @Override
    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    public Set getFrames() {
        return this.getDelegate().getFrames();
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list;
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        Map<Sft, List> map = this.lookup(frame);
        if (map == null) {
            map = this.loadFrameIntoCache(frame);
        }
        if ((list = this.lookup(map, slot, facet, bl)) == null) {
            list = ValueCachingNarrowFrameStore.isSpecial(slot, facet, bl) ? this.loadSpecialValuesIntoCache(map, frame, slot, facet, bl) : Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n;
        Map<Sft, List> map = this.lookup(frame);
        if (map == null) {
            TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
            n = this.getDelegate().getValuesCount(frame, slot, facet, bl);
            if (n < 10) {
                map = this.loadFrameIntoCache(frame);
            }
        } else {
            List list = this.lookup(map, slot, facet, bl);
            n = list == null ? this.getDelegate().getValuesCount(frame, slot, facet, bl) : list.size();
        }
        return n;
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.addValues(frame, slot, facet, bl, collection);
        this.addCacheValues(frame, slot, facet, bl, collection);
        this.markWritten(frame);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        ArrayList arrayList = new ArrayList(this.getValues(frame, slot, facet, bl));
        Object e = arrayList.remove(n);
        arrayList.add(n2, e);
        this._delegate.setValues(frame, slot, facet, bl, arrayList);
        this.moveCacheValue(frame, slot, facet, bl, n, n2);
        this.markWritten(frame);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this._delegate.removeValue(frame, slot, facet, bl, object);
        this.removeCacheValue(frame, slot, facet, bl, object);
        this.markWritten(frame);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this._delegate.setValues(frame, slot, facet, bl, collection);
        this.setCacheValues(frame, slot, facet, bl, collection);
        this.markWritten(frame);
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        return this._delegate.getFrames(slot, facet, bl, object);
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this._delegate.getFrame(frameID);
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        return this._delegate.getFramesWithAnyValue(slot, facet, bl);
    }

    public Set getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        return this._delegate.getMatchingFrames(slot, facet, bl, string, n);
    }

    public Set getReferences(Object object) {
        return this._delegate.getReferences(object);
    }

    public Set getMatchingReferences(String string, int n) {
        return this._delegate.getMatchingReferences(string, n);
    }

    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        this._delegate.executeQuery(query, queryCallback);
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.deleteCacheFrame(frame);
        this._delegate.deleteFrame(frame);
        this.markWritten(frame);
    }

    @Override
    public void close() {
        this._delegate.close();
        this._delegate = null;
        this.valuesMap = null;
        this.transactedValuesMap = null;
        this.transactedWrites = null;
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.clearCache();
        this.getDelegate().replaceFrame(frame);
    }

    @Override
    public boolean beginTransaction(String string) {
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        try {
            if (!transactionMonitor.inTransaction()) {
                TransactionIsolationLevel transactionIsolationLevel = transactionMonitor.getTransationIsolationLevel();
                CacheMap cacheMap = null;
                if (transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
                    cacheMap = new CacheMap();
                    RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
                    this.transactedValuesMap.put(remoteSession, cacheMap);
                }
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Exception caught opening transaction", throwable);
            Log.getLogger().warning("Trying to be conservative...");
            this.clearCache();
        }
        return this.getDelegate().beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        int n = transactionMonitor.getNesting();
        boolean bl = this.getDelegate().commitTransaction();
        try {
            Object object;
            if (bl && n == 1) {
                object = transactionMonitor.getTransationIsolationLevel();
                RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
                Set<Frame> set = this.transactedWrites.get(remoteSession);
                if (set != null) {
                    if (((Enum)object).compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
                        for (Frame frame : set) {
                            this.valuesMap.remove(frame);
                        }
                    }
                    if (object == TransactionIsolationLevel.READ_COMMITTED) {
                        for (Frame frame : set) {
                            for (RemoteSession remoteSession2 : this.transactedValuesMap.keySet()) {
                                this.transactedValuesMap.get(remoteSession2).remove(frame);
                            }
                        }
                    }
                }
            }
            if (n == 1) {
                object = ServerFrameStore.getCurrentSession();
                this.transactedValuesMap.remove(object);
                this.transactedWrites.remove(object);
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Exception caught closing transaction", throwable);
            this.clearCache();
        }
        return bl;
    }

    @Override
    public boolean rollbackTransaction() {
        TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
        int n = transactionMonitor.getNesting();
        boolean bl = this.getDelegate().rollbackTransaction();
        if (n == 1) {
            if (!bl) {
                this.clearCache();
            }
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            this.transactedValuesMap.remove(remoteSession);
            this.transactedWrites.remove(remoteSession);
        }
        return bl;
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public void reinitialize() {
        this.clearCache();
        if (this.getDelegate() != null) {
            this.getDelegate().reinitialize();
        }
    }
}

