/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DatabaseWizardPage
extends WizardPage {
    private JTextField driverField;
    private JTextField urlField;
    private JTextField tableField;
    private JTextField usernameField;
    private JTextField passwordField;
    private JTextArea errorArea;
    private DatabasePlugin plugin;
    private static int MAX_TABLE_NAME_LENGTH = 20;

    public DatabaseWizardPage(Wizard wizard, DatabasePlugin databasePlugin) {
        super("datbase", wizard);
        this.plugin = databasePlugin;
        this.createComponents();
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents() {
        this.driverField = this.createTextField("database_wizard.driver");
        this.urlField = this.createTextField("database_wizard.url");
        this.tableField = this.createTextField("database_wizard.table");
        this.usernameField = this.createTextField("database_wizard.username");
        this.passwordField = this.createTextField("database_wizard.password");
        this.errorArea = ComponentFactory.createTextArea();
        this.errorArea.setEditable(false);
    }

    private JTextField createTextField(final String string) {
        String string2 = ApplicationProperties.getString(string);
        final JTextField jTextField = ComponentFactory.createTextField(string2);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DatabaseWizardPage.this.updateSetPageComplete();
                ApplicationProperties.setString(string, jTextField.getText());
            }
        });
        return jTextField;
    }

    private void updateSetPageComplete() {
        this.setErrorText(null);
        boolean bl = this.hasValidDriver() && this.hasValidUrl() && this.hasValidTable();
        this.setPageComplete(bl);
    }

    private boolean hasValidDriver() {
        boolean bl = false;
        String string = this.driverField.getText();
        if ((string = string.trim()).length() == 0) {
            this.setErrorText("Driver class required");
        } else {
            Class clazz = SystemUtilities.forName(string);
            boolean bl2 = bl = clazz != null;
            if (clazz == null) {
                this.setErrorText("Driver class not found");
            }
        }
        return bl;
    }

    private boolean hasValidUrl() {
        boolean bl = false;
        String string = this.urlField.getText();
        string = string.trim();
        String string2 = this.usernameField.getText();
        String string3 = this.passwordField.getText();
        if (string.length() == 0) {
            this.setErrorText("URL is required");
        } else if (string2.length() == 0) {
            this.setErrorText("Username is required");
        } else {
            try {
                Connection connection = DriverManager.getConnection(string, string2, string3);
                connection.close();
                bl = true;
            }
            catch (SQLException sQLException) {
                this.setErrorText("Invalid URL, username, or password:\n" + sQLException.getMessage());
            }
        }
        return bl;
    }

    private boolean hasValidTable() {
        boolean bl = false;
        String string = this.tableField.getText();
        if (string.length() == 0) {
            this.setErrorText("Table name is required.");
        } else if (string.length() > MAX_TABLE_NAME_LENGTH) {
            this.setErrorText("Table name is too long.");
        } else {
            bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                this.setErrorText("Invalid table name");
            }
        }
        return bl;
    }

    private void setErrorText(String string) {
        this.errorArea.setText(string);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        DatabaseWizardPage.addField(box, this.driverField, "JDBC Driver Class Name");
        DatabaseWizardPage.addField(box, this.urlField, "JDBC Driver URL");
        DatabaseWizardPage.addField(box, this.tableField, "Table");
        DatabaseWizardPage.addField(box, this.usernameField, "Username");
        DatabaseWizardPage.addField(box, this.passwordField, "Password");
        this.errorArea.setPreferredSize(new Dimension(10, 50));
        this.errorArea.setBackground(this.getBackground());
        box.add(Box.createVerticalStrut(20));
        box.add(ComponentFactory.createScrollPane(this.errorArea));
        this.add((Component)box, "North");
    }

    private static void addField(Box box, JComponent jComponent, String string) {
        box.add(new LabeledComponent(string, jComponent));
    }

    public void onFinish() {
        this.plugin.setDriver(this.driverField.getText());
        this.plugin.setTable(this.tableField.getText());
        this.plugin.setUsername(this.usernameField.getText());
        this.plugin.setPassword(this.passwordField.getText());
        this.plugin.setURL(this.urlField.getText());
    }
}

