/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase_Test;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.test.APITestCase;
import java.text.ParseException;
import java.util.Collection;

public class DatabaseKnowledgeBase_Test
extends APITestCase {
    public void testDBModficationSlots() throws ParseException {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DefaultKnowledgeBase_Test dkbt = new DefaultKnowledgeBase_Test();
            DefaultKnowledgeBase_Test.setDatabaseProject();
            dkbt.testModificationSlots();
        }
    }

    public void testGetDBFramesWithValue() {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Slot s1 = this.createMultiValuedSlot(ValueType.STRING);
            Slot s2 = this.createMultiValuedSlot(ValueType.INSTANCE);
            Cls a = this.createCls();
            a.addDirectTemplateSlot(s1);
            a.addDirectTemplateSlot(s2);
            Instance inst1 = this.createInstance(a);
            Instance inst2 = this.createInstance(a);
            Instance inst3 = this.createInstance(a);
            inst1.addOwnSlotValue(s1, "abc");
            inst2.addOwnSlotValue(s1, "abc");
            inst3.addOwnSlotValue(s1, "abc");
            inst2.addOwnSlotValue(s2, inst1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"string match", (int)3, (int)this.getDomainKB().getFramesWithValue(s1, null, false, "abc").size());
            DatabaseKnowledgeBase_Test.assertEquals((String)"frame match", (int)1, (int)this.getDomainKB().getFramesWithValue(s2, null, false, inst1).size());
        }
    }

    public void testGetMatchingDBReferences() {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Slot s = this.createMultiValuedSlot(ValueType.STRING);
            Cls a = this.createCls();
            a.addDirectTemplateSlot(s);
            Instance inst1 = this.createInstance(a);
            inst1.addOwnSlotValue(s, "zabcy");
            Instance inst2 = this.createInstance(a);
            inst2.addOwnSlotValue(s, "abcz");
            Instance inst3 = this.createInstance(a);
            inst3.addOwnSlotValue(s, "qqq");
            DatabaseKnowledgeBase_Test.assertEquals((String)"exact", (int)0, (int)this.getMatchCount("z"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"starts", (int)1, (int)this.getMatchCount("z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains", (int)2, (int)this.getMatchCount("*z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains insensitive", (int)2, (int)this.getMatchCount("*Z*"));
            DatabaseKnowledgeBase_Test.assertEquals((String)"contains 2", (int)2, (int)this.getMatchCount("*abc*"));
        }
    }

    private int getMatchCount(String s) {
        return this.getDomainKB().getMatchingReferences(s, -1).size();
    }

    public void testMatchOnPercentInDB() {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            String name1 = "foo %";
            String name2 = "foo abc";
            Slot nameSlot = this.getDomainKB().getSlot(":NAME");
            this.createCls(name1);
            this.createCls(name2);
            Collection frames = this.getDomainKB().getMatchingFrames(nameSlot, null, false, name1, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"matching size", (int)1, (int)frames.size());
            frames = this.getDomainKB().getReferences(name1, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"references size", (int)1, (int)frames.size());
        }
    }

    public void testMatchOnQuoteInDB() {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            String name1 = "foo's";
            Slot nameSlot = this.getDomainKB().getSlot(":NAME");
            this.createCls(name1);
            Collection frames = this.getDomainKB().getMatchingFrames(nameSlot, null, false, name1, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"matching size", (int)1, (int)frames.size());
            frames = this.getDomainKB().getReferences(name1, -1);
            DatabaseKnowledgeBase_Test.assertEquals((String)"references size", (int)1, (int)frames.size());
        }
    }

    public void testGetDBDirectInstances() {
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            DatabaseKnowledgeBase_Test.setDBType(dbt);
            if (!DatabaseKnowledgeBase_Test.dbConfigured()) continue;
            DatabaseKnowledgeBase_Test.setDatabaseProject();
            Cls cls = this.createCls();
            String name = cls.getName();
            this.createInstance(cls);
            this.createInstance(cls);
            this.createInstance(cls);
            DatabaseKnowledgeBase_Test.assertEquals((String)"direct instance count", (int)3, (int)cls.getDirectInstanceCount());
            DatabaseKnowledgeBase_Test.saveAndReload();
            cls = this.getCls(name);
            this.createInstance(cls);
            DatabaseKnowledgeBase_Test.assertEquals((String)"direct instance count after reload", (int)4, (int)cls.getDirectInstanceCount());
        }
    }
}

