/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.narrowframestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteClientInvocationHandler
implements InvocationHandler {
    private static transient Logger log;
    private KnowledgeBase kb;
    private RemoteServerNarrowFrameStore delegate;
    private RemoteSession session;
    private static Map<Method, Method> methodMap;

    public RemoteClientInvocationHandler(KnowledgeBase knowledgeBase, RemoteServerNarrowFrameStore remoteServerNarrowFrameStore, RemoteSession remoteSession) {
        this.kb = knowledgeBase;
        this.delegate = remoteServerNarrowFrameStore;
        this.session = remoteSession;
    }

    public NarrowFrameStore getNarrowFrameStore() {
        return (NarrowFrameStore)Proxy.newProxyInstance(NarrowFrameStore.class.getClassLoader(), new Class[]{NarrowFrameStore.class}, (InvocationHandler)this);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        int n;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client invoking remote operation " + method.getName() + " on object " + this.delegate.getClass());
            if (objectArray != null) {
                Object[] objectArray2 = objectArray;
                int n2 = objectArray2.length;
                for (n = 0; n < n2; ++n) {
                    object2 = objectArray2[n];
                    log.fine("\tArgument = " + object2);
                }
            } else {
                log.fine("No arguments");
            }
        }
        int n3 = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray3 = new Object[n3 + 1];
        for (n = 0; n < n3; ++n) {
            objectArray3[n] = objectArray[n];
        }
        objectArray3[n3] = this.session;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != (object2 = this.kb.getClass().getClassLoader())) {
            if (log.isLoggable(Level.FINE)) {
                Log.getLogger().fine("Changing loader from " + classLoader + " to " + object2);
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)object2);
        }
        try {
            Method method2 = methodMap.get(method);
            Object object3 = method2.invoke((Object)this.delegate, objectArray3);
            LocalizeUtils.localize(object3, this.kb);
            return object3;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RemoteException) {
                throw new RuntimeException(throwable);
            }
            throw throwable;
        }
    }

    static {
        Method[] methodArray;
        log = Log.getLogger(RemoteClientInvocationHandler.class);
        methodMap = new HashMap<Method, Method>();
        for (Method method : methodArray = NarrowFrameStore.class.getMethods()) {
            try {
                if (method.getName().equals("executeQuery") || method.getName().equals("reinitialize")) continue;
                Class<?>[] classArray = method.getParameterTypes();
                Class[] classArray2 = new Class[classArray.length + 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray2[i] = classArray[i];
                }
                classArray2[classArray.length] = RemoteSession.class;
                Method method2 = RemoteServerNarrowFrameStore.class.getMethod(method.getName(), classArray2);
                methodMap.put(method, method2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mapped " + method + " to " + method2);
                }
            }
            catch (Exception exception) {
                log.warning("NarrowFrameStore method " + method + " not found in RemoteServerNarrowFrameStore");
            }
            method.getParameterTypes();
        }
    }
}

