/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedProtegeInstanceImpl {
    MetaProjectImpl mp;
    private Instance i;
    private MetaProject.ClsEnum cls;

    public WrappedProtegeInstanceImpl() {
    }

    public WrappedProtegeInstanceImpl(MetaProjectImpl metaProjectImpl, Instance instance, MetaProject.ClsEnum clsEnum) {
        if (!instance.hasType(metaProjectImpl.getCls(clsEnum))) {
            throw new IllegalArgumentException("" + instance + " should be of type " + (Object)((Object)clsEnum));
        }
        this.i = instance;
        this.cls = clsEnum;
        this.mp = metaProjectImpl;
    }

    public MetaProjectImpl getMetaProject() {
        return this.mp;
    }

    public Instance getProtegeInstance() {
        return this.i;
    }

    public MetaProject.ClsEnum getCls() {
        return this.cls;
    }

    protected Set getSlotValues(MetaProject.SlotEnum slotEnum, MetaProject.ClsEnum clsEnum) {
        HashSet<WrappedProtegeInstanceImpl> hashSet = new HashSet<WrappedProtegeInstanceImpl>();
        for (Object e : this.i.getOwnSlotValues(this.mp.getSlot(slotEnum))) {
            hashSet.add(this.mp.wrapInstance(clsEnum, (Instance)e));
        }
        return hashSet;
    }

    protected Object getSlotValue(MetaProject.SlotEnum slotEnum, MetaProject.ClsEnum clsEnum) {
        Object object = this.i.getOwnSlotValue(this.mp.getSlot(slotEnum));
        if (object != null) {
            return this.mp.wrapInstance(clsEnum, (Instance)object);
        }
        return null;
    }

    protected void setSlotValuesAsProtegeInstances(MetaProject.SlotEnum slotEnum, Collection collection) {
        Slot slot = this.mp.getSlot(slotEnum);
        this.i.setDirectOwnSlotValues(slot, this.getProtegeCollection(collection));
    }

    protected void setSlotValue(MetaProject.SlotEnum slotEnum, Object object) {
        Slot slot = this.mp.getSlot(slotEnum);
        if (object instanceof WrappedProtegeInstanceImpl) {
            object = ((WrappedProtegeInstanceImpl)object).getProtegeInstance();
        }
        this.i.setDirectOwnSlotValue(slot, object);
    }

    protected void addSlotValue(MetaProject.SlotEnum slotEnum, Object object) {
        Slot slot = this.mp.getSlot(slotEnum);
        if (object instanceof WrappedProtegeInstanceImpl) {
            Instance instance = ((WrappedProtegeInstanceImpl)object).getProtegeInstance();
            if (instance == null) {
                throw new OntologyException("Failed to add for " + this.i.getName() + " slot " + slot.getName() + " value: " + object + ". Probably " + object + " is not in the metaproject.");
            }
            this.i.addOwnSlotValue(slot, instance);
        } else {
            this.i.addOwnSlotValue(slot, object);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof WrappedProtegeInstanceImpl)) {
            return false;
        }
        WrappedProtegeInstanceImpl wrappedProtegeInstanceImpl = (WrappedProtegeInstanceImpl)object;
        return this.mp == wrappedProtegeInstanceImpl.mp && this.getProtegeInstance().equals(wrappedProtegeInstanceImpl.getProtegeInstance());
    }

    public int hashCode() {
        return this.getProtegeInstance().hashCode();
    }

    public Collection<Instance> getProtegeCollection(Collection collection) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (Object e : collection) {
            if (!(e instanceof WrappedProtegeInstanceImpl)) continue;
            WrappedProtegeInstanceImpl wrappedProtegeInstanceImpl = (WrappedProtegeInstanceImpl)e;
            arrayList.add(wrappedProtegeInstanceImpl.getProtegeInstance());
        }
        return arrayList;
    }
}

