/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInstanceImpl
extends WrappedProtegeInstanceImpl
implements ProjectInstance,
Serializable {
    private static final long serialVersionUID = 8666270295698053695L;
    String name;
    String location;
    Set<GroupOperation> operations;

    protected ProjectInstanceImpl(MetaProjectImpl metaProjectImpl, Instance instance) {
        super(metaProjectImpl, instance, MetaProject.ClsEnum.Project);
        this.location = (String)instance.getOwnSlotValue(metaProjectImpl.getSlot(MetaProject.SlotEnum.location));
        ProjectInstanceImpl.localizeLocation(this.location);
        this.name = (String)instance.getOwnSlotValue(metaProjectImpl.getSlot(MetaProject.SlotEnum.name));
        this.operations = this.getSlotValues(MetaProject.SlotEnum.allowedGroupOperation, MetaProject.ClsEnum.GroupOperation);
    }

    public ProjectInstanceImpl(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private static String localizeLocation(String string) {
        if (string == null) {
            return null;
        }
        if (File.separatorChar != '\\') {
            string = string.replace('\\', File.separatorChar);
        }
        return string;
    }

    @Override
    public Set<GroupOperation> getAllowedGroupOperations() {
        return this.operations;
    }

    @Override
    public ProjectInstance getAnnotationProject() {
        return (ProjectInstance)this.getSlotValue(MetaProject.SlotEnum.annotationProject, MetaProject.ClsEnum.Project);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ProjectInstance)) {
            return false;
        }
        ProjectInstance projectInstance = (ProjectInstance)object;
        return this.name.equals(projectInstance.getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void setLocation(String string) {
        this.location = string;
        this.setSlotValue(MetaProject.SlotEnum.location, string);
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.setSlotValue(MetaProject.SlotEnum.name, string);
    }

    @Override
    public User getOwner() {
        return (User)this.getSlotValue(MetaProject.SlotEnum.owner, MetaProject.ClsEnum.User);
    }

    @Override
    public void setAllowedGroupOperations(Collection<GroupOperation> collection) {
        this.setSlotValuesAsProtegeInstances(MetaProject.SlotEnum.allowedGroupOperation, collection);
    }

    @Override
    public void addAllowedGroupOperations(GroupOperation groupOperation) {
        this.operations.add(groupOperation);
        this.addSlotValue(MetaProject.SlotEnum.allowedGroupOperation, groupOperation);
    }

    @Override
    public void setAnnotationProject(ProjectInstance projectInstance) {
        Project project = this.getProtegeInstance().getProject();
        Slot slot = project.getKnowledgeBase().getSlot(MetaProject.SlotEnum.annotationProject.name());
        if (slot == null) {
            slot = project.getKnowledgeBase().createSlot(MetaProject.SlotEnum.annotationProject.name());
            slot.setValueType(ValueType.INSTANCE);
            slot.setAllowedClses(CollectionUtilities.createCollection(project.getKnowledgeBase().getCls(MetaProject.ClsEnum.Project.name())));
        }
        this.setSlotValue(MetaProject.SlotEnum.annotationProject, projectInstance);
    }

    @Override
    public void setOwner(User user) {
        this.setSlotValue(MetaProject.SlotEnum.owner, user);
    }

    @Override
    public String getDescription() {
        Object object = this.getProtegeInstance().getOwnSlotValue(((MetaProjectImpl)this.getMetaProject()).getSlot(MetaProject.SlotEnum.description));
        if (!(object instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProject.SlotEnum.name) + " slot should take on string values");
        }
        return (String)object;
    }

    @Override
    public void setDescription(String string) {
        this.setSlotValue(MetaProject.SlotEnum.description, string);
    }
}

