/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyImpl
implements Policy {
    MetaProjectImpl mp;

    public PolicyImpl(MetaProjectImpl metaProjectImpl) {
        this.mp = metaProjectImpl;
    }

    private User fillFields(User user) {
        for (User user2 : this.mp.getUsers()) {
            if (!user.getName().equals(user2.getName())) continue;
            return user2;
        }
        throw new IllegalArgumentException("Unknown user " + user);
    }

    private ProjectInstance fillFields(ProjectInstance projectInstance) {
        for (ProjectInstance projectInstance2 : this.mp.getProjects()) {
            if (!projectInstance2.getName().equals(projectInstance.getName())) continue;
            return projectInstance2;
        }
        throw new IllegalArgumentException("Unknown project " + projectInstance);
    }

    @Override
    public boolean isOperationAuthorized(User user, Operation operation, ProjectInstance projectInstance) {
        if (!this.getKnownOperations().contains(operation)) {
            return true;
        }
        user = this.fillFields(user);
        projectInstance = this.fillFields(projectInstance);
        Set<Group> set = user.getGroups();
        for (GroupOperation groupOperation : projectInstance.getAllowedGroupOperations()) {
            if (!set.contains(groupOperation.getAllowedGroup()) || !groupOperation.getAllowedOperations().contains(operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Operation> getAllowedOperations(User user, ProjectInstance projectInstance) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        user = this.fillFields(user);
        projectInstance = this.fillFields(projectInstance);
        Set<Group> set = user.getGroups();
        for (GroupOperation groupOperation : projectInstance.getAllowedGroupOperations()) {
            if (!set.contains(groupOperation.getAllowedGroup())) continue;
            hashSet.addAll(groupOperation.getAllowedOperations());
        }
        return hashSet;
    }

    @Override
    public Set<Operation> getKnownOperations() {
        return this.mp.getOperations();
    }
}

