/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.framestore.background.State;
import edu.stanford.smi.protege.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateMachine {
    private static transient Logger log = Log.getLogger(StateMachine.class);
    private FrameStore fs;
    private final Object kbLock;
    private Map<StateAndSlot, State> transitionMap = new HashMap<StateAndSlot, State>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachine(FrameStore frameStore, Object object) {
        this.fs = frameStore;
        this.kbLock = object;
        Object object2 = object;
        synchronized (object2) {
            this.addTransition(State.Start, ":DIRECT-SUPERCLASSES", State.OwlExpr);
            this.addTransition(State.Start, "owl:equivalentClass", State.OwlExpr);
            this.addTransition(State.OwlExpr, "owl:intersectionOf", State.RDFList);
            this.addTransition(State.OwlExpr, ":DIRECT-SUPERCLASSES", State.End);
            this.addTransition(State.OwlExpr, "owl:someValuesFrom", State.End);
            this.addTransition(State.RDFList, "rdf:rest", State.RDFList);
            this.addTransition(State.RDFList, "rdf:first", State.OwlExpr);
        }
    }

    private void addTransition(State state, String string, State state2) {
        block4: {
            Slot slot = null;
            try {
                Frame frame = this.fs.getFrame(string);
                if (frame == null || !(frame instanceof Slot)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("frame found for transition " + (Object)((Object)state) + ", " + string + "/" + frame + " -> " + (Object)((Object)state2) + " but not a slot");
                    }
                    return;
                }
                slot = (Slot)frame;
                this.transitionMap.put(new StateAndSlot(state, slot), state2);
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.fine("Exception caught creating transition " + (Object)((Object)state) + ", " + string + " -> " + (Object)((Object)state2) + ": " + exception);
                log.log(Level.FINER, "Exception = ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State nextState(State state, Slot slot, Frame frame) {
        State state2 = this.transitionMap.get(new StateAndSlot(state, slot));
        Object object = this.kbLock;
        synchronized (object) {
            if (state2 != null && state2.entryCondition(this.fs, frame)) {
                return state2;
            }
        }
        return null;
    }

    private class StateAndSlot {
        private State state;
        private Slot slot;

        public Slot getSlot() {
            return this.slot;
        }

        public State getState() {
            return this.state;
        }

        public StateAndSlot(State state, Slot slot) {
            this.state = state;
            this.slot = slot;
        }

        public int hashCode() {
            return this.state.ordinal() + this.slot.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof StateAndSlot)) {
                return false;
            }
            StateAndSlot stateAndSlot = (StateAndSlot)object;
            return stateAndSlot.state.equals((Object)this.state) && stateAndSlot.slot.equals(this.slot);
        }
    }
}

