/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.RemoteClientStats;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.update.FrameEvaluationCompleted;
import edu.stanford.smi.protege.server.update.FrameEvaluationPartial;
import edu.stanford.smi.protege.server.update.FrameEvaluationStarted;
import edu.stanford.smi.protege.server.update.FrameRead;
import edu.stanford.smi.protege.server.update.FrameWrite;
import edu.stanford.smi.protege.server.update.InvalidateCacheUpdate;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.RemoveCacheUpdate;
import edu.stanford.smi.protege.server.update.RemoveFrameCache;
import edu.stanford.smi.protege.server.update.SftUpdate;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClientFrameStore
implements FrameStore {
    private static transient Logger log = Log.getLogger(RemoteClientFrameStore.class);
    private static transient Logger cacheLog = ServerFrameStore.cacheLog;
    private static Method getEventsMethod;
    private static Method executeProtegeJobMethod;
    private KnowledgeBase kb;
    private ClassLoader kbClassLoader;
    private SystemFrames systemFrames;
    private RemoteSession session;
    private RemoteServer server;
    private RemoteServerFrameStore proxiedDelegate;
    private RemoteServerFrameStore remoteDelegate;
    private TransactionIsolationLevel transactionLevel;
    private int transactionNesting = 0;
    private Map<Frame, CacheStatus> cacheStatus = new HashMap<Frame, CacheStatus>();
    private Map<Frame, Map<Sft, List>> cache = new HashMap<Frame, Map<Sft, List>>();
    private Map<Frame, Map<Sft, List>> sessionCache = new HashMap<Frame, Map<Sft, List>>();
    private Map<String, Frame> frameNameToFrameMap = new HashMap<String, Frame>();
    private RemoteClientStatsImpl stats = new RemoteClientStatsImpl();
    private Set<Operation> allowedOps;
    private Set<Operation> knownOps;

    public RemoteClientFrameStore(String string, String string2, String string3, String string4, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.server = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            String string5 = SystemUtilities.getMachineIpAddress();
            this.session = this.server.openSession(string2, string5, string3);
            RemoteServerProject remoteServerProject = this.server.openProject(string4, this.session);
            this.remoteDelegate = remoteServerProject.getDomainKbFrameStore(this.session);
            this.kb = knowledgeBase;
            this.initialize(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            log.log(Level.FINE, "Exception caught", exception);
        }
    }

    public RemoteClientFrameStore(RemoteServer remoteServer, RemoteServerFrameStore remoteServerFrameStore, RemoteSession remoteSession, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.server = remoteServer;
            this.session = remoteSession;
            this.kb = knowledgeBase;
            this.remoteDelegate = remoteServerFrameStore;
            this.initialize(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            log.log(Level.FINE, "Exception caught", exception);
        }
    }

    public void initialize(boolean bl) throws RemoteException {
        this.systemFrames = this.kb.getSystemFrames();
        this.kbClassLoader = this.kb.getClass().getClassLoader();
        this.startHeartbeatThread();
        this.preload(bl);
    }

    private void startHeartbeatThread() {
        if (ServerProperties.heartbeatDisabled()) {
            return;
        }
        new Thread("Heartbeat thread [" + this.kb + "]"){

            public void run() {
                try {
                    while (true) {
                        RemoteServerFrameStore remoteServerFrameStore;
                        if ((remoteServerFrameStore = RemoteClientFrameStore.this.getRemoteDelegate()) != null) {
                            remoteServerFrameStore.heartBeat(RemoteClientFrameStore.this.session);
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (ServerSessionLost serverSessionLost) {
                    Log.emptyCatchBlock(serverSessionLost);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.SEVERE, "Heartbeat thread died - can't survive the heart for long...", exception);
                }
            }
        }.start();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public synchronized RemoteServerFrameStore getRemoteDelegate() {
        if (this.proxiedDelegate == null) {
            this.fixLoader();
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.this;
                    synchronized (remoteClientFrameStore) {
                        if (!method.equals(executeProtegeJobMethod)) {
                            RemoteClientFrameStore.this.fixLoader();
                        } else {
                            ((ProtegeJob)objectArray[0]).fixLoader();
                        }
                        try {
                            return method.invoke((Object)RemoteClientFrameStore.this.remoteDelegate, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getCause();
                        }
                    }
                }
            };
            this.proxiedDelegate = (RemoteServerFrameStore)Proxy.newProxyInstance(this.kbClassLoader, new Class[]{RemoteServerFrameStore.class}, invocationHandler);
        }
        return this.proxiedDelegate;
    }

    public Map<RemoteSession, Boolean> getUserInfo() {
        try {
            return this.getRemoteDelegate().getUserInfo();
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.WARNING, "Exception caught retrieving user data from remote server", remoteException);
            return new HashMap<RemoteSession, Boolean>();
        }
    }

    public FrameCalculatorStats getServerStats() {
        try {
            return this.getRemoteDelegate().getStats();
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.INFO, "Remote exception getting server stats", remoteException);
            return null;
        }
    }

    public synchronized RemoteClientStats getClientStats() {
        return this.stats;
    }

    private void fixLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != (classLoader = this.kbClassLoader)) {
            if (log.isLoggable(Level.FINEST)) {
                Log.getLogger().finest("Changing loader from " + classLoader2 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public void setDelegate(FrameStore frameStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    @Override
    public void reinitialize() {
    }

    private static RuntimeException convertException(Exception exception) {
        return new RuntimeException(exception);
    }

    @Override
    public int getClsCount() {
        try {
            return this.getRemoteDelegate().getClsCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSlotCount() {
        try {
            return this.getRemoteDelegate().getSlotCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFacetCount() {
        try {
            return this.getRemoteDelegate().getFacetCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSimpleInstanceCount() {
        try {
            return this.getRemoteDelegate().getSimpleInstanceCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFrameCount() {
        try {
            return this.getRemoteDelegate().getFrameCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private void localize(Object object) {
        LocalizeUtils.localize(object, this.kb);
    }

    @Override
    public Set<Cls> getClses() {
        try {
            Set<Cls> set = this.getRemoteDelegate().getClses(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Slot> getSlots() {
        Cls cls = this.getSystemFrames().getRootSlotMetaCls();
        return this.getInstances(cls);
    }

    @Override
    public Set<Facet> getFacets() {
        try {
            Set<Facet> set = this.getRemoteDelegate().getFacets(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Frame> getFrames() {
        try {
            Set<Frame> set = this.getRemoteDelegate().getFrames(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        try {
            Frame frame = this.getRemoteDelegate().getFrame(frameID, this.session);
            this.localize(frame);
            return frame;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Frame getFrame(String string) {
        try {
            boolean bl = true;
            Frame frame = this.frameNameToFrameMap.get(string);
            if (frame == null) {
                bl = this.frameNameToFrameMap.containsKey(string);
            }
            if (frame == null && !bl) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cache miss for frame named " + string);
                }
                RemoteResponse<Frame> remoteResponse = this.getRemoteDelegate().getFrame(string, this.session);
                this.processValueUpdate(remoteResponse);
                frame = remoteResponse.getResponse();
            }
            return frame;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized String getFrameName(Frame frame) {
        try {
            List list = this.getCacheDirectOwnSlotValues(frame, this.getSystemFrames().getNameSlot());
            return (String)CollectionUtilities.getFirstItem(list);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setFrameName(Frame frame, String string) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setFrameName(frame, string, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        try {
            RemoteResponse<Cls> remoteResponse = this.getRemoteDelegate().createCls(frameID, string, collection, collection2, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        try {
            RemoteResponse<Slot> remoteResponse = this.getRemoteDelegate().createSlot(frameID, string, collection, collection2, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl) {
        try {
            RemoteResponse<Facet> remoteResponse = this.getRemoteDelegate().createFacet(frameID, string, collection, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        try {
            RemoteResponse<SimpleInstance> remoteResponse = this.getRemoteDelegate().createSimpleInstance(frameID, string, collection, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteCls(Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteCls(cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteSlot(Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteSlot(slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteFacet(Facet facet) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteFacet(facet, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteSimpleInstance(simpleInstance, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Slot> getOwnSlots(Frame frame) {
        return this.getCacheOwnSlots(frame);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getCacheOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot).size();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectOwnSlotValue(frame, slot, n, n2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectOwnSlotValues(frame, slot, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getOwnFacets(Frame frame, Slot slot) {
        return this.getCacheOwnFacets(frame, slot);
    }

    @Override
    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getCacheOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Set getTemplateSlots(Cls cls) {
        return this.getCacheTemplateSlots(cls);
    }

    @Override
    public synchronized List getDirectTemplateSlots(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectTemplateSlotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectDomain(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectDomainSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getDomain(Slot slot) {
        try {
            return this.getCacheDomain(slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateSlots(cls, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateSlots(cls, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectTemplateSlot(cls, slot, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getCacheTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        try {
            return this.getCacheValues(cls, slot, this.getSystemFrames().getValuesFacet(), true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectTemplateSlotValues(cls, slot, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        try {
            Set<Facet> set = this.getRemoteDelegate().getTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectTemplateFacetOverrides(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getCacheTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        try {
            return this.getCacheValues(cls, slot, facet, true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<Cls> getDirectSuperclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSuperclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private SystemFrames getSystemFrames() {
        return this.systemFrames;
    }

    @Override
    public synchronized List<Cls> getDirectSubclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Cls> getSubclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls cls2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectSuperclass(cls, cls2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls cls2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectSuperclass(cls, cls2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectSubclass(cls, cls2, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectSuperslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSuperslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectSubslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSubslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot slot2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectSuperslot(slot, slot2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot slot2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectSuperslot(slot, slot2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectSubslot(slot, slot2, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectTypes(Instance instance) {
        try {
            return this.getCacheDirectOwnSlotValues(instance, this.getSystemFrames().getDirectTypesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getTypes(Instance instance) {
        try {
            return this.getCacheOwnSlotValueClosure(this.getDirectTypes(instance), this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<Instance> getDirectInstances(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectInstancesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Instance> getInstances(Cls cls) {
        RemoteResponse<Set<Instance>> remoteResponse;
        HashSet<Cls> hashSet = new HashSet<Cls>();
        hashSet.addAll(this.getSubclasses(cls));
        hashSet.add(cls);
        HashSet<Instance> hashSet2 = new HashSet<Instance>();
        HashSet<Cls> hashSet3 = new HashSet<Cls>();
        for (Cls cls2 : hashSet) {
            if (this.isCached(cls2, this.getSystemFrames().getDirectInstancesSlot(), null, false)) {
                hashSet2.addAll(this.getDirectInstances(cls2));
                continue;
            }
            hashSet3.add(cls2);
        }
        if (hashSet3.isEmpty()) {
            return hashSet2;
        }
        if (hashSet3.size() == 1) {
            remoteResponse = (Cls)hashSet3.iterator().next();
            hashSet2.addAll(this.getDirectInstances((Cls)((Object)remoteResponse)));
            return hashSet2;
        }
        try {
            remoteResponse = this.getRemoteDelegate().getInstances(cls, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectType(instance, cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectType(instance, cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls cls, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectType(instance, cls, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<AbstractEvent> getEvents() {
        if (this.transactionNesting > 0) {
            return new ArrayList<AbstractEvent>();
        }
        List<AbstractEvent> list = null;
        try {
            RemoteResponse<List<AbstractEvent>> remoteResponse = this.getRemoteDelegate().getEvents(this.session);
            this.processValueUpdate(remoteResponse);
            list = remoteResponse.getResponse();
            return list;
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught - local cache may be out of date", remoteException);
            throw new RuntimeException(remoteException);
        }
    }

    @Override
    public void executeQuery(final Query query, final QueryCallback queryCallback) {
        new Thread("Remote Client Callback thread"){

            public void run() {
                try {
                    RemoteResponse<Set<Frame>> remoteResponse = RemoteClientFrameStore.this.getRemoteDelegate().executeQuery(query, RemoteClientFrameStore.this.session);
                    RemoteClientFrameStore.this.processValueUpdate(remoteResponse);
                    queryCallback.provideQueryResults(remoteResponse.getResponse());
                }
                catch (OntologyException ontologyException) {
                    queryCallback.handleError(ontologyException);
                }
                catch (ProtegeIOException protegeIOException) {
                    queryCallback.handleError(protegeIOException);
                }
                catch (RemoteException remoteException) {
                    Log.getLogger().log(Level.WARNING, "Exception accessing remote host", remoteException);
                    queryCallback.handleError(new ProtegeIOException(remoteException));
                }
                catch (ProtegeError protegeError) {
                    queryCallback.handleError(protegeError);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.WARNING, "Developer error", throwable);
                    queryCallback.handleError(new ProtegeError(throwable));
                }
            }
        }.start();
    }

    @Override
    public synchronized Set getReferences(Object object) {
        try {
            Set set = this.getRemoteDelegate().getReferences(object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingBrowserText(string, collection, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getMatchingReferences(String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getMatchingReferences(string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithDirectOwnSlotValue(slot, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithAnyDirectOwnSlotValue(slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateSlotValue(slot, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithAnyDirectTemplateSlotValue(slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        try {
            return this.getCacheClosure(frame, slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean beginTransaction(String string) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Begin Transaction");
        }
        try {
            ++this.transactionNesting;
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().beginTransaction(string, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean commitTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Commit Transaction");
        }
        try {
            --this.transactionNesting;
            if (this.transactionNesting == 0) {
                this.sessionCache = new HashMap<Frame, Map<Sft, List>>();
            }
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().commitTransaction(this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean rollbackTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Rollback Transaction");
        }
        try {
            --this.transactionNesting;
            if (this.transactionNesting == 0) {
                this.sessionCache = new HashMap<Frame, Map<Sft, List>>();
            }
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().rollbackTransaction(this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        throw new UnsupportedOperationException("Shouldn't be doing this on the client side");
    }

    private static RemoteClientFrameStore getMeFromKb(KnowledgeBase knowledgeBase) {
        if (!(knowledgeBase instanceof DefaultKnowledgeBase)) {
            return null;
        }
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        for (FrameStore frameStore = defaultKnowledgeBase.getHeadFrameStore(); frameStore != null; frameStore = frameStore.getDelegate()) {
            if (!(frameStore instanceof RemoteClientFrameStore)) continue;
            return (RemoteClientFrameStore)frameStore;
        }
        return null;
    }

    public static TransactionIsolationLevel getTransactionIsolationLevel(KnowledgeBase knowledgeBase) throws TransactionException {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(knowledgeBase);
        if (remoteClientFrameStore == null) {
            return TransactionIsolationLevel.NONE;
        }
        return remoteClientFrameStore.getTransactionIsolationLevel();
    }

    public synchronized TransactionIsolationLevel getTransactionIsolationLevel() throws TransactionException {
        if (this.transactionLevel != null) {
            return this.transactionLevel;
        }
        try {
            this.transactionLevel = this.getRemoteDelegate().getTransactionIsolationLevel();
            return this.transactionLevel;
        }
        catch (RemoteException remoteException) {
            throw new TransactionException(remoteException);
        }
    }

    public static boolean setTransactionIsolationLevel(KnowledgeBase knowledgeBase, TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(knowledgeBase);
        if (remoteClientFrameStore == null) {
            return false;
        }
        return remoteClientFrameStore.setTransactionIsolationLevel(transactionIsolationLevel);
    }

    public synchronized boolean setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        try {
            this.transactionLevel = null;
            return this.getRemoteDelegate().setTransactionIsolationLevel(transactionIsolationLevel);
        }
        catch (RemoteException remoteException) {
            throw new TransactionException(remoteException);
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.server != null) {
                this.server.closeSession(this.session);
                this.server = null;
            }
            this.remoteDelegate = null;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    public synchronized void preload(boolean bl) throws RemoteException {
        boolean bl2 = ServerProperties.skipPreload();
        if (bl2) {
            return;
        }
        Log.getLogger().config("Preloading frame values");
        Set<String> set = ServerProperties.preloadUserFrames();
        OntologyUpdate ontologyUpdate = this.getRemoteDelegate().preload(set, bl, this.session);
        this.processValueUpdate(ontologyUpdate);
    }

    private Set getCacheOwnSlotValueClosure(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheClosure(frame, slot);
    }

    private Set getCacheOwnSlotValueClosure(Collection<Frame> collection, Slot slot) throws RemoteException {
        return this.getCacheClosure(collection, slot);
    }

    private Set getCacheClosure(Frame frame, Slot slot) throws RemoteException {
        Set set = new HashSet();
        HashSet<Frame> hashSet = new HashSet<Frame>();
        this.calculateClosureFromCacheOnly(frame, slot, set, hashSet);
        if (!hashSet.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("not in closure cache: " + frame.getFrameID() + ", " + slot.getFrameID());
            }
            ++this.stats.closureMiss;
            RemoteResponse<Set> remoteResponse = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frame, slot, hashSet, this.session);
            this.processValueUpdate(remoteResponse);
            set = remoteResponse.getResponse();
            if (log.isLoggable(Level.FINE)) {
                for (Object e : set) {
                    if (e instanceof Frame) {
                        log.fine("\t closure frame = " + ((Frame)e).getFrameID());
                        continue;
                    }
                    log.fine("other closure " + e);
                }
            }
        } else {
            ++this.stats.closureHit;
        }
        return set;
    }

    private void calculateClosureFromCacheOnly(Frame frame, Slot slot, Set set, Set<Frame> set2) throws RemoteException {
        if (this.isCached(frame, slot, null, false)) {
            List list = this.getCacheValues(frame, slot, null, false);
            for (Object e : list) {
                boolean bl = set.add(e);
                if (!bl || !(e instanceof Frame)) continue;
                this.calculateClosureFromCacheOnly((Frame)e, slot, set, set2);
            }
        } else {
            set2.add(frame);
        }
    }

    private Set getCacheClosure(Collection<Frame> collection, Slot slot) throws RemoteException {
        Set<Frame> set = new HashSet<Frame>(collection);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (Frame frame : collection) {
            this.calculateClosureFromCacheOnly(frame, slot, set, hashSet);
        }
        if (!hashSet.isEmpty()) {
            ++this.stats.closureMiss;
            RemoteResponse<Set> remoteResponse = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(collection, slot, hashSet, this.session);
            this.processValueUpdate(remoteResponse);
            set = (Set)remoteResponse.getResponse();
            set.addAll(collection);
            return set;
        }
        ++this.stats.closureHit;
        return set;
    }

    private List getCacheDirectOwnSlotValues(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheValues(frame, slot, null, false);
    }

    public Collection getCacheOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        Collection collection = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            Collection collection2 = this.getTemplateFacetValues(cls, slot, facet);
            collection = RemoteClientFrameStore.resolveValues(collection, collection2, facet);
        }
        return collection;
    }

    private Collection getCacheTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        List list;
        Instance instance2;
        Collection collection = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        for (Instance instance2 : this.getSuperclasses(cls)) {
            list = this.getDirectTemplateFacetValues((Cls)instance2, slot, facet);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        instance2 = (Slot)this.getDirectOwnSlotValue(facet, this.getSystemFrames().getAssociatedSlotSlot());
        if (instance2 != null) {
            list = this.getDirectOwnSlotValues(slot, (Slot)instance2);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        return collection;
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(list);
    }

    private static Collection resolveValues(Collection arrayList, Collection collection, Facet facet) {
        if (!collection.isEmpty()) {
            if (arrayList.isEmpty()) {
                arrayList.addAll(collection);
            } else if ((arrayList = facet.resolveValues(arrayList, collection)) == collection) {
                arrayList = new ArrayList(arrayList);
            }
        }
        return arrayList;
    }

    public Collection getCacheOwnSlotValues(Frame frame, Slot slot) {
        ArrayList arrayList = new ArrayList();
        this.addOwnSlotValues(frame, slot, arrayList);
        return arrayList;
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        collection.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, collection);
        this.addSubslotValues(frame, slot, collection);
        if (frame instanceof Slot && collection.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, collection);
        }
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return slot.equals(this.getSystemFrames().getDirectDomainSlot()) || slot.equals(this.getSystemFrames().getValueTypeSlot()) || slot.equals(this.getSystemFrames().getMaximumCardinalitySlot()) || slot.equals(this.getSystemFrames().getMinimumValueSlot()) || slot.equals(this.getSystemFrames().getMaximumValueSlot());
    }

    private void addInheritedSuperslotValues(Slot slot, Slot slot2, Collection collection) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
        for (Slot slot3 : this.getSuperslots(slot)) {
            List list = this.getDirectOwnSlotValues(slot3, slot2);
            if (facet == null) {
                collection.addAll(list);
                continue;
            }
            Collection collection2 = facet.resolveValues(collection, list);
            if (((Object)collection2).equals(collection)) continue;
            collection.clear();
            collection.addAll(collection2);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Instance) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls cls : this.getTypes(instance)) {
                linkedHashSet.addAll(this.getDirectTemplateSlotValues(cls, slot));
            }
            collection.addAll(linkedHashSet);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection collection) {
        for (Slot slot2 : this.getSubslots(slot)) {
            collection.addAll(this.getDirectOwnSlotValues(frame, slot2));
        }
    }

    private Set getCacheOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> hashSet = new HashSet<Facet>();
        for (Slot slot2 : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
            if (facet == null) continue;
            hashSet.add(facet);
        }
        return hashSet;
    }

    private Collection getCacheTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this.getSystemFrames().getValuesFacet());
    }

    private Set getCacheOwnSlots(Frame frame) {
        Set set = this.getTypes((Instance)frame);
        Set set2 = this.collectOwnSlotValues(set, this.getSystemFrames().getDirectTemplateSlotsSlot());
        set2.add(this.getSystemFrames().getNameSlot());
        set2.add(this.getSystemFrames().getDirectTypesSlot());
        return set2;
    }

    private Set collectOwnSlotValues(Collection collection, Slot slot) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Frame frame = (Frame)objectArray[i];
            linkedHashSet.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return linkedHashSet;
    }

    private Set getCacheTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> linkedHashSet = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        linkedHashSet.add(cls);
        Set set = this.collectOwnSlotValues(linkedHashSet, this.getSystemFrames().getDirectTemplateSlotsSlot());
        return set;
    }

    private Set getCacheDomain(Slot slot) throws RemoteException {
        return this.getCacheOwnSlotValueClosure(this.getDirectDomain(slot), this.getSystemFrames().getDirectSubclassesSlot());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getCacheValues(Frame frame, Slot slot, Facet facet, boolean bl) throws RemoteException {
        void var5_10;
        void var5_8;
        Object var5_5 = null;
        if (this.isCached(frame, slot, facet, bl)) {
            List list = this.readCache(frame, slot, facet, bl);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("cache miss for frame " + frame.getFrameID() + " slot " + slot.getFrameID() + (facet == null ? "null" : "" + facet.getFrameID()) + " template " + bl);
            }
            RemoteResponse<List> remoteResponse = null;
            if (facet != null) {
                if (!bl) throw new UnsupportedOperationException("We don't cache this information...");
                remoteResponse = this.getRemoteDelegate().getDirectTemplateFacetValues((Cls)frame, slot, facet, this.session);
            } else {
                remoteResponse = bl ? this.getRemoteDelegate().getDirectTemplateSlotValues((Cls)frame, slot, this.session) : this.getRemoteDelegate().getDirectOwnSlotValues(frame, slot, this.session);
            }
            this.processValueUpdate(remoteResponse);
            List list = remoteResponse.getResponse();
        }
        if (var5_8 != null) return var5_10;
        ArrayList arrayList = new ArrayList();
        return var5_10;
    }

    private boolean isCached(Frame frame, Slot slot, Facet facet, boolean bl) {
        boolean bl2;
        Object object;
        Object object2;
        Sft sft = new Sft(slot, facet, bl);
        if (this.transactionNesting > 0) {
            try {
                object2 = this.getTransactionIsolationLevel();
                if (object2 == null) {
                    ++this.stats.miss;
                    return false;
                }
            }
            catch (TransactionException transactionException) {
                Log.getLogger().log(Level.WARNING, "Could not get transaction isolation level - caching disabled", transactionException);
                ++this.stats.miss;
                return false;
            }
            object = this.sessionCache.get(frame);
            if (((Enum)object2).compareTo(TransactionIsolationLevel.REPEATABLE_READ) >= 0 && (object == null || object.get(sft) == null)) {
                ++this.stats.miss;
                return false;
            }
            if (((Enum)object2).compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0 && object != null && object.containsKey(sft)) {
                if (object.get(sft) == null) {
                    ++this.stats.miss;
                    return false;
                }
                ++this.stats.hit;
                return true;
            }
        }
        if ((object2 = this.cache.get(frame)) == null) {
            ++this.stats.miss;
            return false;
        }
        object = (List)object2.get(sft);
        if (object != null) {
            ++this.stats.hit;
            return true;
        }
        boolean bl3 = bl2 = this.cacheStatus.get(frame) == CacheStatus.COMPLETED_CACHING && !object2.containsKey(sft);
        if (bl2) {
            ++this.stats.hit;
        } else {
            ++this.stats.miss;
        }
        return bl2;
    }

    private List readCache(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = null;
        Sft sft = new Sft(slot, facet, bl);
        if (this.transactionNesting > 0 && this.sessionCache.get(frame) != null) {
            TransactionIsolationLevel transactionIsolationLevel;
            try {
                transactionIsolationLevel = this.getTransactionIsolationLevel();
            }
            catch (TransactionException transactionException) {
                Log.getLogger().log(Level.WARNING, "Could not get transaction isolation level - caching disabled", transactionException);
                transactionIsolationLevel = null;
            }
            if (transactionIsolationLevel != null && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
                list = this.sessionCache.get(frame).get(sft);
            }
        }
        if (list == null) {
            list = this.cache.get(frame).get(sft);
        }
        return list;
    }

    private void addCachedEntry(boolean bl, Frame frame, Slot slot, Facet facet, boolean bl2, List list) {
        Map<Frame, Map<Sft, List>> map;
        Map<Sft, List> map2;
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Client Received value for frame " + frame.getFrameID() + " slot " + slot.getFrameID() + " facet " + (facet == null ? "null" : "" + facet.getFrameID()) + " is template " + bl2);
            cacheLog.fine("Transaction Scope = " + bl);
        }
        if ((map2 = (map = bl ? this.sessionCache : this.cache).get(frame)) == null) {
            map2 = new HashMap<Sft, List>();
            map.put(frame, map2);
        }
        Sft sft = new Sft(slot, facet, bl2);
        map2.put(sft, list);
        if (facet == null && !bl2 && slot.equals(this.getSystemFrames().getNameSlot()) && !bl && list != null && !list.isEmpty()) {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("frame " + frame.getFrameID() + " has name " + list.get(0));
            }
            this.frameNameToFrameMap.put((String)list.get(0), frame);
        }
    }

    private void invalidateCachedEntry(boolean bl, Frame frame, Slot slot, Facet facet, boolean bl2, boolean bl3) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("making invalid cache entry for frame " + frame.getFrameID() + " slot " + slot.getFrameID() + " facet " + (facet == null ? "null" : facet.toString()) + " isTemplate " + bl2 + " remove flag " + bl3);
            cacheLog.fine("Transaction Scope = " + bl);
        }
        Map<Frame, Map<Sft, List>> map = bl ? this.sessionCache : this.cache;
        Map<Sft, List> map2 = map.get(frame);
        CacheStatus cacheStatus = this.cacheStatus.get(frame);
        if (bl && !bl3 && map2 == null) {
            map2 = new HashMap<Sft, List>();
            map.put(frame, map2);
        }
        if (map2 != null) {
            List list;
            Sft sft = new Sft(slot, facet, bl2);
            if (facet == null && !bl2 && slot.equals(this.getSystemFrames().getNameSlot()) && (list = map2.get(sft)) != null && !list.isEmpty()) {
                String string = (String)list.get(0);
                this.frameNameToFrameMap.remove(string);
                if (cacheLog.isLoggable(Level.FINE)) {
                    cacheLog.fine("Flushing name also " + string);
                }
            }
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Cache Completion Status = " + (Object)((Object)cacheStatus));
            }
            if (!bl3 && (bl || cacheStatus != null)) {
                map2.put(sft, null);
            } else {
                map2.remove(sft);
            }
        }
    }

    private void removeCachedUpdate(boolean bl, Frame frame) {
        Object object;
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Removing cache entry for " + frame.getFrameID());
            cacheLog.fine("Transaction Scope = " + bl);
        }
        Sft sft = new Sft(this.getSystemFrames().getNameSlot(), null, false);
        if (this.cache.get(frame) != null && this.cache.get(frame).get(sft) != null) {
            object = (String)this.cache.get(frame).get(sft).get(0);
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("\tName too (" + (String)object + ")");
            }
            this.frameNameToFrameMap.remove(object);
        }
        object = bl ? this.sessionCache : this.cache;
        object.remove(frame);
        this.cacheStatus.remove(frame);
    }

    private void processValueUpdate(OntologyUpdate ontologyUpdate) {
        this.localize(ontologyUpdate);
        this.processValueUpdate(ontologyUpdate.getValueUpdates());
    }

    private void processValueUpdate(List<ValueUpdate> list) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("received " + list.size() + " value updates");
        }
        for (ValueUpdate valueUpdate : list) {
            TransactionIsolationLevel transactionIsolationLevel;
            Object object;
            boolean bl;
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Client Processing event " + valueUpdate);
            }
            Map<Frame, Map<Sft, List>> map = (bl = valueUpdate.isTransactionScope()) ? this.sessionCache : this.cache;
            Frame frame = valueUpdate.getFrame();
            if (valueUpdate instanceof FrameEvaluationStarted) {
                if (cacheLog.isLoggable(Level.FINE)) {
                    cacheLog.fine("Started caching for frame" + frame.getFrameID());
                }
                this.cacheStatus.put(frame, CacheStatus.STARTED_CACHING);
                continue;
            }
            if (valueUpdate instanceof FrameEvaluationCompleted) {
                object = this.cacheStatus.get(frame);
                if (object == null || object != CacheStatus.STARTED_CACHING) continue;
                if (cacheLog.isLoggable(Level.FINE)) {
                    cacheLog.fine("Completed caching for " + frame.getFrameID());
                }
                this.cacheStatus.put(frame, CacheStatus.COMPLETED_CACHING);
                continue;
            }
            if (valueUpdate instanceof FrameEvaluationPartial) {
                if (cacheLog.isLoggable(Level.FINE)) {
                    cacheLog.fine("Aborted full cache for " + frame.getFrameID());
                }
                this.cacheStatus.remove(frame);
                continue;
            }
            if (valueUpdate instanceof RemoveFrameCache) {
                this.removeCachedUpdate(bl, frame);
                continue;
            }
            if (!(valueUpdate instanceof SftUpdate)) continue;
            object = (SftUpdate)valueUpdate;
            Slot slot = ((SftUpdate)object).getSlot();
            Facet facet = ((SftUpdate)object).getFacet();
            boolean bl2 = ((SftUpdate)object).isTemplate();
            try {
                transactionIsolationLevel = this.getTransactionIsolationLevel();
            }
            catch (TransactionException transactionException) {
                Log.getLogger().log(Level.WARNING, "Error handling cache update", transactionException);
                transactionIsolationLevel = null;
            }
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Transaction Isolation Level = " + (Object)((Object)transactionIsolationLevel));
            }
            if (transactionIsolationLevel == null && valueUpdate instanceof FrameRead) {
                this.invalidateCachedEntry(false, frame, slot, facet, bl2, false);
                this.invalidateCachedEntry(true, frame, slot, facet, bl2, false);
                continue;
            }
            if (valueUpdate instanceof FrameRead && transactionIsolationLevel == TransactionIsolationLevel.READ_COMMITTED) {
                if (this.sessionCache.get(frame) != null && this.sessionCache.get(frame).get(new Sft(slot, facet, bl2)) != null) continue;
                this.addCachedEntry(false, frame, slot, facet, bl2, ((FrameRead)valueUpdate).getValues());
                continue;
            }
            if (valueUpdate instanceof FrameRead) {
                this.addCachedEntry(bl, frame, slot, facet, bl2, ((FrameRead)valueUpdate).getValues());
                continue;
            }
            if (valueUpdate instanceof FrameWrite) {
                this.addCachedEntry(bl, frame, slot, facet, bl2, ((FrameWrite)valueUpdate).getValues());
                continue;
            }
            if (valueUpdate instanceof RemoveCacheUpdate) {
                this.invalidateCachedEntry(bl, frame, slot, facet, bl2, true);
                continue;
            }
            if (!(valueUpdate instanceof InvalidateCacheUpdate)) continue;
            this.invalidateCachedEntry(bl, frame, slot, facet, bl2, false);
        }
    }

    public synchronized void flushCache() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Flushing client cache");
        }
        this.cacheStatus.clear();
        this.cache.clear();
        this.sessionCache.clear();
        this.frameNameToFrameMap.clear();
        this.stats = new RemoteClientStatsImpl();
    }

    public Object executeProtegeJob(ProtegeJob protegeJob) throws ProtegeException {
        try {
            RemoteResponse<Object> remoteResponse = this.getRemoteDelegate().executeProtegeJob(protegeJob, this.session);
            this.processValueUpdate(remoteResponse);
            Object object = remoteResponse.getResponse();
            LocalizeUtils.localize(object, this.kb);
            return object;
        }
        catch (RemoteException remoteException) {
            throw new ProtegeIOException(remoteException);
        }
    }

    public Set<Operation> getAllowedOperations() throws ProtegeIOException {
        if (this.allowedOps == null) {
            try {
                this.allowedOps = this.getRemoteDelegate().getAllowedOperations(this.session);
            }
            catch (RemoteException remoteException) {
                throw new ProtegeIOException(remoteException);
            }
        }
        return this.allowedOps;
    }

    public Set<Operation> getKnownOperations() throws ProtegeIOException {
        if (this.knownOps == null) {
            try {
                this.knownOps = this.getRemoteDelegate().getKnownOperations(this.session);
            }
            catch (RemoteException remoteException) {
                throw new ProtegeIOException(remoteException);
            }
        }
        return this.knownOps;
    }

    public static boolean isOperationAllowed(KnowledgeBase knowledgeBase, Operation operation) throws ProtegeIOException {
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        FrameStore frameStore = defaultKnowledgeBase.getTerminalFrameStore();
        if (!(frameStore instanceof RemoteClientFrameStore)) {
            return true;
        }
        RemoteClientFrameStore remoteClientFrameStore = (RemoteClientFrameStore)frameStore;
        return !remoteClientFrameStore.getKnownOperations().contains(operation) || remoteClientFrameStore.getAllowedOperations().contains(operation);
    }

    public RemoteServer getRemoteServer() {
        return this.server;
    }

    public RemoteSession getSession() {
        return this.session;
    }

    static {
        try {
            getEventsMethod = RemoteServerFrameStore.class.getDeclaredMethod("getEvents", RemoteSession.class);
            executeProtegeJobMethod = RemoteServerFrameStore.class.getDeclaredMethod("executeProtegeJob", ProtegeJob.class, RemoteSession.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.getLogger().log(Level.SEVERE, "No such method ", noSuchMethodException);
        }
    }

    public class RemoteClientStatsImpl
    implements RemoteClientStats {
        int miss = 0;
        int hit = 0;
        int closureMiss = 0;
        int closureHit = 0;

        public int getCacheHits() {
            return this.hit;
        }

        public int getCacheMisses() {
            return this.miss;
        }

        public int getClosureCacheHits() {
            return this.closureHit;
        }

        public int getClosureCacheMisses() {
            return this.closureMiss;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheStatus {
        STARTED_CACHING,
        COMPLETED_CACHING;

    }
}

