/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registration {
    private static final transient Logger cacheLog = ServerFrameStore.cacheLog;
    private FifoReader<AbstractEvent> events;
    private FifoReader<ValueUpdate> updates;
    private List<ValueUpdate> commits = new ArrayList<ValueUpdate>();
    private long lastHeartbeat = 0L;

    public Registration(FifoWriter<AbstractEvent> fifoWriter, FifoWriter<ValueUpdate> fifoWriter2) {
        this.events = new FifoReader<AbstractEvent>(fifoWriter);
        this.updates = new FifoReader<ValueUpdate>(fifoWriter2);
    }

    public FifoReader<AbstractEvent> getEvents() {
        return this.events;
    }

    public FifoReader<ValueUpdate> getUpdates() {
        return this.updates;
    }

    public void addCommittableUpdate(ValueUpdate valueUpdate) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Saving an update for commit/rollback " + valueUpdate);
        }
        this.commits.add(valueUpdate);
    }

    public List<ValueUpdate> getCommits() {
        return this.commits;
    }

    public void clearCommits() {
        this.getCommits();
    }

    public void endTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Ending transaction: clearing transaction local events and updates");
        }
        this.commits = new ArrayList<ValueUpdate>();
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long l) {
        this.lastHeartbeat = l;
    }
}

