/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.File;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server_Test
extends SimpleTestCase {
    private static transient Logger log = Log.getLogger(Server_Test.class);
    public static final String HOST = "localhost";
    private static final String USER1 = "Ray Fergerson";
    private static final String PASSWORD1 = "claudia";
    private static final String WRONG_PASSWORD = "elle";
    private static final String PROJECT_NAME = "Newspaper";
    private static final String USER2 = "Jennifer Vendetti";
    private static final String PASSWORD2 = "jenny";
    private static final String NAME = "//localhost/" + Server.getBoundName();
    public static final String JAR_PROPERTY = "junit.server.protege.jar";
    private static boolean serverRunning = false;
    private static String protegeJarLocation = "dist/protege.jar";
    private RemoteServer _server;
    private static String metaproject = "examples/server/metaproject.pprj";
    private static boolean informedServerNotConfigured = false;

    public void setUp() throws Exception {
        super.setUp();
        try {
            if (!Server_Test.startServer()) {
                return;
            }
            this._server = (RemoteServer)Naming.lookup(NAME);
            this._server.reinitialize();
        }
        catch (NotBoundException e) {
            Server_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public static boolean startServer() throws Exception {
        File appDir = ApplicationProperties.getApplicationDirectory();
        File jar = new File(appDir, protegeJarLocation);
        if (!jar.exists() && !(jar = new File(protegeJarLocation)).exists()) {
            System.out.println("Need to compile to a jar file before running server tests");
            System.out.println("System tests not configured");
            return false;
        }
        System.setProperty("java.rmi.server.codebase", jar.toURL().toString());
        String[] serverArgs = new String[]{"", metaproject};
        if (!serverRunning) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("starting server");
            }
            Server.startServer(serverArgs);
            serverRunning = true;
        }
        return true;
    }

    public static boolean isServerRunning() {
        return serverRunning;
    }

    public static void setMetaProject(String metaproject) {
        Server_Test.metaproject = metaproject;
    }

    private static String getMachineIpAddress() {
        return SystemUtilities.getMachineIpAddress();
    }

    public void testSession() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession session = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((String)"session", (Object)session);
        RemoteSession noSession = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), WRONG_PASSWORD);
        Server_Test.assertNull((String)"no session", (Object)noSession);
        this._server.closeSession(session);
    }

    public void testConnection() throws RemoteException {
        if (!serverRunning) {
            return;
        }
        RemoteSession session1 = this._server.openSession(USER1, Server_Test.getMachineIpAddress(), PASSWORD1);
        Server_Test.assertNotNull((Object)session1);
        RemoteServerProject project1 = this._server.openProject(PROJECT_NAME, session1);
        Server_Test.assertNotNull((Object)project1);
        RemoteSession session2 = this._server.openSession(USER2, Server_Test.getMachineIpAddress(), PASSWORD2);
        RemoteServerProject project2 = this._server.openProject(PROJECT_NAME, session2);
        Server_Test.assertEquals((String)"projects", (Object)project1, (Object)project2);
        Collection<RemoteSession> sessions = this._server.getCurrentSessions(PROJECT_NAME, session2);
        Server_Test.assertEqualsSet(Server_Test.makeList(session1, session2), sessions);
        project2.close(session2);
        sessions = this._server.getCurrentSessions(PROJECT_NAME, session1);
        Server_Test.assertEqualsSet(Server_Test.makeList(session1), sessions);
        project1.close(session1);
        this._server.closeSession(session1);
        this._server.closeSession(session2);
    }

    public void testGetProject() {
        if (!serverRunning) {
            return;
        }
        Project p = RemoteProjectManager.getInstance().getProject(HOST, USER1, PASSWORD1, PROJECT_NAME, true);
        Server_Test.assertNotNull((Object)p);
        KnowledgeBase kb = p.getKnowledgeBase();
        Cls cls = kb.getCls("Editor");
        Server_Test.assertNotNull((Object)cls);
        p.dispose();
    }

    public static void setProtegeJarLocation(String location) {
        protegeJarLocation = location;
    }
}

