/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protege.server.narrowframestore.ServerNarrowFrameStore;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;

public class ServerProject
extends UnicastRemoteObject
implements RemoteServerProject {
    private static final long serialVersionUID = 7320382402535936929L;
    private URI _uri;
    private Server _server;
    private Project _project;
    private ServerFrameStore _domainKbFrameStore;
    private ServerFrameStore _projectKbFrameStore;
    private ServerNarrowFrameStore _domainKbNarrowFrameStore;
    private ServerNarrowFrameStore _systemNarrowFrameStore;

    public URI getURI(RemoteSession remoteSession) {
        return this._uri;
    }

    public String getDomainKbFactoryClassName() {
        return this._project.getKnowledgeBase().getKnowledgeBaseFactory().getClass().getName();
    }

    public String getProjectKbFactoryClassName() {
        return this._project.getInternalProjectKnowledgeBase().getKnowledgeBaseFactory().getClass().getName();
    }

    public ServerProject(Server server, URI uRI, ProjectInstance projectInstance, Project project) throws RemoteException {
        this._server = server;
        this._uri = uRI;
        this._project = project;
        this._domainKbFrameStore = ServerProject.createServerFrameStore(this._project.getKnowledgeBase());
        this._domainKbFrameStore.setMetaProjectInstance(projectInstance);
        this._projectKbFrameStore = ServerProject.createServerFrameStore(this._project.getInternalProjectKnowledgeBase());
        this._domainKbNarrowFrameStore = this.createServerNarrowFrameStore();
        this._systemNarrowFrameStore = this.createServerSystemNarrowFrameStore();
    }

    private static ServerFrameStore createServerFrameStore(KnowledgeBase knowledgeBase) throws RemoteException {
        ServerFrameStore serverFrameStore = new ServerFrameStore(knowledgeBase);
        return serverFrameStore;
    }

    private ServerNarrowFrameStore createServerNarrowFrameStore() throws RemoteException {
        KnowledgeBase knowledgeBase = this._project.getKnowledgeBase();
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get(knowledgeBase);
        NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getActiveFrameStore();
        return new ServerNarrowFrameStore(narrowFrameStore, knowledgeBase);
    }

    private ServerNarrowFrameStore createServerSystemNarrowFrameStore() throws RemoteException {
        KnowledgeBase knowledgeBase = this._project.getKnowledgeBase();
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get(knowledgeBase);
        NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getSystemFrameStore();
        return new ServerNarrowFrameStore(narrowFrameStore, knowledgeBase);
    }

    public RemoteServerFrameStore getDomainKbFrameStore(RemoteSession remoteSession) {
        return this._domainKbFrameStore;
    }

    public RemoteServerFrameStore getProjectKbFrameStore(RemoteSession remoteSession) {
        return this._projectKbFrameStore;
    }

    public RemoteServerNarrowFrameStore getDomainKbNarrowFrameStore() {
        return this._domainKbNarrowFrameStore;
    }

    public RemoteServerNarrowFrameStore getSystemNarrowFrameStore() {
        return this._systemNarrowFrameStore;
    }

    public void register(RemoteSession remoteSession) throws ServerSessionLost {
        this._domainKbFrameStore.register(remoteSession);
        this._projectKbFrameStore.register(remoteSession);
    }

    public void deregister(RemoteSession remoteSession) throws ServerSessionLost {
        this._domainKbFrameStore.deregister(remoteSession);
        this._projectKbFrameStore.deregister(remoteSession);
    }

    public void close(RemoteSession remoteSession) throws ServerSessionLost {
        this._server.disconnectFromProject(this, remoteSession);
    }

    public Collection getCurrentSessions(RemoteSession remoteSession) {
        return this._server.getCurrentSessions(this);
    }

    public boolean isDirty() {
        return this._domainKbFrameStore.isDirty();
    }

    public void setClean() {
        this._domainKbFrameStore.markClean();
        this._projectKbFrameStore.markClean();
    }

    public void setFrameCalculatorDisabled(boolean bl) {
        this._domainKbFrameStore.setFrameCalculatorDisabled(bl);
    }
}

