/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.Server_Test;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.LockStepper;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import junit.framework.Assert;

public class DBServer_Test
extends APITestCase {
    private static final String HOST = "localhost";
    private static final String NAME = "//localhost/" + Server.getBoundName();
    public static final String DBTYPE_PROPERTY = "junit.server.db.dbtype";
    public static final String DBPROJECT_PROPERTY = "junit.server.db.file.dbproject";
    public static final String DB_SERVER_METAPROJECT_PROPERTY = "junit.server.db.file.metaproject";
    public static final String DB_CLIENT_PROJECT_PROPERTY = "junit.server.db.client_project";
    private static final String USER = "Ray Fergerson";
    private static final String PASSWORD = "claudia";
    private static boolean projectCleaned = false;
    private static String clientProject;
    private static boolean configured;
    private static int counter;
    private boolean informedNotConfigured = false;

    public void setUp() throws Exception {
        super.setUp();
        if (clientProject == null) {
            if (!this.informedNotConfigured) {
                System.out.println("Server/Database tests not configured");
                this.informedNotConfigured = true;
            }
            configured = false;
        }
        Properties props = DBServer_Test.getJunitProperties();
        String serverProjectFile = props.getProperty(DB_SERVER_METAPROJECT_PROPERTY);
        try {
            Server_Test.setMetaProject(serverProjectFile);
            Server_Test.startServer();
            Naming.lookup(NAME);
        }
        catch (NotBoundException e) {
            DBServer_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
        if (!projectCleaned) {
            this.cleanProject();
            projectCleaned = true;
        }
    }

    public void createDatabaseProject() {
        Properties props = DBServer_Test.getJunitProperties();
        String dbType = props.getProperty(DBTYPE_PROPERTY);
        String dbProjectFile = props.getProperty(DBPROJECT_PROPERTY);
        if (dbType == null) {
            System.out.println("Server+Database Test not configured");
            return;
        }
        for (APITestCase.DBType dbt : APITestCase.DBType.values()) {
            if (!dbt.toString().equals(dbType)) continue;
            DBServer_Test.setDBType(dbt);
            break;
        }
        DBServer_Test.setDatabaseProject();
        ArrayList errors = new ArrayList();
        this.getProject().setProjectFilePath(dbProjectFile);
        this.getProject().save(errors);
        DBServer_Test.closeProject();
    }

    public DefaultKnowledgeBase getKb() {
        RemoteProjectManager rpm = RemoteProjectManager.getInstance();
        Project p = rpm.getProject(HOST, USER, PASSWORD, clientProject, true);
        return (DefaultKnowledgeBase)p.getKnowledgeBase();
    }

    public void cleanProject() {
        boolean progress = true;
        DefaultKnowledgeBase kb = this.getKb();
        while (progress) {
            progress = false;
            for (Frame frame : kb.getFrames()) {
                if (frame.isSystem()) continue;
                if (frame instanceof Cls) {
                    Cls cls = (Cls)frame;
                    if (cls.getInstanceCount() != 0) continue;
                    cls.delete();
                    progress = true;
                    continue;
                }
                frame.delete();
                progress = true;
            }
        }
    }

    private String newName() {
        return "A" + counter++;
    }

    public TransactionMonitor getTransactionMonitor() {
        Server server = Server.getInstance();
        ServerProject project = server.getServerProject(clientProject);
        ServerFrameStore fs = (ServerFrameStore)project.getDomainKbFrameStore(null);
        return fs.getTransactionStatusMonitor();
    }

    public void getUpdatesFromOtherThread(KnowledgeBase kb) {
        kb.createCls(this.newName(), Collections.singleton(kb.getRootCls()));
    }

    public static void main(String[] args) throws Exception {
        DBServer_Test dbst = new DBServer_Test();
        dbst.createDatabaseProject();
    }

    public void testTransaction01() throws Exception {
        if (!configured) {
            return;
        }
        try {
            final LockStepper<Test01Stages> ls = new LockStepper<Test01Stages>(Test01Stages.testStarted);
            DefaultKnowledgeBase kb = this.getKb();
            RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.READ_COMMITTED);
            new Thread("Second Transaction With Writes Thread"){

                public void run() {
                    try {
                        String transactionName = "My transaction";
                        DefaultKnowledgeBase kb = DBServer_Test.this.getKb();
                        RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.READ_COMMITTED);
                        Cls top = (Cls)ls.waitForStage(Test01Stages.mainThreadStarted);
                        kb.beginTransaction(transactionName);
                        Cls bottom = kb.createCls(DBServer_Test.this.newName(), Collections.singleton(top));
                        ls.stageAchieved(Test01Stages.transactionOpenWithWrite, bottom);
                        ls.waitForStage(Test01Stages.readComplete);
                        kb.commitTransaction();
                        kb.getProject().dispose();
                        ls.stageAchieved(Test01Stages.testComplete, null);
                    }
                    catch (Throwable e) {
                        ls.exceptionOffMainThread(Test01Stages.testComplete, e);
                    }
                }
            }.start();
            Cls top = kb.createCls(this.newName(), Collections.singleton(kb.getSystemFrames().getRootCls()));
            ls.stageAchieved(Test01Stages.mainThreadStarted, top);
            ls.waitForStage(Test01Stages.transactionOpenWithWrite);
            this.getUpdatesFromOtherThread(kb);
            Collection subClasses = kb.getSubclasses(top);
            if (subClasses != null && !subClasses.isEmpty()) {
                DBServer_Test.fail((String)"Should not see subclasses being created by other thread.");
            }
            ls.stageAchieved(Test01Stages.readComplete, null);
            ls.waitForStage(Test01Stages.testComplete);
            kb.getProject().dispose();
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Test failed, e");
            throw e;
        }
    }

    public void testTransaction02_1() throws Exception {
        this.doTest02(true, true);
    }

    public void testTransaction02_2() throws Exception {
        this.doTest02(true, false);
    }

    public void testTransaction02_3() throws Exception {
        this.doTest02(false, true);
    }

    public void testTransaction02_4() throws Exception {
        this.doTest02(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest02(boolean commit, final boolean commitOther) throws Exception {
        if (!configured) {
            return;
        }
        try {
            DefaultKnowledgeBase kb = this.getKb();
            RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.REPEATABLE_READ);
            final LockStepper<Test02Stages> ls = new LockStepper<Test02Stages>(Test02Stages.testStarted);
            final Cls testCls = kb.createCls(this.newName(), Collections.singleton(kb.getSystemFrames().getRootCls()));
            new Thread("Second Transaction with Writes Thread doTest02(" + commit + "," + commitOther + ")"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DefaultKnowledgeBase kb = DBServer_Test.this.getKb();
                        try {
                            kb.beginTransaction("transaction will modify testCls after other transaction reads testCls");
                            ls.waitForStage(Test02Stages.firstReadComplete);
                            kb.createCls(DBServer_Test.this.newName(), Collections.singleton(testCls));
                            Assert.assertTrue((kb.getSubclasses(testCls).size() == 1 ? 1 : 0) != 0);
                            ls.stageAchieved(Test02Stages.writeComplete, null);
                            ls.waitForStage(Test02Stages.secondReadComplete);
                        }
                        finally {
                            if (commitOther) {
                                kb.commitTransaction();
                            } else {
                                kb.rollbackTransaction();
                            }
                        }
                        if (commitOther) {
                            Assert.assertTrue((kb.getSubclasses(testCls).size() == 1 ? 1 : 0) != 0);
                        } else {
                            Assert.assertTrue((boolean)kb.getSubclasses(testCls).isEmpty());
                        }
                        ls.stageAchieved(Test02Stages.otherTransactionClosed, null);
                        ls.waitForStage(Test02Stages.thirdReadComplete);
                        kb.getProject().dispose();
                        ls.stageAchieved(Test02Stages.testComplete, null);
                    }
                    catch (Throwable e) {
                        ls.exceptionOffMainThread(Test02Stages.testComplete, e);
                    }
                }
            }.start();
            try {
                kb.beginTransaction("Repeatable Read");
                DBServer_Test.assertTrue((boolean)kb.getSubclasses(testCls).isEmpty());
                ls.stageAchieved(Test02Stages.firstReadComplete, null);
                ls.waitForStage(Test02Stages.writeComplete);
                this.getUpdatesFromOtherThread(kb);
                DBServer_Test.assertTrue((boolean)kb.getSubclasses(testCls).isEmpty());
                ls.stageAchieved(Test02Stages.secondReadComplete, null);
                ls.waitForStage(Test02Stages.otherTransactionClosed);
                this.getUpdatesFromOtherThread(kb);
                DBServer_Test.assertTrue((boolean)kb.getSubclasses(testCls).isEmpty());
            }
            finally {
                if (commit) {
                    kb.commitTransaction();
                } else {
                    kb.rollbackTransaction();
                }
            }
            if (commitOther) {
                DBServer_Test.assertTrue((kb.getSubclasses(testCls).size() == 1 ? 1 : 0) != 0);
            } else {
                DBServer_Test.assertTrue((boolean)kb.getSubclasses(testCls).isEmpty());
            }
            ls.stageAchieved(Test02Stages.thirdReadComplete, null);
            ls.waitForStage(Test02Stages.testComplete);
            kb.getProject().dispose();
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Test faiiled", e);
            throw e;
        }
    }

    public void testTransaction03() {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase kb = this.getKb();
        TransactionMonitor tm = this.getTransactionMonitor();
        DBServer_Test.assertTrue((boolean)tm.getSessions().isEmpty());
        kb.beginTransaction("Outer");
        DBServer_Test.assertTrue((tm.getSessions().size() == 1 ? 1 : 0) != 0);
        RemoteSession mySession = tm.getSessions().iterator().next();
        kb.beginTransaction("First Inner");
        DBServer_Test.assertTrue((tm.getNesting(mySession) == 2 ? 1 : 0) != 0);
        kb.rollbackTransaction();
        DBServer_Test.assertTrue((tm.getNesting(mySession) == 1 ? 1 : 0) != 0);
        kb.beginTransaction("Second Inner");
        DBServer_Test.assertTrue((tm.getNesting(mySession) == 2 ? 1 : 0) != 0);
        kb.commitTransaction();
        DBServer_Test.assertTrue((tm.getNesting(mySession) == 1 ? 1 : 0) != 0);
        kb.commitTransaction();
        DBServer_Test.assertTrue((tm.getNesting(mySession) == 0 ? 1 : 0) != 0);
        kb.getProject().dispose();
    }

    public void testTransaction04() throws TransactionException {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase kb = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.REPEATABLE_READ);
        final LockStepper<Test04Stages> ls = new LockStepper<Test04Stages>(Test04Stages.testStarted);
        Cls top = kb.createCls(this.newName(), Collections.singleton(kb.getSystemFrames().getRootCls()));
        final Cls middle = kb.createCls(this.newName(), Collections.singleton(top));
        Cls firstBottom = kb.createCls(this.newName(), Collections.singleton(middle));
        new Thread("Second knowledge base which writes a sub-subclass"){

            public void run() {
                try {
                    DefaultKnowledgeBase kb = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.REPEATABLE_READ);
                    kb.beginTransaction("Transaction in other thread");
                    ls.waitForStage(Test04Stages.firstRead);
                    Cls secondBottom = kb.createCls(DBServer_Test.this.newName(), Collections.singleton(middle));
                    ls.stageAchieved(Test04Stages.write, secondBottom);
                    ls.waitForStage(Test04Stages.secondRead);
                    kb.commitTransaction();
                    ls.stageAchieved(Test04Stages.firstCommit, null);
                    ls.waitForStage(Test04Stages.preComplete);
                    kb.getProject().dispose();
                    ls.stageAchieved(Test04Stages.testCompleted, null);
                }
                catch (Exception e) {
                    ls.exceptionOffMainThread(Test04Stages.testCompleted, e);
                }
            }
        }.start();
        kb.beginTransaction("First knowledge base which does some reading");
        Collection subclasses = kb.getSubclasses(top);
        DBServer_Test.assertTrue((boolean)subclasses.contains(firstBottom));
        ls.stageAchieved(Test04Stages.firstRead, null);
        Cls secondBottom = (Cls)ls.waitForStage(Test04Stages.write);
        LocalizeUtils.localize(secondBottom, kb);
        this.getUpdatesFromOtherThread(kb);
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!subclasses.contains(secondBottom) ? 1 : 0) != 0);
        ls.stageAchieved(Test04Stages.secondRead, null);
        ls.waitForStage(Test04Stages.firstCommit);
        this.getUpdatesFromOtherThread(kb);
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!subclasses.contains(secondBottom) ? 1 : 0) != 0);
        kb.commitTransaction();
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)subclasses.contains(secondBottom));
        ls.stageAchieved(Test04Stages.preComplete, null);
        ls.waitForStage(Test04Stages.testCompleted);
        kb.getProject().dispose();
    }

    public void testTransaction05() throws TransactionException {
        if (!configured) {
            return;
        }
        DefaultKnowledgeBase kb = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.READ_COMMITTED);
        final LockStepper<Test05Stages> ls = new LockStepper<Test05Stages>(Test05Stages.testStarted);
        Cls top = kb.createCls(this.newName(), Collections.singleton(kb.getSystemFrames().getRootCls()));
        final Cls middle = kb.createCls(this.newName(), Collections.singleton(top));
        Cls firstBottom = kb.createCls(this.newName(), Collections.singleton(middle));
        new Thread("Second knowledge base which writes a sub-subclass"){

            public void run() {
                try {
                    DefaultKnowledgeBase kb = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.READ_COMMITTED);
                    kb.beginTransaction("Transaction in other thread");
                    ls.waitForStage(Test05Stages.firstRead);
                    Cls secondBottom = kb.createCls(DBServer_Test.this.newName(), Collections.singleton(middle));
                    ls.stageAchieved(Test05Stages.write, secondBottom);
                    ls.waitForStage(Test05Stages.secondRead);
                    kb.commitTransaction();
                    ls.stageAchieved(Test05Stages.firstCommit, null);
                    ls.waitForStage(Test05Stages.preComplete);
                    kb.getProject().dispose();
                    ls.stageAchieved(Test05Stages.testCompleted, null);
                }
                catch (Exception e) {
                    ls.exceptionOffMainThread(Test05Stages.testCompleted, e);
                }
            }
        }.start();
        kb.beginTransaction("First knowledge base which does some reading");
        Collection subclasses = kb.getSubclasses(top);
        DBServer_Test.assertTrue((boolean)subclasses.contains(firstBottom));
        ls.stageAchieved(Test05Stages.firstRead, null);
        Cls secondBottom = (Cls)ls.waitForStage(Test05Stages.write);
        LocalizeUtils.localize(secondBottom, kb);
        this.getUpdatesFromOtherThread(kb);
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 1 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((!subclasses.contains(secondBottom) ? 1 : 0) != 0);
        ls.stageAchieved(Test05Stages.secondRead, null);
        ls.waitForStage(Test05Stages.firstCommit);
        this.getUpdatesFromOtherThread(kb);
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)subclasses.contains(secondBottom));
        kb.commitTransaction();
        this.getUpdatesFromOtherThread(kb);
        subclasses = kb.getDirectSubclasses(middle);
        DBServer_Test.assertTrue((subclasses.size() == 2 ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)subclasses.contains(secondBottom));
        ls.stageAchieved(Test05Stages.preComplete, null);
        ls.waitForStage(Test05Stages.testCompleted);
        kb.getProject().dispose();
    }

    public void testTransaction06() throws TransactionException {
        if (!configured) {
            return;
        }
        final LockStepper<Test06Stages> ls = new LockStepper<Test06Stages>(Test06Stages.start);
        DefaultKnowledgeBase kb = this.getKb();
        RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.REPEATABLE_READ);
        final Cls domainCls = kb.createCls(this.newName(), Collections.singleton(kb.getRootCls()));
        final Cls val1 = kb.createCls(this.newName(), Collections.singleton(domainCls));
        final Cls val2 = kb.createCls(this.newName(), Collections.singleton(domainCls));
        final Slot slot = kb.createSlot(this.newName(), kb.getSystemFrames().getStandardSlotMetaCls());
        kb.setDirectOwnSlotValues(domainCls, slot, Collections.singleton(val1));
        List values = kb.getDirectOwnSlotValues(domainCls, slot);
        DBServer_Test.assertTrue((boolean)values.contains(val1));
        DBServer_Test.assertTrue((!values.contains(val2) ? 1 : 0) != 0);
        new Thread("Non-transaction write thread"){

            public void run() {
                try {
                    DefaultKnowledgeBase kb = DBServer_Test.this.getKb();
                    RemoteClientFrameStore.setTransactionIsolationLevel(kb, TransactionIsolationLevel.REPEATABLE_READ);
                    ls.waitForStage(Test06Stages.inTransaction);
                    kb.setDirectOwnSlotValues(domainCls, slot, Collections.singleton(val2));
                    List values = kb.getDirectOwnSlotValues(domainCls, slot);
                    LocalizeUtils.localize(val1, kb);
                    LocalizeUtils.localize(val2, kb);
                    Assert.assertTrue((!values.contains(val1) ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)values.contains(val2));
                    ls.stageAchieved(Test06Stages.write, null);
                    ls.waitForStage(Test06Stages.preComplete);
                    ls.stageAchieved(Test06Stages.completed, null);
                }
                catch (Exception e) {
                    ls.exceptionOffMainThread(Test06Stages.completed, e);
                }
            }
        }.start();
        kb.beginTransaction("A lone transaction");
        values = kb.getDirectOwnSlotValues(domainCls, slot);
        LocalizeUtils.localize(val1, kb);
        LocalizeUtils.localize(val2, kb);
        DBServer_Test.assertTrue((boolean)values.contains(val1));
        DBServer_Test.assertTrue((!values.contains(val2) ? 1 : 0) != 0);
        ls.stageAchieved(Test06Stages.inTransaction, null);
        ls.waitForStage(Test06Stages.write);
        this.getUpdatesFromOtherThread(kb);
        values = kb.getDirectOwnSlotValues(domainCls, slot);
        LocalizeUtils.localize(val1, kb);
        LocalizeUtils.localize(val2, kb);
        DBServer_Test.assertTrue((boolean)values.contains(val1));
        DBServer_Test.assertTrue((!values.contains(val2) ? 1 : 0) != 0);
        kb.commitTransaction();
        values = kb.getDirectOwnSlotValues(domainCls, slot);
        DBServer_Test.assertTrue((!values.contains(val1) ? 1 : 0) != 0);
        DBServer_Test.assertTrue((boolean)values.contains(val2));
        ls.stageAchieved(Test06Stages.preComplete, null);
        ls.waitForStage(Test06Stages.completed);
    }

    static {
        Properties props = DBServer_Test.getJunitProperties();
        if (props != null) {
            clientProject = props.getProperty(DB_CLIENT_PROJECT_PROPERTY);
        }
        configured = true;
        counter = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test06Stages {
        start,
        inTransaction,
        write,
        preComplete,
        completed;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test05Stages {
        testStarted,
        firstRead,
        write,
        secondRead,
        firstCommit,
        preComplete,
        testCompleted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test04Stages {
        testStarted,
        firstRead,
        write,
        secondRead,
        firstCommit,
        preComplete,
        testCompleted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test02Stages {
        testStarted,
        firstReadComplete,
        writeComplete,
        secondReadComplete,
        otherTransactionClosed,
        thirdReadComplete,
        testComplete;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Test01Stages {
        testStarted,
        mainThreadStarted,
        transactionOpenWithWrite,
        readComplete,
        testComplete;

    }
}

