/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class ClientRmiSocketFactory
extends RMISocketFactory {
    private int serverPort = ClientRmiSocketFactory.getPort("protege.rmi.server.port", 0);
    private int serverLocalPort = ClientRmiSocketFactory.getPort("protege.rmi.server.local.port", 0);
    private int registryPort = ClientRmiSocketFactory.getPort("protege.rmi.registry.port", 1099);
    private int registryLocalPort = ClientRmiSocketFactory.getPort("protege.rmi.registry.local.port", 0);

    public ClientRmiSocketFactory() {
        if (!this.isDefault()) {
            Log.getLogger().config("server=" + this.serverPort + ", serverLocal= " + this.serverLocalPort + ", registryPort=" + this.registryPort + ", registryLocal=" + this.registryLocalPort);
        }
    }

    private static int getPort(String string, int n) {
        Integer n2 = Integer.getInteger(string);
        return n2 == null ? n : n2;
    }

    public Socket createSocket(String string, int n) throws IOException {
        int n2 = n == this.serverPort ? this.serverLocalPort : (n == this.registryPort ? this.registryLocalPort : 0);
        Socket socket = ClientRmiSocketFactory.createSocket(string, n, n2);
        if (!this.isDefault()) {
            Log.getLogger().config("localPort=" + socket.getLocalPort());
        }
        return socket;
    }

    private static Socket createSocket(String string, int n, int n2) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(n2);
        Socket socket = new Socket();
        socket.setReuseAddress(true);
        socket.bind(inetSocketAddress2);
        socket.connect(inetSocketAddress);
        return socket;
    }

    private boolean isDefault() {
        return this.serverPort == 0 && this.serverLocalPort == 0 && this.registryPort == 1099 && this.registryLocalPort == 0;
    }

    public ServerSocket createServerSocket(int n) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

