/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.query;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.query.QueryCallback;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeQueryCallback
implements QueryCallback,
Localizable {
    Object kbLock;
    Object result;

    public SynchronizeQueryCallback(Object object) {
        this.kbLock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provideQueryResults(Set<Frame> set) {
        Object object = this.kbLock;
        synchronized (object) {
            this.result = set;
            this.kbLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passException(Exception exception) {
        Object object = this.kbLock;
        synchronized (object) {
            this.result = exception;
            this.kbLock.notifyAll();
        }
    }

    @Override
    public void handleError(OntologyException ontologyException) {
        this.passException(ontologyException);
    }

    @Override
    public void handleError(ProtegeIOException protegeIOException) {
        this.passException(protegeIOException);
    }

    @Override
    public void handleError(ProtegeError protegeError) {
        this.passException(protegeError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Frame> waitForResults() throws OntologyException, ProtegeIOException {
        Object object = null;
        try {
            Object object2 = this.kbLock;
            synchronized (object2) {
                while (this.result == null) {
                    this.kbLock.wait();
                }
                object = this.result;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ProtegeIOException(interruptedException);
        }
        finally {
            this.result = null;
        }
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object instanceof OntologyException) {
            throw (OntologyException)object;
        }
        if (object instanceof ProtegeIOException) {
            throw (ProtegeIOException)object;
        }
        throw (ProtegeError)object;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        this.kbLock = knowledgeBase;
    }
}

