/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;

public class UndoFrameStore_Test
extends FrameStore_Test {
    private UndoFrameStore _frameStore;

    public FrameStore createFrameStore(DefaultKnowledgeBase kb) {
        this._frameStore = new UndoFrameStore();
        this._frameStore.setDelegate(new InMemoryFrameStore(kb));
        return this._frameStore;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this._frameStore = null;
    }

    public void testUndoCreateCls() {
        Cls cls = this.createCls();
        String name = cls.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)name);
        Frame frame = this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)cls, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(name);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        frame = this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)frame.getName(), (String)name);
    }

    public void testUndoCreateSimpleInstance() {
        Cls cls = this.createCls();
        Instance instance = this.createSimpleInstance(cls);
        String name = instance.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)name);
        Frame frame = this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)instance, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(name);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        instance = (Instance)this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)instance.getName(), (String)name);
    }

    public void testUndoCreateSlot() {
        Slot slot = this.createSlot();
        String name = slot.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)name);
        Frame frame = this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)slot, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(name);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        frame = this.getFrame(name);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)frame.getName(), (String)name);
    }

    public void testUndoCreateFacet() {
    }

    public void testUndoDeleteCls() {
        Cls clsA = this.createCls();
        Cls clsB = this.createCls();
        Cls clsA1 = this.createCls(clsA);
        Cls clsB1 = this.createCls(clsB);
        Cls clsAB2 = this.createCls(clsA1);
        this._frameStore.addDirectSuperclass(clsAB2, clsB1);
        Cls clsAB3 = this.createCls(clsAB2);
        int count = this._frameStore.getFrames().size();
        this._frameStore.deleteCls(clsAB3);
        int newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"first count", (int)(count - 1), (int)newCount);
        this._frameStore.undo();
        newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"second count", (int)count, (int)newCount);
        this._frameStore.redo();
        newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"third count", (int)(count - 1), (int)newCount);
        this._frameStore.undo();
        newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"forth count", (int)count, (int)newCount);
        String clsAName = this._frameStore.getFrameName(clsA);
        this._frameStore.deleteCls(clsA1);
        this._frameStore.deleteCls(clsA);
        newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"fifth count", (int)(count - 2), (int)newCount);
        this._frameStore.undo();
        this._frameStore.undo();
        newCount = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"sixth count", (int)count, (int)newCount);
        Frame frame = this._frameStore.getFrame(clsAName);
        UndoFrameStore_Test.assertNotNull((String)"clsA", (Object)frame);
    }

    public void testUndoSimpleTransaction() {
        Cls cls = this.createCls();
        Slot slot1 = this.createSlot();
        Slot slot2 = this.createSlot();
        cls.addDirectTemplateSlot(slot1);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = cls.createDirectInstance(null);
        this._frameStore.beginTransaction("simple nonsense");
        this._frameStore.setDirectOwnSlotValues(instance, slot1, UndoFrameStore_Test.makeList("foo1"));
        this._frameStore.setDirectOwnSlotValues(instance, slot2, UndoFrameStore_Test.makeList("foo2"));
        this._frameStore.commitTransaction();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo1"), this._frameStore.getDirectOwnSlotValues(instance, slot1));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo2"), this._frameStore.getDirectOwnSlotValues(instance, slot2));
        this._frameStore.undo();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList(), this._frameStore.getDirectOwnSlotValues(instance, slot1));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList(), this._frameStore.getDirectOwnSlotValues(instance, slot2));
        this._frameStore.redo();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo1"), this._frameStore.getDirectOwnSlotValues(instance, slot1));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo2"), this._frameStore.getDirectOwnSlotValues(instance, slot2));
    }

    public void testUndoDeleteSlot() {
    }

    public void testUndoDeleteFacet() {
    }

    public void testUndoDeleteSimpleInstance() {
    }

    public void testUndoSetDirectOwnSlotValues() {
    }

    public void testUndoSetFrameName() {
    }

    public void testUndoAddDirectTemplateSlot() {
    }

    public void testUndoRemoveDirectTemplateSlot() {
    }

    public void testUndoMoveDirectTemplateSlot() {
    }

    public void testUndoSetDirectTemplateSlotValues() {
    }

    public void testUndoRemoveDirectTemplateFacetOverrides() {
    }

    public void testUndoSetDirectTemplateFacetValues() {
    }

    public void testUndoAddDirectSuperclass() {
    }

    public void testUndoRemoveDirectSuperclass() {
    }

    public void testUndoMoveDirectSubclass() {
    }

    public void testUndoAddDirectSuperslot() {
    }

    public void testUndoRemoveDirectSuperslot() {
    }

    public void testUndoAddDirectType() {
    }

    public void testUndoMoveDirectType() {
    }

    public void testUndoCommitTransaction() {
    }

    public void testUndoRollbackTransaction() {
    }
}

