/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TraceFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    private Map<Method, Integer> methodCounts = new HashMap<Method, Integer>();
    private static Method executeQueryMethod;

    public Object handleInvoke(Method method, Object[] objectArray) {
        Object object = this.invoke(method, objectArray);
        this.trace(method, objectArray);
        return object;
    }

    protected void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
        Integer n = this.updateMethodCount(executeQueryMethod);
        TraceFrameStoreHandler.print(n, executeQueryMethod, new Object[]{query, queryCallback});
    }

    private void trace(Method method, Object[] objectArray) {
        Integer n = this.updateMethodCount(method);
        TraceFrameStoreHandler.print(n, method, objectArray);
    }

    private Integer updateMethodCount(Method method) {
        Integer n = this.methodCounts.get(method);
        Integer n2 = n == null ? new Integer(1) : new Integer(n + 1);
        this.methodCounts.put(method, n2);
        return n2;
    }

    public static void print(int n, Method method, Object[] objectArray) {
        Log.getLogger().info(n + " " + method.getName() + " " + TraceFrameStoreHandler.argString(objectArray));
    }

    private static String argString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof Frame) {
                    object = ((Frame)object).getFrameID();
                }
                stringBuffer.append(object);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            executeQueryMethod = FrameStore.class.getMethod("executeQuery", Query.class, QueryCallback.class);
        }
        catch (Exception exception) {
            Log.getLogger().warning("Non-fatal Problem encountered finding executeQuery method - contact developers");
        }
    }
}

