/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import java.util.List;

public class MergingNarrowFrameStore_Test
extends FrameStore_Test {
    protected FrameStore createFrameStore(DefaultKnowledgeBase kb) {
        return new InMemoryFrameStore(kb);
    }

    private MergingNarrowFrameStore getMergingFrameStore() {
        InMemoryFrameStore fs = (InMemoryFrameStore)this.getModifiableFrameStore(null);
        return (MergingNarrowFrameStore)fs.getHelper().getDelegate();
    }

    public void testMergingGetOwnSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        SimpleInstance instance = this.createSimpleInstance(cls);
        List values = MergingNarrowFrameStore_Test.makeList("foo", "bar");
        instance.setOwnSlotValues(slot, values);
        MergingNarrowFrameStore_Test.assertEqualsList(values, instance.getDirectOwnSlotValues(slot));
        MergingNarrowFrameStore fs = this.getMergingFrameStore();
        String childName = fs.getActiveFrameStore().getName();
        fs.addActiveFrameStore(new InMemoryFrameDb("parent"));
        fs.addRelation("parent", childName);
        MergingNarrowFrameStore_Test.assertEqualsList(values, instance.getDirectOwnSlotValues(slot));
        List newValues = MergingNarrowFrameStore_Test.makeList("foo", "bar", "baz");
        instance.setOwnSlotValues(slot, newValues);
        MergingNarrowFrameStore_Test.assertEqualsSet(newValues, instance.getDirectOwnSlotValues(slot));
    }

    public void testGetCounts() {
        int count = this.getFrameCount();
        this.createCls();
        MergingNarrowFrameStore_Test.assertEquals((int)(count + 1), (int)this.getFrameCount());
        MergingNarrowFrameStore fs = this.getMergingFrameStore();
        String parentName = fs.getActiveFrameStore().getName();
        fs.addActiveFrameStore(new InMemoryFrameDb("child"));
        fs.addRelation(parentName, "child");
        this.createCls();
        fs.setActiveFrameStore(parentName);
        MergingNarrowFrameStore_Test.assertEquals((int)(count + 2), (int)this.getFrameCount());
        this.createCls();
        MergingNarrowFrameStore_Test.assertEquals((int)(count + 3), (int)this.getFrameCount());
    }

    public void testInterleavedValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        SimpleInstance instance = this.createSimpleInstance(cls);
        List values = MergingNarrowFrameStore_Test.makeList("a", "b", "c");
        instance.setOwnSlotValues(slot, values);
        MergingNarrowFrameStore mnfs = this.getMergingFrameStore();
        NarrowFrameStore child = mnfs.getActiveFrameStore();
        mnfs.addActiveFrameStore(new InMemoryFrameDb("parent"));
        mnfs.addRelation("parent", child.getName());
        MergingNarrowFrameStore_Test.assertEqualsList(values, instance.getOwnSlotValues(slot));
        instance.setOwnSlotValues(slot, MergingNarrowFrameStore_Test.makeList("c", "d", "e", "f"));
        List allValues = MergingNarrowFrameStore_Test.makeList("a", "b", "c", "d", "e", "f");
        MergingNarrowFrameStore_Test.assertEqualsList(allValues, instance.getOwnSlotValues(slot));
        instance.moveDirectOwnSlotValue(slot, 1, 3);
        MergingNarrowFrameStore_Test.assertEqualsList(allValues, instance.getOwnSlotValues(slot));
        instance.moveDirectOwnSlotValue(slot, 4, 1);
        MergingNarrowFrameStore_Test.assertEqualsList(allValues, instance.getOwnSlotValues(slot));
        instance.moveDirectOwnSlotValue(slot, 3, 4);
        MergingNarrowFrameStore_Test.assertEqualsList(MergingNarrowFrameStore_Test.makeList("a", "b", "c", "e", "d", "f"), instance.getOwnSlotValues(slot));
    }
}

