/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FrameStore_Test
extends SimpleTestCase {
    private static transient Logger log = Log.getLogger(FrameStore_Test.class);
    private DefaultKnowledgeBase _kb;
    private FrameStore _testFrameStore;
    private FrameStore _modifiableFrameStore;
    private boolean _initialized = false;

    protected FrameStore_Test() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._kb = new DefaultKnowledgeBase();
        this._testFrameStore = this.createFrameStore(this._kb);
        this._modifiableFrameStore = this.getModifiableFrameStore(this._kb);
        if (this._testFrameStore != null && this._modifiableFrameStore != null) {
            this._initialized = true;
        }
        if (this._testFrameStore instanceof RemoteClientFrameStore) {
            this._kb.setGenerateEventsEnabled(false);
        }
        this._kb.setTerminalFrameStore(this._testFrameStore);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._kb.close();
        this._kb = null;
        this._testFrameStore = null;
        this._modifiableFrameStore = null;
    }

    protected FrameStore getTestFrameStore() {
        return this._testFrameStore;
    }

    protected abstract FrameStore createFrameStore(DefaultKnowledgeBase var1);

    protected FrameStore getModifiableFrameStore(DefaultKnowledgeBase kb) {
        return this._testFrameStore;
    }

    private static String createFrameName() {
        return "Frame_" + Math.random();
    }

    protected Cls createCls() {
        Cls parent = (Cls)this.getFrame(":THING");
        FrameStore_Test.assertNotNull((String)"thing", (Object)parent);
        return this.createCls(parent);
    }

    protected Slot createSlot(Slot slot) {
        return this.createSlot(null, FrameStore_Test.makeList(slot));
    }

    protected Slot createSlotOnCls(Cls cls) {
        Slot slot = this.createSlot();
        this.addTemplateSlot(cls, slot);
        return slot;
    }

    protected Slot createSlotOnCls(Cls cls, ValueType type, boolean allowsMultipleValues) {
        Slot slot = this.createSlotOnCls(cls);
        this.setTypeAndCardinality(slot, type, allowsMultipleValues);
        return slot;
    }

    private void setTypeAndCardinality(Slot slot, ValueType type, boolean allowsMultipleValues) {
        Slot valueTypeSlot = (Slot)this._testFrameStore.getFrame(":SLOT-VALUE-TYPE");
        if (FrameStore_Test.equals(type, ValueType.INSTANCE)) {
            Cls thing = (Cls)this._testFrameStore.getFrame(":THING");
            this._modifiableFrameStore.setDirectOwnSlotValues(slot, valueTypeSlot, FrameStore_Test.makeList(type.toString(), thing));
        } else {
            this._modifiableFrameStore.setDirectOwnSlotValues(slot, valueTypeSlot, FrameStore_Test.makeList(type.toString()));
        }
        Slot maxCardinalitySlot = (Slot)this._testFrameStore.getFrame(":SLOT-MAXIMUM-CARDINALITY");
        Set<Integer> values = allowsMultipleValues ? Collections.EMPTY_SET : Collections.singleton(new Integer(1));
        this._modifiableFrameStore.setDirectOwnSlotValues(slot, maxCardinalitySlot, values);
    }

    protected Slot createSlotOnCls(Cls cls, Cls directType) {
        Slot slot = this.createSlot(null, Collections.EMPTY_SET, directType);
        this.addTemplateSlot(cls, slot);
        return slot;
    }

    protected void addTemplateSlot(Cls cls, Slot slot) {
        this._modifiableFrameStore.addDirectTemplateSlot(cls, slot);
    }

    protected SimpleInstance createSimpleInstance(Cls type) {
        return this.createSimpleInstance(null, type);
    }

    private static FrameID getID() {
        return null;
    }

    protected SimpleInstance createSimpleInstance(String name, Cls type) {
        List types = FrameStore_Test.makeList(type);
        return this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(), name, types, true);
    }

    protected Cls createCls(Cls parent) {
        Cls directType = (Cls)this._testFrameStore.getFrame(":STANDARD-CLASS");
        FrameStore_Test.assertNotNull((String)"directType", (Object)directType);
        List types = FrameStore_Test.makeList(directType);
        List parents = FrameStore_Test.makeList(parent);
        return this._modifiableFrameStore.createCls(FrameStore_Test.getID(), null, types, parents, true);
    }

    protected Slot createSlot() {
        return this.createSlot((String)null);
    }

    protected Slot createSlot(String name) {
        return this.createSlot(name, Collections.EMPTY_LIST);
    }

    protected Slot createSlot(String name, Collection superslots) {
        Cls type = (Cls)this._testFrameStore.getFrame(":STANDARD-SLOT");
        return this.createSlot(name, superslots, type);
    }

    protected Slot createSlot(String name, Collection superslots, Cls type) {
        List types = FrameStore_Test.makeList(type);
        return this._modifiableFrameStore.createSlot(FrameStore_Test.getID(), name, types, superslots, true);
    }

    protected Facet createFacet() {
        return this.createFacet(ValueType.STRING);
    }

    protected Facet createFacet(ValueType valueType) {
        Cls type = (Cls)this._testFrameStore.getFrame(":STANDARD-FACET");
        return this.createFacet(valueType, type);
    }

    protected Facet createFacet(ValueType valueType, Cls directType) {
        List types = FrameStore_Test.makeList(directType);
        Facet facet = this._modifiableFrameStore.createFacet(FrameStore_Test.getID(), null, types, true);
        Cls defaultMetaSlot = (Cls)this._testFrameStore.getFrame(":STANDARD-SLOT");
        Cls metaCls = this.createCls(defaultMetaSlot);
        Slot associatedSlot = this.createSlotOnCls(metaCls);
        this.setTypeAndCardinality(associatedSlot, valueType, true);
        Slot associatedFacetSlot = (Slot)this._testFrameStore.getFrame(":ASSOCIATED-FACET");
        this._modifiableFrameStore.setDirectOwnSlotValues(associatedSlot, associatedFacetSlot, FrameStore_Test.makeList(facet));
        return facet;
    }

    protected Frame getFrame(String s) {
        return this._testFrameStore.getFrame(s);
    }

    protected int getFrameCount() {
        return this._testFrameStore.getFrameCount();
    }

    protected String getName(Frame frame) {
        return this._testFrameStore.getFrameName(frame);
    }

    protected void setOwnSlotValue(Frame frame, Slot slot, Object value) {
        Collection values = CollectionUtilities.createCollection(value);
        this._modifiableFrameStore.setDirectOwnSlotValues(frame, slot, values);
    }

    public void testClosure() {
        if (!this._initialized) {
            return;
        }
        Cls big = this.createCls();
        Slot slot = this.createSlotOnCls(big, ValueType.INSTANCE, true);
        SimpleInstance a = this.createSimpleInstance(big);
        SimpleInstance b = this.createSimpleInstance(big);
        SimpleInstance c = this.createSimpleInstance(big);
        HashSet<Instance> values = new HashSet<Instance>();
        values.add(b);
        values.add(c);
        this._modifiableFrameStore.setDirectOwnSlotValues(a, slot, values);
        Cls d = this.createCls();
        Cls e = this.createCls();
        SimpleInstance f = this.createSimpleInstance(d);
        values = new HashSet();
        values.add(d);
        values.add(e);
        values.add(f);
        this._modifiableFrameStore.setDirectOwnSlotValues(b, slot, values);
        SimpleInstance g = this.createSimpleInstance(e);
        values = new HashSet();
        values.add(g);
        this._modifiableFrameStore.setDirectOwnSlotValues(c, slot, values);
        HashSet<Instance> expected = new HashSet<Instance>();
        expected.add(b);
        expected.add(c);
        expected.add(d);
        expected.add(e);
        expected.add(f);
        expected.add(g);
        Set result = this._kb.getDirectOwnSlotValuesClosure(a, slot);
        FrameStore_Test.assertTrue((boolean)((Object)result).equals(expected));
        if (this._testFrameStore instanceof RemoteClientFrameStore) {
            int repeat = 10;
            this._testFrameStore.getDirectOwnSlotValues(a, slot);
            ((RemoteClientFrameStore)this._testFrameStore).flushCache();
            while (repeat-- > 0) {
                result = this._kb.getDirectOwnSlotValuesClosure(a, slot);
                FrameStore_Test.assertTrue((boolean)((Object)result).equals(expected));
            }
        }
    }

    public void testCreateCls() {
        if (!this._initialized) {
            return;
        }
        String name = FrameStore_Test.createFrameName();
        Cls directType = (Cls)this._testFrameStore.getFrame(":STANDARD-CLASS");
        Assert.assertNotNull("directType", directType);
        Cls parent = (Cls)this._testFrameStore.getFrame(":THING");
        List parents = FrameStore_Test.makeList(parent);
        List types = FrameStore_Test.makeList(directType);
        Cls cls = this._testFrameStore.createCls(FrameStore_Test.getID(), name, types, parents, true);
        FrameStore_Test.assertEquals((String)"name", (String)name, (String)this.getName(cls));
        FrameStore_Test.assertEquals((String)"direct type", (Object)directType, (Object)cls.getDirectType());
        FrameStore_Test.assertEqualsList("parents", parents, cls.getDirectSuperclasses());
        Cls fsCls = (Cls)this._testFrameStore.getFrame(name);
        FrameStore_Test.assertEquals((String)"pointer", (Object)cls, (Object)fsCls);
    }

    public void testGetFrame() {
        if (!this._initialized) {
            return;
        }
        Cls frame = this.createCls();
        String name = this._testFrameStore.getFrameName(frame);
        FrameStore_Test.assertNotNull((String)"name", (Object)name);
        FrameStore_Test.assertEquals((Object)frame, (Object)this._testFrameStore.getFrame(name));
    }

    public void testCreateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls standardSlot = (Cls)this.getFrame(":STANDARD-SLOT");
        List standardSlots = FrameStore_Test.makeList(standardSlot);
        Slot slota = this._testFrameStore.createSlot(FrameStore_Test.getID(), null, standardSlots, Collections.EMPTY_LIST, true);
        FrameStore_Test.assertNotNull((Object)slota);
        FrameStore_Test.assertEquals((String)"slota", (Object)slota, (Object)this.getFrame(this.getName(slota)));
        List types = this._testFrameStore.getDirectTypes(slota);
        FrameStore_Test.assertEquals((String)"types size", (int)1, (int)types.size());
        FrameStore_Test.assertEquals((String)"standard slot", (Object)standardSlot, types.iterator().next());
        Slot slotb = this._testFrameStore.createSlot(FrameStore_Test.getID(), null, standardSlots, Collections.EMPTY_LIST, true);
        List superslots = FrameStore_Test.makeList(slota, slotb);
        String slotName = FrameStore_Test.createFrameName();
        Slot slotc = this._testFrameStore.createSlot(FrameStore_Test.getID(), slotName, standardSlots, superslots, true);
        FrameStore_Test.assertNotNull((Object)slotc);
        FrameStore_Test.assertEquals((String)"slotc", (Object)slotc, (Object)this.getFrame(this.getName(slotc)));
        FrameStore_Test.assertEqualsSet("superslots", superslots, this._testFrameStore.getDirectSuperslots(slotc));
    }

    public void testCreateSimpleInstance() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        List types = FrameStore_Test.makeList(cls);
        SimpleInstance simpleInstance = this._testFrameStore.createSimpleInstance(FrameStore_Test.getID(), null, types, true);
        FrameStore_Test.assertNotNull((Object)simpleInstance);
        FrameStore_Test.assertEquals((Object)simpleInstance, (Object)this.getFrame(this.getName(simpleInstance)));
    }

    public void testCreateFacet() {
        if (!this._initialized) {
            return;
        }
        Cls cls = (Cls)this.getFrame(":STANDARD-FACET");
        List types = FrameStore_Test.makeList(cls);
        Facet facet = this._testFrameStore.createFacet(FrameStore_Test.getID(), null, types, true);
        FrameStore_Test.assertNotNull((Object)facet);
        FrameStore_Test.assertEquals((Object)facet, (Object)this.getFrame(this.getName(facet)));
    }

    public void testDeleteCls() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        FrameStore_Test.assertNotNull((Object)cls);
        String name = this.getName(cls);
        FrameStore_Test.assertNotNull((Object)name);
        this._testFrameStore.deleteCls(cls);
        FrameStore_Test.assertNull((String)"no class after delete", (Object)this.getFrame(name));
    }

    public void testDeleteSlot() {
        if (!this._initialized) {
            return;
        }
        String name = "deleteSlot";
        List types = FrameStore_Test.makeList(this.getFrame(":STANDARD-SLOT"));
        Slot slot = this._testFrameStore.createSlot(FrameStore_Test.getID(), name, types, Collections.EMPTY_LIST, true);
        FrameStore_Test.assertNotNull((Object)slot);
        this._testFrameStore.deleteSlot(slot);
        FrameStore_Test.assertNull((String)"no slot after delete", (Object)this.getFrame(name));
    }

    public void testDeleteFacet() {
        if (!this._initialized) {
            return;
        }
        String name = "deleteFacet";
        List types = FrameStore_Test.makeList(this.getFrame(":STANDARD-FACET"));
        Facet facet = this._testFrameStore.createFacet(FrameStore_Test.getID(), name, types, true);
        FrameStore_Test.assertNotNull((Object)facet);
        this._testFrameStore.deleteFacet(facet);
        FrameStore_Test.assertNull((String)"no facet after delete", (Object)this.getFrame(name));
    }

    public void testDeleteSimpleInstance() {
        if (!this._initialized) {
            return;
        }
        List types = FrameStore_Test.makeList(this.createCls());
        String name = "deleteSimpleInstance";
        SimpleInstance simpleInstance = this._testFrameStore.createSimpleInstance(FrameStore_Test.getID(), name, types, true);
        FrameStore_Test.assertNotNull((Object)simpleInstance);
        this._testFrameStore.deleteSimpleInstance(simpleInstance);
        FrameStore_Test.assertNull((String)"no simpleInstance after delete", (Object)this.getFrame(name));
    }

    public void testGetClses() {
        if (!this._initialized) {
            return;
        }
        ArrayList<Cls> clsesStart = new ArrayList<Cls>(this._testFrameStore.getClses());
        Cls thing = (Cls)this.getFrame(":THING");
        FrameStore_Test.assertNotNull((String)"thing not null", (Object)thing);
        FrameStore_Test.assertTrue((String)"thing", (boolean)clsesStart.contains(thing));
        Cls cls = this.createCls();
        Set<Cls> clsesEnd = this._testFrameStore.getClses();
        FrameStore_Test.assertEquals((String)"size", (int)(clsesStart.size() + 1), (int)clsesEnd.size());
        FrameStore_Test.assertTrue((String)"new class", (boolean)clsesEnd.contains(cls));
    }

    public void testGetInstances() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Set<Instance> instances = this._testFrameStore.getInstances(cls);
        FrameStore_Test.assertEquals((String)"none", (int)0, (int)instances.size());
        List types = FrameStore_Test.makeList(cls);
        this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(), null, types, true);
        instances = this._testFrameStore.getInstances(cls);
        FrameStore_Test.assertEquals((String)"after", (int)1, (int)instances.size());
    }

    public void testAddDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        this._testFrameStore.addDirectTemplateSlot(cls, slot);
        List slots = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size", (int)1, (int)slots.size());
        FrameStore_Test.assertEquals((String)"value", (Object)slot, slots.get(0));
    }

    public void testGetOwnSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        this.createSlotOnCls(cls);
        Cls subclass = this.createCls(cls);
        this.createSlotOnCls(subclass);
        List subclasses = FrameStore_Test.makeList(subclass);
        SimpleInstance instance = this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(), null, subclasses, true);
        Set<Slot> ownSlots = this._testFrameStore.getOwnSlots(instance);
        Set templateSlots = this._testFrameStore.getTemplateSlots(subclass);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)templateSlots.size());
        HashSet<Frame> testOwnSlots = new HashSet<Frame>(templateSlots);
        testOwnSlots.add(this.getFrame(":NAME"));
        testOwnSlots.add(this.getFrame(":DIRECT-TYPE"));
        FrameStore_Test.assertEquals((String)"sets", testOwnSlots, ownSlots);
    }

    public void testGetTemplateSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Cls subclass = this.createCls(cls);
        Slot slotb = this.createSlotOnCls(subclass);
        Cls subsubclass = this.createCls(subclass);
        Set slots = this._modifiableFrameStore.getTemplateSlots(subsubclass);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)slots.size());
        FrameStore_Test.assertTrue((String)"slot", (boolean)slots.contains(slot));
        FrameStore_Test.assertTrue((String)"slotb", (boolean)slots.contains(slotb));
    }

    public void testGetDirectOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List classes = FrameStore_Test.makeList(cls);
        SimpleInstance instance = this._modifiableFrameStore.createSimpleInstance(FrameStore_Test.getID(), null, classes, true);
        List values = FrameStore_Test.makeList("foo", "bar");
        List oldValues = this._testFrameStore.getDirectOwnSlotValues(instance, slot);
        this._modifiableFrameStore.setDirectOwnSlotValues(instance, slot, values);
        FrameStore_Test.assertEquals((String)"oldsize", (int)0, (int)oldValues.size());
        List newValues = this._testFrameStore.getDirectOwnSlotValues(instance, slot);
        FrameStore_Test.assertEquals((String)"newsize", (int)values.size(), (int)newValues.size());
        FrameStore_Test.assertEquals((String)"lists", (Object)values, (Object)newValues);
    }

    public void testGetReferences() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slota = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slotb = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot dislot = (Slot)this._testFrameStore.getFrame(":DIRECT-INSTANCES");
        Facet facet = this.createFacet(ValueType.INSTANCE);
        SimpleInstance instanceA = this.createSimpleInstance(cls);
        SimpleInstance instanceB = this.createSimpleInstance(cls);
        List instances = FrameStore_Test.makeList(instanceB);
        this._modifiableFrameStore.setDirectOwnSlotValues(instanceA, slota, instances);
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slotb, instances);
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slota, facet, instances);
        Set references = this._testFrameStore.getReferences(instanceB);
        FrameStore_Test.assertTrue((String)"own slot value", (boolean)references.contains(new ReferenceImpl(instanceA, slota, null, false)));
        FrameStore_Test.assertTrue((String)"type", (boolean)references.contains(new ReferenceImpl(cls, dislot, null, false)));
        FrameStore_Test.assertTrue((String)"facet value", (boolean)references.contains(new ReferenceImpl(cls, slota, facet, true)));
        FrameStore_Test.assertEquals((String)"size", (int)4, (int)references.size());
    }

    public void testGetFrames() {
        if (!this._initialized) {
            return;
        }
        Frame thing = this._testFrameStore.getFrame(":THING");
        Set<Frame> oldFrames = this._testFrameStore.getFrames();
        int size = oldFrames.size();
        FrameStore_Test.assertTrue((String)"contains thing", (boolean)oldFrames.contains(thing));
        Cls cls = this.createCls();
        this.createSlot();
        this.createSimpleInstance(cls);
        Set<Frame> frames = this._testFrameStore.getFrames();
        FrameStore_Test.assertEquals((String)"size", (int)(size + 3), (int)frames.size());
    }

    public void testGetFrameName() {
        if (!this._initialized) {
            return;
        }
        String testName = FrameStore_Test.createFrameName();
        FrameStore_Test.assertNull((String)"before create", (Object)this._testFrameStore.getFrame(testName));
        Cls cls = this.createCls();
        this._modifiableFrameStore.setFrameName(cls, testName);
        FrameStore_Test.assertEquals((String)"frame", (Object)cls, (Object)this._testFrameStore.getFrame(testName));
        FrameStore_Test.assertEquals((String)"name", (String)testName, (String)this._testFrameStore.getFrameName(cls));
    }

    public void testSetFrameName() {
        if (!this._initialized) {
            return;
        }
        String name = FrameStore_Test.createFrameName();
        Cls cls = this.createCls();
        String oldName = this._testFrameStore.getFrameName(cls);
        FrameStore_Test.assertNull((String)"before", (Object)this._testFrameStore.getFrame(name));
        this._testFrameStore.setFrameName(cls, name);
        FrameStore_Test.assertEquals((String)"new name", (Object)cls, (Object)this._testFrameStore.getFrame(name));
        FrameStore_Test.assertNull((String)"oldName", (Object)this._testFrameStore.getFrame(oldName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering testGetOwnSlotValues");
        }
        try {
            Cls cls = this.createCls();
            Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
            List templateValues = FrameStore_Test.makeList("foo", "bar");
            this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, templateValues);
            SimpleInstance instance = this.createSimpleInstance(cls);
            List ownValues = FrameStore_Test.makeList("foob", "baz");
            this._modifiableFrameStore.setDirectOwnSlotValues(instance, slot, ownValues);
            Collection values = this._testFrameStore.getOwnSlotValues(instance, slot);
            HashSet originalValues = new HashSet(templateValues);
            originalValues.addAll(ownValues);
            FrameStore_Test.assertEqualsSet("size", originalValues, values);
        }
        finally {
            if (log.isLoggable(Level.FINE)) {
                log.fine("testGetOwnSlotValues completed...");
            }
        }
    }

    public void testSetDirectOwnSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance instance = this.createSimpleInstance(cls);
        List values = FrameStore_Test.makeList("foo", "bar");
        List oldValues = this._testFrameStore.getDirectOwnSlotValues(instance, slot);
        FrameStore_Test.assertEquals((String)"no old values", (int)0, (int)oldValues.size());
        this._testFrameStore.setDirectOwnSlotValues(instance, slot, values);
        List newValues = this._testFrameStore.getDirectOwnSlotValues(instance, slot);
        FrameStore_Test.assertEqualsList("values", values, newValues);
        this._testFrameStore.setDirectOwnSlotValues(instance, slot, Collections.EMPTY_SET);
        List emptyValues = this._testFrameStore.getDirectOwnSlotValues(instance, slot);
        FrameStore_Test.assertEquals((String)"empty values", (int)0, (int)emptyValues.size());
    }

    public void testGetDirectTemplateSlots() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        List oldSlots = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"old values", (int)0, (int)oldSlots.size());
        Slot slota = this.createSlotOnCls(cls);
        Slot slotb = this.createSlotOnCls(cls);
        List slots = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size", (int)2, (int)slots.size());
        FrameStore_Test.assertTrue((String)"a", (boolean)slots.contains(slota));
        FrameStore_Test.assertTrue((String)"b", (boolean)slots.contains(slotb));
    }

    public void testRemoveDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slota = this.createSlotOnCls(cls);
        Slot slotb = this.createSlotOnCls(cls);
        Slot slotc = this.createSlotOnCls(cls);
        FrameStore_Test.assertEquals((String)"size1", (int)3, (int)this._testFrameStore.getDirectTemplateSlots(cls).size());
        this._testFrameStore.removeDirectTemplateSlot(cls, slotb);
        List newValues = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEquals((String)"size2", (int)2, (int)newValues.size());
        FrameStore_Test.assertTrue((String)"contains a", (boolean)newValues.contains(slota));
        FrameStore_Test.assertTrue((String)"contains c", (boolean)newValues.contains(slotc));
        this._testFrameStore.removeDirectTemplateSlot(cls, slota);
        this._testFrameStore.removeDirectTemplateSlot(cls, slotc);
        FrameStore_Test.assertEquals((String)"size3", (int)0, (int)this._testFrameStore.getDirectTemplateSlots(cls).size());
    }

    public void testMoveDirectTemplateSlot() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slota = this.createSlotOnCls(cls);
        Slot slotb = this.createSlotOnCls(cls);
        Slot slotc = this.createSlotOnCls(cls);
        List slots = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEqualsList("start", FrameStore_Test.makeList(slota, slotb, slotc), slots);
        this._testFrameStore.moveDirectTemplateSlot(cls, slota, 2);
        this._testFrameStore.moveDirectTemplateSlot(cls, slotc, 0);
        List movedSlots = this._testFrameStore.getDirectTemplateSlots(cls);
        FrameStore_Test.assertEqualsList("end", FrameStore_Test.makeList(slotc, slotb, slota), movedSlots);
    }

    public void testGetTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls subclass = this.createCls(cls);
        Slot slot = this.createSlotOnCls(cls);
        List clsValues = FrameStore_Test.makeList("foo");
        List subclassValues = FrameStore_Test.makeList("bar");
        ArrayList allValues = new ArrayList(clsValues);
        allValues.addAll(subclassValues);
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, clsValues);
        Collection clsValues1 = this._testFrameStore.getTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsSet("class values", clsValues, clsValues1);
        Collection subclassValues1 = this._testFrameStore.getTemplateSlotValues(subclass, slot);
        FrameStore_Test.assertEqualsSet("subclass values1", clsValues, subclassValues1);
        this._modifiableFrameStore.setDirectTemplateSlotValues(subclass, slot, subclassValues);
        Collection subclassValues2 = this._testFrameStore.getTemplateSlotValues(subclass, slot);
        FrameStore_Test.assertEqualsSet("subclass values2", allValues, subclassValues2);
    }

    public void testGetDirectTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List oldValues = FrameStore_Test.makeList("foo", "bar");
        this._modifiableFrameStore.setDirectTemplateSlotValues(cls, slot, oldValues);
        List newValues = this._testFrameStore.getDirectTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsList("values", oldValues, newValues);
    }

    public void testSetDirectTemplateSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        List oldValues = FrameStore_Test.makeList("foo", "bar");
        this._testFrameStore.setDirectTemplateSlotValues(cls, slot, oldValues);
        List newValues = this._testFrameStore.getDirectTemplateSlotValues(cls, slot);
        FrameStore_Test.assertEqualsList("values", oldValues, newValues);
    }

    public void testGetTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        Facet facet = this.createFacet();
        Cls subclass = this.createCls(cls);
        Cls subsubclass = this.createCls(subclass);
        List clsValues = FrameStore_Test.makeList("foo");
        List subclassValues = FrameStore_Test.makeList("bar");
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slot, facet, clsValues);
        this._modifiableFrameStore.setDirectTemplateFacetValues(subclass, slot, facet, subclassValues);
        this._testFrameStore.getDirectTemplateFacetValues(cls, slot, facet);
        this._testFrameStore.getDirectTemplateFacetValues(subclass, slot, facet);
        this._testFrameStore.getDirectTemplateFacetValues(subsubclass, slot, facet);
    }

    public void testGetDirectTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls slotMetaCls = this.createCls(this._kb.getDefaultSlotMetaCls());
        Slot metaSlot = this.createSlotOnCls(slotMetaCls, ValueType.STRING, true);
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        this.setDirectType(slot, slotMetaCls);
        Facet facet = this.createFacet();
        Slot associatedFacetSlot = (Slot)this.getFrame(":ASSOCIATED-FACET");
        Collection facets = CollectionUtilities.createCollection(facet);
        this._modifiableFrameStore.setDirectOwnSlotValues(metaSlot, associatedFacetSlot, facets);
        List oldValues = FrameStore_Test.makeList("foo", "bar");
        this._modifiableFrameStore.setDirectTemplateFacetValues(cls, slot, facet, oldValues);
        List newValues = this._testFrameStore.getDirectTemplateFacetValues(cls, slot, facet);
        FrameStore_Test.assertEqualsList("values", oldValues, newValues);
    }

    private void setDirectType(Instance instance, Cls type) {
        Cls currentType = instance.getDirectType();
        this._modifiableFrameStore.addDirectType(instance, type);
        this._modifiableFrameStore.removeDirectType(instance, currentType);
    }

    public void testSetDirectTemplateFacetValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls slotMetaCls = this.createCls(this._kb.getDefaultSlotMetaCls());
        Slot metaSlot = this.createSlotOnCls(slotMetaCls, ValueType.STRING, true);
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        slot.setDirectType(slotMetaCls);
        Facet facet = this.createFacet();
        metaSlot.setAssociatedFacet(facet);
        List oldValues = FrameStore_Test.makeList("foo", "bar");
        this._testFrameStore.setDirectTemplateFacetValues(cls, slot, facet, oldValues);
        List newValues = this._testFrameStore.getDirectTemplateFacetValues(cls, slot, facet);
        FrameStore_Test.assertEqualsList("values", oldValues, newValues);
    }

    public void testGetDirectSuperclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Cls subclass = this.createCls(cls);
        this._modifiableFrameStore.addDirectSuperclass(subclass, cls2);
        List<Cls> clses = this._testFrameStore.getDirectSuperclasses(subclass);
        FrameStore_Test.assertEqualsList("clses", FrameStore_Test.makeList(cls, cls2), clses);
    }

    public void testGetSuperclasses() {
        if (!this._initialized) {
            return;
        }
        Cls thing = (Cls)this.getFrame(":THING");
        Cls cls = this.createCls(thing);
        Cls cls2 = this.createCls(thing);
        Cls subclass = this.createCls(cls);
        Cls subsubclass = this.createCls(subclass);
        this._modifiableFrameStore.addDirectSuperclass(subclass, cls2);
        Set clses = this._testFrameStore.getSuperclasses(subsubclass);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(thing, cls, cls2, subclass), clses);
    }

    public void testGetDirectSubclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls subclass1 = this.createCls(cls);
        Cls subclass2 = this.createCls(cls);
        List<Cls> clses = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("clses", FrameStore_Test.makeList(subclass1, subclass2), clses);
    }

    public void testGetSubclasses() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls subclass = this.createCls(cls);
        Cls subsubclass1 = this.createCls(subclass);
        Cls subsubclass2 = this.createCls(subclass);
        Set<Cls> clses = this._testFrameStore.getSubclasses(cls);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(subclass, subsubclass1, subsubclass2), clses);
    }

    public void testAddDirectSuperclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls2);
        this._testFrameStore.addDirectSuperclass(cls4, cls3);
        List<Cls> clses = this._testFrameStore.getDirectSuperclasses(cls4);
        FrameStore_Test.assertEqualsSet("clses", FrameStore_Test.makeList(cls2, cls3), clses);
    }

    public void testRemoveDirectSuperclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls(cls);
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls);
        Cls cls5 = this.createCls(cls2);
        this._modifiableFrameStore.addDirectSuperclass(cls5, cls3);
        this._modifiableFrameStore.addDirectSuperclass(cls5, cls4);
        List<Cls> clses = this._testFrameStore.getDirectSuperclasses(cls5);
        FrameStore_Test.assertEqualsSet("clses start", FrameStore_Test.makeList(cls2, cls3, cls4), clses);
        this._testFrameStore.removeDirectSuperclass(cls5, cls2);
        clses = this._testFrameStore.getDirectSuperclasses(cls5);
        FrameStore_Test.assertEqualsSet("clses end", FrameStore_Test.makeList(cls3, cls4), clses);
    }

    public void testMoveDirectSubclass() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls clsa = this.createCls(cls);
        Cls clsb = this.createCls(cls);
        Cls clsc = this.createCls(cls);
        List<Cls> clses = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("start", FrameStore_Test.makeList(clsa, clsb, clsc), clses);
        this._testFrameStore.moveDirectSubclass(cls, clsa, 1);
        clses = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(clsb, clsa, clsc), clses);
        this._testFrameStore.moveDirectSubclass(cls, clsa, 2);
        clses = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(clsb, clsc, clsa), clses);
        this._testFrameStore.moveDirectSubclass(cls, clsa, 0);
        clses = this._testFrameStore.getDirectSubclasses(cls);
        FrameStore_Test.assertEqualsList("3", FrameStore_Test.makeList(clsa, clsb, clsc), clses);
    }

    public void testGetDirectSuperslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slota = this.createSlot(slot);
        Slot slotb = this.createSlot(slot);
        Slot slotc = this.createSlot(slota);
        this._modifiableFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEquals((String)"no superslots", (int)0, (int)this._testFrameStore.getDirectSuperslots(slot).size());
        FrameStore_Test.assertEqualsList("1 superslot", FrameStore_Test.makeList(slot), this._testFrameStore.getDirectSuperslots(slota));
        FrameStore_Test.assertEqualsList("2 superslots", FrameStore_Test.makeList(slota, slotb), this._testFrameStore.getDirectSuperslots(slotc));
    }

    public void testGetSuperslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slota = this.createSlot(slot);
        Slot slotb = this.createSlot(slot);
        Slot slotc = this.createSlot(slota);
        this._modifiableFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEquals((String)"no superslots", (int)0, (int)this._testFrameStore.getSuperslots(slot).size());
        FrameStore_Test.assertEqualsSet("1 superslot", FrameStore_Test.makeList(slot), this._testFrameStore.getSuperslots(slota));
        FrameStore_Test.assertEqualsSet("2 superslots", FrameStore_Test.makeList(slot, slota, slotb), this._testFrameStore.getSuperslots(slotc));
    }

    public void testGetDirectSubslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slota = this.createSlot(slot);
        Slot slotb = this.createSlot(slot);
        Slot slotc = this.createSlot(slota);
        this._modifiableFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEqualsList("slot", FrameStore_Test.makeList(slota, slotb), this._testFrameStore.getDirectSubslots(slot));
        FrameStore_Test.assertEqualsList("slota", FrameStore_Test.makeList(slotc), this._testFrameStore.getDirectSubslots(slota));
        FrameStore_Test.assertEqualsList("slotc", FrameStore_Test.makeList(), this._testFrameStore.getDirectSubslots(slotc));
    }

    public void testGetSubslots() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slota = this.createSlot(slot);
        Slot slotb = this.createSlot(slot);
        Slot slotc = this.createSlot(slota);
        this._modifiableFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEqualsSet("slot", FrameStore_Test.makeList(slota, slotb, slotc), this._testFrameStore.getSubslots(slot));
        FrameStore_Test.assertEqualsSet("slota", FrameStore_Test.makeList(slotc), this._testFrameStore.getDirectSubslots(slota));
        FrameStore_Test.assertEqualsSet("slotc", FrameStore_Test.makeList(), this._testFrameStore.getDirectSubslots(slotc));
    }

    public void testAddDirectSuperslot() {
        if (!this._initialized) {
            return;
        }
        Slot slot = this.createSlot();
        Slot slotb = this.createSlot();
        Slot slotc = this.createSlot(slot);
        this._testFrameStore.addDirectSuperslot(slotb, slot);
        FrameStore_Test.assertEqualsList("b", FrameStore_Test.makeList(slot), this._testFrameStore.getDirectSuperslots(slotb));
        this._testFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEqualsList("c", FrameStore_Test.makeList(slot, slotb), this._testFrameStore.getDirectSuperslots(slotc));
    }

    public void testRemoveDirectSuperslot() {
        if (!this._initialized) {
            return;
        }
        Slot slota = this.createSlot();
        Slot slotb = this.createSlot();
        Slot slotc = this.createSlot(slota);
        this._modifiableFrameStore.addDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEqualsList("c", FrameStore_Test.makeList(slota, slotb), this._testFrameStore.getDirectSuperslots(slotc));
        this._testFrameStore.removeDirectSuperslot(slotc, slota);
        FrameStore_Test.assertEqualsList("c1", FrameStore_Test.makeList(slotb), this._testFrameStore.getDirectSuperslots(slotc));
        this._testFrameStore.removeDirectSuperslot(slotc, slotb);
        FrameStore_Test.assertEqualsList("c0", FrameStore_Test.makeList(), this._testFrameStore.getDirectSuperslots(slotc));
    }

    public void testGetDirectTypes() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        SimpleInstance instance = this.createSimpleInstance(cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls), this._testFrameStore.getDirectTypes(instance));
        this._modifiableFrameStore.addDirectType(instance, cls2);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(cls, cls2), this._testFrameStore.getDirectTypes(instance));
    }

    public void testGetTypes() {
        if (!this._initialized) {
            return;
        }
        Cls thing = (Cls)this.getFrame(":THING");
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        SimpleInstance instance = this.createSimpleInstance(cls);
        FrameStore_Test.assertEqualsSet("1", FrameStore_Test.makeList(cls, thing), this._testFrameStore.getTypes(instance));
        this._modifiableFrameStore.addDirectType(instance, cls2);
        FrameStore_Test.assertEqualsSet("2", FrameStore_Test.makeList(cls, cls2, thing), this._testFrameStore.getTypes(instance));
    }

    public void testGetDirectInstances() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        SimpleInstance instanceA = this.createSimpleInstance(null, cls);
        SimpleInstance instanceB = this.createSimpleInstance(null, cls);
        SimpleInstance instancec = this.createSimpleInstance(null, cls);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(instanceA, instanceB, instancec), this._testFrameStore.getDirectInstances(cls));
    }

    public void testAddDirectType() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls clsb = this.createCls();
        SimpleInstance instance = this.createSimpleInstance(cls);
        this._testFrameStore.addDirectType(instance, clsb);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls, clsb), this._testFrameStore.getDirectTypes(instance));
    }

    public void testRemoveDirectType() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Cls clsb = this.createCls();
        SimpleInstance instance = this.createSimpleInstance(cls);
        this._testFrameStore.addDirectType(instance, clsb);
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(cls, clsb), this._testFrameStore.getDirectTypes(instance));
        this._testFrameStore.removeDirectType(instance, cls);
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(clsb), this._testFrameStore.getDirectTypes(instance));
    }

    public void testGetSlots() {
        if (!this._initialized) {
            return;
        }
        Cls standardSlot = (Cls)this.getFrame(":STANDARD-SLOT");
        Cls slotMetaCls = this.createCls(standardSlot);
        Set<Slot> standardSlots = this._testFrameStore.getSlots();
        Slot slot = this.createSlot();
        Slot slotb = this.createSlot(slot);
        Slot slotc = this.createSlotOnCls(slotMetaCls);
        List results = FrameStore_Test.makeList(slot, slotb, slotc);
        results.addAll(standardSlots);
        FrameStore_Test.assertEqualsSet("slots", results, this._testFrameStore.getSlots());
    }

    public void testGetFacets() {
        if (!this._initialized) {
            return;
        }
        Cls standardFacet = (Cls)this.getFrame(":STANDARD-FACET");
        Cls facetMetaCls = this.createCls(standardFacet);
        Set<Facet> standardFacets = this._testFrameStore.getFacets();
        Facet facet = this.createFacet();
        Facet facetb = this.createFacet();
        Facet facetc = this.createFacet(ValueType.STRING, facetMetaCls);
        List results = FrameStore_Test.makeList(facet, facetb, facetc);
        results.addAll(standardFacets);
        FrameStore_Test.assertEqualsSet("slots", results, this._testFrameStore.getFacets());
    }

    private Set getMatchingReferences(String text) {
        return this._testFrameStore.getMatchingReferences(text, -1);
    }

    public void testGetMatchingReferences() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance instance = this.createSimpleInstance(cls);
        int exactStartSize = this.getMatchingReferences("refxxx").size();
        int startsWithStartSize = this.getMatchingReferences("refxxx*").size();
        int containsStartSize = this.getMatchingReferences("*EFx*").size();
        this._modifiableFrameStore.setDirectOwnSlotValues(instance, slot, FrameStore_Test.makeList("refxxx", "erexxx"));
        SimpleInstance instance2 = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instance2, slot, FrameStore_Test.makeList("refxxxerexxx"));
        Set references = this.getMatchingReferences("refxxx");
        FrameStore_Test.assertEquals((String)"exact", (int)(exactStartSize + 1), (int)references.size());
        Set references2 = this.getMatchingReferences("refxxx*");
        FrameStore_Test.assertEquals((String)"startswith", (int)(startsWithStartSize + 2), (int)references2.size());
        Set references3 = this.getMatchingReferences("*EFx*");
        FrameStore_Test.assertEquals((String)"contains", (int)(containsStartSize + 2), (int)references3.size());
    }

    public void testGetFramesWithOwnSlotValue() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance instanceA = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instanceA, slot, FrameStore_Test.makeList("own", "value"));
        SimpleInstance instanceB = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instanceB, slot, FrameStore_Test.makeList("foo", "own"));
        FrameStore_Test.assertEqualsSet("values", FrameStore_Test.makeList(instanceA, instanceB), this._testFrameStore.getFramesWithDirectOwnSlotValue(slot, "own"));
    }

    public void testGetFramesWithMatchingOwnSlotValue() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, ValueType.STRING, true);
        SimpleInstance instanceA = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instanceA, slot, FrameStore_Test.makeList("own", "value"));
        SimpleInstance instanceB = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instanceB, slot, FrameStore_Test.makeList("foo", "own"));
        SimpleInstance instancec = this.createSimpleInstance(cls);
        this._modifiableFrameStore.setDirectOwnSlotValues(instancec, slot, FrameStore_Test.makeList("owx"));
        FrameStore_Test.assertEqualsSet("exact", FrameStore_Test.makeList(instanceA, instanceB), this._testFrameStore.getFramesWithMatchingDirectOwnSlotValue(slot, "own", -1));
        FrameStore_Test.assertEqualsSet("starts with", FrameStore_Test.makeList(instanceA, instanceB, instancec), this._testFrameStore.getFramesWithMatchingDirectOwnSlotValue(slot, "OW*", -1));
    }

    public void testGetTemplateFacets() {
        if (!this._initialized) {
            return;
        }
        Cls standardSlot = (Cls)this.getFrame(":STANDARD-SLOT");
        Slot associatedFacetSlot = (Slot)this.getFrame(":ASSOCIATED-FACET");
        Cls slotMetaCls = this.createCls(standardSlot);
        Slot metaClsSlot = this.createSlotOnCls(slotMetaCls);
        Facet facet = this.createFacet();
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls, slotMetaCls);
        this.setOwnSlotValue(metaClsSlot, associatedFacetSlot, facet);
        Set<Facet> facets = this._testFrameStore.getTemplateFacets(cls, slot);
        FrameStore_Test.assertTrue((String)"new facet", (boolean)facets.contains(facet));
    }

    public void testSetInverseSlotValues() {
        if (!this._initialized) {
            return;
        }
        Cls cls = this.createCls();
        Slot slota = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot slotb = this.createSlotOnCls(cls, ValueType.INSTANCE, true);
        Slot inverseSlotSlot = (Slot)this.getFrame(":SLOT-INVERSE");
        this.setOwnSlotValue(slota, inverseSlotSlot, slotb);
        SimpleInstance instance1 = this.createSimpleInstance(cls);
        SimpleInstance instance2 = this.createSimpleInstance(cls);
        Cls clsc = this.createCls();
        SimpleInstance instance3 = this.createSimpleInstance(clsc);
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(instance1, slota).size());
        this._testFrameStore.setDirectOwnSlotValues(instance1, slota, FrameStore_Test.makeList(instance2));
        FrameStore_Test.assertEqualsList("1", FrameStore_Test.makeList(instance2), this._testFrameStore.getDirectOwnSlotValues(instance1, slota));
        FrameStore_Test.assertEqualsList("2", FrameStore_Test.makeList(instance1), this._testFrameStore.getDirectOwnSlotValues(instance2, slotb));
        this._testFrameStore.setDirectOwnSlotValues(instance2, slotb, FrameStore_Test.makeList(instance3));
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(instance1, slota).size());
        FrameStore_Test.assertEqualsList("3", FrameStore_Test.makeList(instance3), this._testFrameStore.getDirectOwnSlotValues(instance2, slotb));
        FrameStore_Test.assertEquals((int)0, (int)this._testFrameStore.getDirectOwnSlotValues(instance3, slota).size());
    }
}

