/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FrameStore {
    public static final int UNLIMITED_MATCHES = -1;

    public String getName();

    public void setDelegate(FrameStore var1);

    public FrameStore getDelegate();

    public void reinitialize();

    public int getClsCount();

    public int getSlotCount();

    public int getFacetCount();

    public int getSimpleInstanceCount();

    public int getFrameCount();

    public Set<Cls> getClses();

    public Set<Slot> getSlots();

    public Set<Facet> getFacets();

    public Set<Frame> getFrames();

    public Frame getFrame(FrameID var1);

    public Frame getFrame(String var1);

    public String getFrameName(Frame var1);

    public void setFrameName(Frame var1, String var2);

    public Cls createCls(FrameID var1, String var2, Collection var3, Collection var4, boolean var5);

    public Slot createSlot(FrameID var1, String var2, Collection var3, Collection var4, boolean var5);

    public Facet createFacet(FrameID var1, String var2, Collection var3, boolean var4);

    public SimpleInstance createSimpleInstance(FrameID var1, String var2, Collection var3, boolean var4);

    public void deleteCls(Cls var1);

    public void deleteSlot(Slot var1);

    public void deleteFacet(Facet var1);

    public void deleteSimpleInstance(SimpleInstance var1);

    public Set<Slot> getOwnSlots(Frame var1);

    public Collection getOwnSlotValues(Frame var1, Slot var2);

    public List getDirectOwnSlotValues(Frame var1, Slot var2);

    public int getDirectOwnSlotValuesCount(Frame var1, Slot var2);

    public void moveDirectOwnSlotValue(Frame var1, Slot var2, int var3, int var4);

    public void setDirectOwnSlotValues(Frame var1, Slot var2, Collection var3);

    public Set getOwnFacets(Frame var1, Slot var2);

    public Collection getOwnFacetValues(Frame var1, Slot var2, Facet var3);

    public Set getTemplateSlots(Cls var1);

    public List getDirectTemplateSlots(Cls var1);

    public List getDirectDomain(Slot var1);

    public Set getDomain(Slot var1);

    public Set getOverriddenTemplateSlots(Cls var1);

    public Set getDirectlyOverriddenTemplateSlots(Cls var1);

    public void addDirectTemplateSlot(Cls var1, Slot var2);

    public void removeDirectTemplateSlot(Cls var1, Slot var2);

    public void moveDirectTemplateSlot(Cls var1, Slot var2, int var3);

    public Collection getTemplateSlotValues(Cls var1, Slot var2);

    public List getDirectTemplateSlotValues(Cls var1, Slot var2);

    public void setDirectTemplateSlotValues(Cls var1, Slot var2, Collection var3);

    public Set<Facet> getTemplateFacets(Cls var1, Slot var2);

    public Set getOverriddenTemplateFacets(Cls var1, Slot var2);

    public Set getDirectlyOverriddenTemplateFacets(Cls var1, Slot var2);

    public void removeDirectTemplateFacetOverrides(Cls var1, Slot var2);

    public Collection getTemplateFacetValues(Cls var1, Slot var2, Facet var3);

    public List getDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3);

    public void setDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3, Collection var4);

    public List<Cls> getDirectSuperclasses(Cls var1);

    public Set getSuperclasses(Cls var1);

    public List<Cls> getDirectSubclasses(Cls var1);

    public Set<Cls> getSubclasses(Cls var1);

    public void addDirectSuperclass(Cls var1, Cls var2);

    public void removeDirectSuperclass(Cls var1, Cls var2);

    public void moveDirectSubclass(Cls var1, Cls var2, int var3);

    public List getDirectSuperslots(Slot var1);

    public Set getSuperslots(Slot var1);

    public List getDirectSubslots(Slot var1);

    public Set getSubslots(Slot var1);

    public void addDirectSuperslot(Slot var1, Slot var2);

    public void removeDirectSuperslot(Slot var1, Slot var2);

    public void moveDirectSubslot(Slot var1, Slot var2, int var3);

    public List getDirectTypes(Instance var1);

    public Set getTypes(Instance var1);

    public List<Instance> getDirectInstances(Cls var1);

    public Set<Instance> getInstances(Cls var1);

    public void addDirectType(Instance var1, Cls var2);

    public void removeDirectType(Instance var1, Cls var2);

    public void moveDirectType(Instance var1, Cls var2, int var3);

    public List<AbstractEvent> getEvents();

    public void executeQuery(Query var1, QueryCallback var2);

    public Set getReferences(Object var1);

    public Set getMatchingReferences(String var1, int var2);

    public Set getClsesWithMatchingBrowserText(String var1, Collection var2, int var3);

    public Set getFramesWithDirectOwnSlotValue(Slot var1, Object var2);

    public Set getFramesWithAnyDirectOwnSlotValue(Slot var1);

    public Set getFramesWithMatchingDirectOwnSlotValue(Slot var1, String var2, int var3);

    public Set getClsesWithDirectTemplateSlotValue(Slot var1, Object var2);

    public Set getClsesWithAnyDirectTemplateSlotValue(Slot var1);

    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot var1, String var2, int var3);

    public Set getClsesWithDirectTemplateFacetValue(Slot var1, Facet var2, Object var3);

    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot var1, Facet var2, String var3, int var4);

    public Set getDirectOwnSlotValuesClosure(Frame var1, Slot var2);

    public boolean beginTransaction(String var1);

    public boolean commitTransaction();

    public boolean rollbackTransaction();

    public TransactionMonitor getTransactionStatusMonitor();

    public void close();
}

