/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.test.APITestCase;

public class Transaction_Test
extends APITestCase {
    public void setUp() throws Exception {
        super.setUp();
        Transaction_Test.chooseDBType();
        Transaction_Test.setDatabaseProject();
    }

    public void testCommit() {
        int initialFrameCount = this.getFrameCount();
        Transaction t = new Transaction(this.getDomainKB()){

            public boolean doOperations() {
                KnowledgeBase kb = this.getKnowledgeBase();
                Cls cls = kb.createCls(null, kb.getRootClses());
                kb.createInstance(null, cls);
                return true;
            }
        };
        boolean succeeded = t.execute();
        Transaction_Test.assertTrue((String)"transaction succeeded", (boolean)succeeded);
        Transaction_Test.assertEquals((String)"frame count in cache", (int)(initialFrameCount + 2), (int)this.getFrameCount());
        Transaction_Test.saveAndReload();
        Transaction_Test.assertEquals((String)"frame count in database", (int)(initialFrameCount + 2), (int)this.getFrameCount());
    }

    public void testRollback() {
        String clsName = this.createCls().getName();
        int initialFrameCount = this.getFrameCount();
        Transaction t = new Transaction(this.getDomainKB()){

            public boolean doOperations() {
                KnowledgeBase kb = this.getKnowledgeBase();
                Cls cls = kb.createCls(null, kb.getRootClses());
                kb.createInstance(null, cls);
                return false;
            }
        };
        boolean committed = t.execute();
        Transaction_Test.assertTrue((String)"transaction rolled back", (!committed ? 1 : 0) != 0);
        Transaction_Test.assertEquals((String)"frame count in cache", (int)initialFrameCount, (int)this.getFrameCount());
        Transaction_Test.saveAndReload();
        Transaction_Test.assertEquals((String)"frame count in database", (int)initialFrameCount, (int)this.getFrameCount());
        Cls cls = this.getCls(clsName);
        Transaction_Test.assertNotNull((String)"class", (Object)cls);
        this.createInstance(cls);
    }
}

