/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.DefaultValuesConstraint;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.MinimumCardinalityConstraint;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.NumericMaximumConstraint;
import edu.stanford.smi.protege.model.NumericMinimumConstraint;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SystemFrames {
    private KnowledgeBase _kb;
    private Map _frameIdToFrameMap = new LinkedHashMap();
    private Map _frameIdToNameMap = new LinkedHashMap();

    public SystemFrames(KnowledgeBase knowledgeBase) {
        this._kb = knowledgeBase;
        this.createFrames();
    }

    public void replaceFrame(Frame frame) {
        this._frameIdToFrameMap.put(frame.getFrameID(), frame);
    }

    public Collection getFrames() {
        return new ArrayList(this._frameIdToFrameMap.values());
    }

    public Collection getFrameIDs() {
        return new ArrayList(this._frameIdToFrameMap.keySet());
    }

    public Collection getFrameNames() {
        return new ArrayList(this._frameIdToNameMap.values());
    }

    public synchronized Frame getFrame(FrameID frameID) {
        Frame frame = (Frame)this._frameIdToFrameMap.get(frameID);
        if (frame == null) {
            Log.getLogger().severe("Missing system frame: " + frameID);
        }
        return frame;
    }

    private Cls getCls(FrameID frameID) {
        return (Cls)this.getFrame(frameID);
    }

    private Slot getSlot(FrameID frameID) {
        return (Slot)this.getFrame(frameID);
    }

    private Facet getFacet(FrameID frameID) {
        return (Facet)this.getFrame(frameID);
    }

    private void createFrames() {
        this.createClses();
        this.createSlots();
        this.createFacets();
    }

    private void createCls(FrameID frameID, String string) {
        DefaultCls defaultCls = new DefaultCls(this._kb, frameID);
        this.addFrame(frameID, string, defaultCls);
    }

    private void createSlot(FrameID frameID, String string) {
        DefaultSlot defaultSlot = new DefaultSlot(this._kb, frameID);
        this.addFrame(frameID, string, defaultSlot);
    }

    private void createFacet(FrameID frameID, String string, FacetConstraint facetConstraint) {
        DefaultFacet defaultFacet = new DefaultFacet(this._kb, frameID);
        if (facetConstraint != null) {
            defaultFacet.setConstraint(facetConstraint);
        }
        this.addFrame(frameID, string, defaultFacet);
    }

    private void addFrame(FrameID frameID, String string, Frame frame) {
        Frame frame2 = this._frameIdToFrameMap.put(frameID, frame);
        if (frame2 != null) {
            throw new IllegalStateException("duplicate add: " + frameID + " " + string);
        }
        this._frameIdToNameMap.put(frameID, string);
    }

    private void createClses() {
        this.createCls(Model.ClsID.THING, ":THING");
        this.createCls(Model.ClsID.SYSTEM_CLASS, ":SYSTEM-CLASS");
        this.createCls(Model.ClsID.ROOT_META_CLASS, ":META-CLASS");
        this.createCls(Model.ClsID.CLASS, ":CLASS");
        this.createCls(Model.ClsID.SLOT, ":SLOT");
        this.createCls(Model.ClsID.FACET, ":FACET");
        this.createCls(Model.ClsID.STANDARD_CLASS, ":STANDARD-CLASS");
        this.createCls(Model.ClsID.STANDARD_SLOT, ":STANDARD-SLOT");
        this.createCls(Model.ClsID.STANDARD_FACET, ":STANDARD-FACET");
        this.createCls(Model.ClsID.CONSTRAINT, ":CONSTRAINT");
        this.createCls(Model.ClsID.RELATION, ":RELATION");
        this.createCls(Model.ClsID.DIRECTED_BINARY_RELATION, ":DIRECTED-BINARY-RELATION");
        this.createCls(Model.ClsID.PAL_CONSTRAINT, ":PAL-CONSTRAINT");
        this.createCls(Model.ClsID.ANNOTATION, ":ANNOTATION");
        this.createCls(Model.ClsID.INSTANCE_ANNOTATION, ":INSTANCE-ANNOTATION");
    }

    private void createSlots() {
        this.createSlot(Model.SlotID.DOCUMENTATION, ":DOCUMENTATION");
        this.createSlot(Model.SlotID.NAME, ":NAME");
        this.createSlot(Model.SlotID.ROLE, ":ROLE");
        this.createSlot(Model.SlotID.DIRECT_TYPES, ":DIRECT-TYPE");
        this.createSlot(Model.SlotID.DIRECT_INSTANCES, ":DIRECT-INSTANCES");
        this.createSlot(Model.SlotID.DIRECT_SUPERCLASSES, ":DIRECT-SUPERCLASSES");
        this.createSlot(Model.SlotID.DIRECT_SUBCLASSES, ":DIRECT-SUBCLASSES");
        this.createSlot(Model.SlotID.DIRECT_SUPERSLOTS, ":DIRECT-SUPERSLOTS");
        this.createSlot(Model.SlotID.DIRECT_SUBSLOTS, ":DIRECT-SUBSLOTS");
        this.createSlot(Model.SlotID.ASSOCIATED_FACET, ":ASSOCIATED-FACET");
        this.createSlot(Model.SlotID.ASSOCIATED_SLOT, ":ASSOCIATED-SLOT");
        this.createSlot(Model.SlotID.DIRECT_TEMPLATE_SLOTS, ":DIRECT-TEMPLATE-SLOTS");
        this.createSlot(Model.SlotID.DIRECT_DOMAIN, ":DIRECT-DOMAIN");
        this.createSlot(Model.SlotID.INVERSE, ":SLOT-INVERSE");
        this.createSlot(Model.SlotID.CONSTRAINTS, ":SLOT-CONSTRAINTS");
        this.createSlot(Model.SlotID.DEFAULTS, ":SLOT-DEFAULTS");
        this.createSlot(Model.SlotID.VALUE_TYPE, ":SLOT-VALUE-TYPE");
        this.createSlot(Model.SlotID.MAXIMUM_CARDINALITY, ":SLOT-MAXIMUM-CARDINALITY");
        this.createSlot(Model.SlotID.MINIMUM_CARDINALITY, ":SLOT-MINIMUM-CARDINALITY");
        this.createSlot(Model.SlotID.NUMERIC_MINIMUM, ":SLOT-NUMERIC-MINIMUM");
        this.createSlot(Model.SlotID.NUMERIC_MAXIMUM, ":SLOT-NUMERIC-MAXIMUM");
        this.createSlot(Model.SlotID.PAL_STATEMENT, ":PAL-STATEMENT");
        this.createSlot(Model.SlotID.PAL_DESCRIPTION, ":PAL-DESCRIPTION");
        this.createSlot(Model.SlotID.PAL_NAME, ":PAL-NAME");
        this.createSlot(Model.SlotID.PAL_RANGE, ":PAL-RANGE");
        this.createSlot(Model.SlotID.VALUES, ":SLOT-VALUES");
        this.createSlot(Model.SlotID.ANNOTATED_INSTANCE, ":ANNOTATED-INSTANCE");
        this.createSlot(Model.SlotID.ANNOTATION_TEXT, ":ANNOTATION-TEXT");
        this.createSlot(Model.SlotID.CREATOR, ":CREATOR");
        this.createSlot(Model.SlotID.CREATION_TIMESTAMP, ":CREATION-TIMESTAMP");
        this.createSlot(Model.SlotID.MODIFIER, ":MODIFIER");
        this.createSlot(Model.SlotID.MODIFICATION_TIMESTAMP, ":MODIFICATION-TIMESTAMP");
        this.createSlot(Model.SlotID.FROM, ":FROM");
        this.createSlot(Model.SlotID.TO, ":TO");
    }

    private void createFacets() {
        this.createFacet(Model.FacetID.DOCUMENTATION, ":DOCUMENTATION-IN-FRAME", null);
        this.createFacet(Model.FacetID.DEFAULTS, ":DEFAULTS", new DefaultValuesConstraint());
        this.createFacet(Model.FacetID.CONSTRAINTS, ":CONSTRAINTS", null);
        this.createFacet(Model.FacetID.VALUE_TYPE, ":VALUE-TYPE", new ValueTypeConstraint());
        this.createFacet(Model.FacetID.INVERSE, ":INVERSE", null);
        this.createFacet(Model.FacetID.MAXIMUM_CARDINALITY, ":MAXIMUM-CARDINALITY", new MaximumCardinalityConstraint());
        this.createFacet(Model.FacetID.MINIMUM_CARDINALITY, ":MINIMUM-CARDINALITY", new MinimumCardinalityConstraint());
        this.createFacet(Model.FacetID.NUMERIC_MINIMUM, ":NUMERIC-MINIMUM", new NumericMinimumConstraint());
        this.createFacet(Model.FacetID.NUMERIC_MAXIMUM, ":NUMERIC-MAXIMUM", new NumericMaximumConstraint());
        this.createFacet(Model.FacetID.VALUES, ":VALUES", null);
    }

    public Cls getRootCls() {
        return this.getCls(Model.ClsID.THING);
    }

    public Cls getRootMetaCls() {
        return this.getCls(Model.ClsID.ROOT_META_CLASS);
    }

    public Cls getRootClsMetaCls() {
        return this.getCls(Model.ClsID.CLASS);
    }

    public Cls getStandardClsMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_CLASS);
    }

    public Cls getStandardSlotMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_SLOT);
    }

    public Cls getRootSlotMetaCls() {
        return this.getCls(Model.ClsID.SLOT);
    }

    public Cls getRootFacetMetaCls() {
        return this.getCls(Model.ClsID.FACET);
    }

    public Cls getStandardFacetMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_FACET);
    }

    public Cls getSystemCls() {
        return this.getCls(Model.ClsID.SYSTEM_CLASS);
    }

    public Cls getConstraintCls() {
        return this.getCls(Model.ClsID.CONSTRAINT);
    }

    public Cls getRelationCls() {
        return this.getCls(Model.ClsID.RELATION);
    }

    public Cls getDirectedBinaryRelationCls() {
        return this.getCls(Model.ClsID.DIRECTED_BINARY_RELATION);
    }

    public Cls getPalConstraintCls() {
        return this.getCls(Model.ClsID.PAL_CONSTRAINT);
    }

    public Cls getAnnotationCls() {
        return this.getCls(Model.ClsID.ANNOTATION);
    }

    public Cls getInstanceAnnotationCls() {
        return this.getCls(Model.ClsID.INSTANCE_ANNOTATION);
    }

    public Slot getDocumentationSlot() {
        return this.getSlot(Model.SlotID.DOCUMENTATION);
    }

    public Slot getDirectDomainSlot() {
        return this.getSlot(Model.SlotID.DIRECT_DOMAIN);
    }

    public Slot getNameSlot() {
        return this.getSlot(Model.SlotID.NAME);
    }

    public Slot getRoleSlot() {
        return this.getSlot(Model.SlotID.ROLE);
    }

    public Slot getDirectSuperclassesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUPERCLASSES);
    }

    public Slot getDirectSubclassesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUBCLASSES);
    }

    public Slot getDirectTypesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_TYPES);
    }

    public Slot getDirectInstancesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_INSTANCES);
    }

    public Slot getDirectTemplateSlotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_TEMPLATE_SLOTS);
    }

    public Slot getAssociatedFacetSlot() {
        return this.getSlot(Model.SlotID.ASSOCIATED_FACET);
    }

    public Slot getSlotConstraintsSlot() {
        return this.getSlot(Model.SlotID.CONSTRAINTS);
    }

    public Slot getDefaultValuesSlot() {
        return this.getSlot(Model.SlotID.DEFAULTS);
    }

    public Slot getValueTypeSlot() {
        return this.getSlot(Model.SlotID.VALUE_TYPE);
    }

    public Slot getInverseSlotSlot() {
        return this.getSlot(Model.SlotID.INVERSE);
    }

    public Slot getMaximumCardinalitySlot() {
        return this.getSlot(Model.SlotID.MAXIMUM_CARDINALITY);
    }

    public Slot getMinimumCardinalitySlot() {
        return this.getSlot(Model.SlotID.MINIMUM_CARDINALITY);
    }

    public Slot getMinimumValueSlot() {
        return this.getSlot(Model.SlotID.NUMERIC_MINIMUM);
    }

    public Slot getMaximumValueSlot() {
        return this.getSlot(Model.SlotID.NUMERIC_MAXIMUM);
    }

    public Slot getPalStatementSlot() {
        return this.getSlot(Model.SlotID.PAL_STATEMENT);
    }

    public Slot getPalNameSlot() {
        return this.getSlot(Model.SlotID.PAL_NAME);
    }

    public Slot getPalDescriptionSlot() {
        return this.getSlot(Model.SlotID.PAL_DESCRIPTION);
    }

    public Slot getPalRangeSlot() {
        return this.getSlot(Model.SlotID.PAL_RANGE);
    }

    public Slot getValuesSlot() {
        return this.getSlot(Model.SlotID.VALUES);
    }

    public Slot getDirectSubslotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUBSLOTS);
    }

    public Slot getDirectSuperslotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUPERSLOTS);
    }

    public Slot getAnnotatedInstanceSlot() {
        return this.getSlot(Model.SlotID.ANNOTATED_INSTANCE);
    }

    public Slot getAnnotationTextSlot() {
        return this.getSlot(Model.SlotID.ANNOTATION_TEXT);
    }

    public Slot getCreatorSlot() {
        return this.getSlot(Model.SlotID.CREATOR);
    }

    public Slot getCreationTimestampSlot() {
        return this.getSlot(Model.SlotID.CREATION_TIMESTAMP);
    }

    public Slot getAssociatedSlotSlot() {
        return this.getSlot(Model.SlotID.ASSOCIATED_SLOT);
    }

    public Slot getModifierSlot() {
        return this.getSlot(Model.SlotID.MODIFIER);
    }

    public Slot getModificationTimestampSlot() {
        return this.getSlot(Model.SlotID.MODIFICATION_TIMESTAMP);
    }

    public Slot getConstraintsSlot() {
        return this.getSlot(Model.SlotID.CONSTRAINTS);
    }

    public Slot getFromSlot() {
        return this.getSlot(Model.SlotID.FROM);
    }

    public Slot getToSlot() {
        return this.getSlot(Model.SlotID.TO);
    }

    public Facet getDocumentationFacet() {
        return this.getFacet(Model.FacetID.DOCUMENTATION);
    }

    public Facet getDefaultValuesFacet() {
        return this.getFacet(Model.FacetID.DEFAULTS);
    }

    public Facet getConstraintsFacet() {
        return this.getFacet(Model.FacetID.CONSTRAINTS);
    }

    public Facet getValueTypeFacet() {
        return this.getFacet(Model.FacetID.VALUE_TYPE);
    }

    public Facet getInverseFacet() {
        return this.getFacet(Model.FacetID.INVERSE);
    }

    public Facet getMaximumCardinalityFacet() {
        return this.getFacet(Model.FacetID.MAXIMUM_CARDINALITY);
    }

    public Facet getMinimumCardinalityFacet() {
        return this.getFacet(Model.FacetID.MINIMUM_CARDINALITY);
    }

    public Facet getMinimumValueFacet() {
        return this.getFacet(Model.FacetID.NUMERIC_MINIMUM);
    }

    public Facet getMaximumValueFacet() {
        return this.getFacet(Model.FacetID.NUMERIC_MAXIMUM);
    }

    public Facet getValuesFacet() {
        return this.getFacet(Model.FacetID.VALUES);
    }

    public void addSystemFrames(FrameStore frameStore) {
        try {
            this.addFrames(frameStore);
            this.addInheritance(frameStore);
            this.addTemplateSlots(frameStore);
            this.addInverseSlots(frameStore);
            this.configureClses(frameStore);
            this.configureSlots(frameStore);
            this.configureFacets(frameStore);
            this.configureOverrides(frameStore);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            throw new RuntimeException(exception.toString());
        }
    }

    private Cls addSystemCls(FrameStore frameStore, FrameID frameID, String string) {
        Collection collection = CollectionUtilities.createCollection(this.getStandardClsMetaCls());
        return frameStore.createCls(frameID, string, collection, Collections.EMPTY_SET, false);
    }

    private void addSystemSlot(FrameStore frameStore, FrameID frameID, String string) {
        Collection collection = CollectionUtilities.createCollection(this.getStandardSlotMetaCls());
        frameStore.createSlot(frameID, string, collection, Collections.EMPTY_SET, false);
    }

    private void addSystemFacet(FrameStore frameStore, FrameID frameID, String string, FacetConstraint facetConstraint) {
        Collection collection = CollectionUtilities.createCollection(this.getStandardFacetMetaCls());
        Facet facet = frameStore.createFacet(frameID, string, collection, false);
        if (facetConstraint != null) {
            facet.setConstraint(facetConstraint);
        }
    }

    private void addInverseSlot(FrameStore frameStore, Slot slot, Slot slot2) {
        SystemFrames.setOwnSlotValue(frameStore, slot, this.getInverseSlotSlot(), slot2);
    }

    private static void addTemplateSlot(FrameStore frameStore, Cls cls, Slot slot) {
        frameStore.addDirectTemplateSlot(cls, slot);
    }

    private static void addSuperclass(FrameStore frameStore, Cls cls, Cls cls2) {
        frameStore.addDirectSuperclass(cls, cls2);
    }

    private void addFrames(FrameStore frameStore) {
        for (Map.Entry entry : this._frameIdToFrameMap.entrySet()) {
            FrameID frameID = (FrameID)entry.getKey();
            Frame frame = (Frame)entry.getValue();
            String string = (String)this._frameIdToNameMap.get(frameID);
            if (frame instanceof Cls) {
                this.addSystemCls(frameStore, frameID, string);
                continue;
            }
            if (frame instanceof Slot) {
                this.addSystemSlot(frameStore, frameID, string);
                continue;
            }
            if (!(frame instanceof Facet)) continue;
            this.addSystemFacet(frameStore, frameID, string, ((Facet)frame).getConstraint());
        }
    }

    private void addInheritance(FrameStore frameStore) {
        SystemFrames.addSuperclass(frameStore, this.getSystemCls(), this.getRootCls());
        SystemFrames.addSuperclass(frameStore, this.getRootMetaCls(), this.getSystemCls());
        SystemFrames.addSuperclass(frameStore, this.getRootClsMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getStandardClsMetaCls(), this.getRootClsMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getRootSlotMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getStandardSlotMetaCls(), this.getRootSlotMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getRootFacetMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getStandardFacetMetaCls(), this.getRootFacetMetaCls());
        SystemFrames.addSuperclass(frameStore, this.getConstraintCls(), this.getSystemCls());
        SystemFrames.addSuperclass(frameStore, this.getPalConstraintCls(), this.getConstraintCls());
        SystemFrames.addSuperclass(frameStore, this.getAnnotationCls(), this.getSystemCls());
        SystemFrames.addSuperclass(frameStore, this.getInstanceAnnotationCls(), this.getAnnotationCls());
        SystemFrames.addSuperclass(frameStore, this.getRelationCls(), this.getSystemCls());
        SystemFrames.addSuperclass(frameStore, this.getDirectedBinaryRelationCls(), this.getRelationCls());
    }

    private void addTemplateSlots(FrameStore frameStore) {
        this.addRootMetaClsTemplateSlots(frameStore);
        this.addRootClsMetaClsTemplateSlots(frameStore);
        this.addStandardClsMetaClsTemplateSlots(frameStore);
        this.addRootSlotMetaClsTemplateSlots(frameStore);
        this.addStandardSlotMetaClsTemplateSlots(frameStore);
        this.addRootFacetMetaClsTemplateSlots(frameStore);
        this.addStandardFacetMetaClsTemplateSlots(frameStore);
        this.addPalConstraintTemplateSlots(frameStore);
        this.addInstanceAnnotationTemplateSlots(frameStore);
        this.addDirectedBinaryRelationTemplateSlots(frameStore);
    }

    private void addRootMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getRootMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getNameSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectTypesSlot());
    }

    private void addRootClsMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getRootClsMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectInstancesSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectSuperclassesSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectSubclassesSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectTemplateSlotsSlot());
    }

    private void addStandardClsMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getStandardClsMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getRoleSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getConstraintsSlot());
    }

    private void addRootSlotMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getRootSlotMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectDomainSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getValueTypeSlot());
    }

    private void addStandardSlotMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getStandardSlotMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getConstraintsSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getMaximumCardinalitySlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getMinimumCardinalitySlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getMaximumValueSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getMinimumValueSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getInverseSlotSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDefaultValuesSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getValuesSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getAssociatedFacetSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectSubslotsSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDirectSuperslotsSlot());
    }

    private void addRootFacetMetaClsTemplateSlots(FrameStore frameStore) {
    }

    private void addStandardFacetMetaClsTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getStandardFacetMetaCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getAssociatedSlotSlot());
    }

    private void addPalConstraintTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getPalConstraintCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getPalNameSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getPalRangeSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getPalDescriptionSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getPalStatementSlot());
    }

    private void addInstanceAnnotationTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getInstanceAnnotationCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getAnnotatedInstanceSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getAnnotationTextSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getCreatorSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getCreationTimestampSlot());
    }

    private void addDirectedBinaryRelationTemplateSlots(FrameStore frameStore) {
        Cls cls = this.getDirectedBinaryRelationCls();
        SystemFrames.addTemplateSlot(frameStore, cls, this.getFromSlot());
        SystemFrames.addTemplateSlot(frameStore, cls, this.getToSlot());
    }

    private void addInverseSlots(FrameStore frameStore) {
        this.addInverseSlot(frameStore, this.getInverseSlotSlot(), this.getInverseSlotSlot());
        this.addInverseSlot(frameStore, this.getAssociatedFacetSlot(), this.getAssociatedSlotSlot());
        this.addInverseSlot(frameStore, this.getDirectTemplateSlotsSlot(), this.getDirectDomainSlot());
        this.addInverseSlot(frameStore, this.getDirectSuperclassesSlot(), this.getDirectSubclassesSlot());
        this.addInverseSlot(frameStore, this.getDirectTypesSlot(), this.getDirectInstancesSlot());
        this.addInverseSlot(frameStore, this.getDirectSuperslotsSlot(), this.getDirectSubslotsSlot());
    }

    private void configureClses(FrameStore frameStore) {
        this.configureCls(frameStore, this.getRootCls(), "Abstract");
        this.configureCls(frameStore, this.getSystemCls(), "Abstract");
        this.configureCls(frameStore, this.getRootMetaCls(), "Abstract");
        this.configureCls(frameStore, this.getRootClsMetaCls(), "Abstract");
        this.configureCls(frameStore, this.getStandardClsMetaCls(), "Concrete");
        this.configureCls(frameStore, this.getRootSlotMetaCls(), "Abstract");
        this.configureCls(frameStore, this.getStandardSlotMetaCls(), "Concrete");
        this.configureCls(frameStore, this.getRootFacetMetaCls(), "Abstract");
        this.configureCls(frameStore, this.getStandardFacetMetaCls(), "Concrete");
        this.configureCls(frameStore, this.getConstraintCls(), "Abstract");
        this.configureCls(frameStore, this.getPalConstraintCls(), "Concrete");
        this.configureCls(frameStore, this.getAnnotationCls(), "Abstract");
        this.configureCls(frameStore, this.getInstanceAnnotationCls(), "Concrete");
        this.configureCls(frameStore, this.getRelationCls(), "Abstract");
        this.configureCls(frameStore, this.getDirectedBinaryRelationCls(), "Concrete");
    }

    private void configureCls(FrameStore frameStore, Cls cls, String string) {
        SystemFrames.setOwnSlotValue(frameStore, cls, this.getRoleSlot(), string);
    }

    private void configureSlots(FrameStore frameStore) {
        this.configureMultiStringSlot(frameStore, this.getDocumentationSlot());
        this.configureSingleStringSlot(frameStore, this.getNameSlot());
        this.configureSingleSymbolSlot(frameStore, this.getRoleSlot(), RoleConstraint.getValues());
        this.configureMultiClassSlot(frameStore, this.getDirectTypesSlot(), this.getRootCls());
        this.configureMultiInstanceSlot(frameStore, this.getDirectInstancesSlot(), this.getRootCls());
        this.configureMultiClassSlot(frameStore, this.getDirectSuperclassesSlot(), this.getRootCls());
        this.configureMultiClassSlot(frameStore, this.getDirectSubclassesSlot(), this.getRootCls());
        this.configureMultiInstanceSlot(frameStore, this.getDirectSuperslotsSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(frameStore, this.getDirectSubslotsSlot(), this.getRootSlotMetaCls());
        this.configureSingleInstanceSlot(frameStore, this.getAssociatedFacetSlot(), this.getRootFacetMetaCls());
        this.configureSingleInstanceSlot(frameStore, this.getAssociatedSlotSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(frameStore, this.getDirectTemplateSlotsSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(frameStore, this.getDirectDomainSlot(), this.getRootClsMetaCls());
        this.configureSingleInstanceSlot(frameStore, this.getInverseSlotSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(frameStore, this.getConstraintsSlot(), this.getConstraintCls());
        this.configureMultiAnySlot(frameStore, this.getDefaultValuesSlot());
        this.configureMultiAnySlot(frameStore, this.getValueTypeSlot());
        this.configureSingleIntSlot(frameStore, this.getMaximumCardinalitySlot());
        this.configureSingleIntSlot(frameStore, this.getMinimumCardinalitySlot());
        this.configureSingleFloatSlot(frameStore, this.getMinimumValueSlot());
        this.configureSingleFloatSlot(frameStore, this.getMaximumValueSlot());
        this.configureSingleStringSlot(frameStore, this.getPalStatementSlot());
        this.configureSingleStringSlot(frameStore, this.getPalDescriptionSlot());
        this.configureSingleStringSlot(frameStore, this.getPalNameSlot());
        this.configureSingleStringSlot(frameStore, this.getPalRangeSlot());
        this.configureMultiAnySlot(frameStore, this.getValuesSlot());
        this.configureSingleInstanceSlot(frameStore, this.getAnnotatedInstanceSlot(), this.getRootCls());
        this.configureSingleStringSlot(frameStore, this.getAnnotationTextSlot());
        this.configureSingleStringSlot(frameStore, this.getCreatorSlot());
        this.configureSingleStringSlot(frameStore, this.getCreationTimestampSlot());
        this.configureSingleStringSlot(frameStore, this.getModifierSlot());
        this.configureSingleStringSlot(frameStore, this.getModificationTimestampSlot());
        this.configureSingleInstanceSlot(frameStore, this.getFromSlot(), this.getRootCls());
        this.configureSingleInstanceSlot(frameStore, this.getToSlot(), this.getRootCls());
        this.setDefault(frameStore, this.getMaximumCardinalitySlot(), new Integer(1));
        this.setDefault(frameStore, this.getValueTypeSlot(), ValueType.STRING.toString());
        this.setDefault(frameStore, this.getRoleSlot(), "Concrete".toString());
    }

    private void configureOverrides(FrameStore frameStore) {
        this.setAllowedParent(frameStore, this.getRootMetaCls(), this.getDirectTypesSlot(), this.getRootMetaCls());
        this.setAllowedParent(frameStore, this.getRootClsMetaCls(), this.getDirectTypesSlot(), this.getRootClsMetaCls());
        this.setAllowedParent(frameStore, this.getRootSlotMetaCls(), this.getDirectTypesSlot(), this.getRootSlotMetaCls());
        this.setAllowedParent(frameStore, this.getRootFacetMetaCls(), this.getDirectTypesSlot(), this.getRootFacetMetaCls());
    }

    private void setAllowedParent(FrameStore frameStore, Cls cls, Slot slot, Cls cls2) {
        List list = ValueTypeConstraint.getValues(ValueType.CLS, Collections.singleton(cls2));
        frameStore.setDirectTemplateFacetValues(cls, slot, this.getValueTypeFacet(), list);
    }

    private void configureFacets(FrameStore frameStore) {
        this.configureFacet(frameStore, this.getDocumentationFacet(), this.getDocumentationSlot());
        this.configureFacet(frameStore, this.getDefaultValuesFacet(), this.getDefaultValuesSlot());
        this.configureFacet(frameStore, this.getConstraintsFacet(), this.getConstraintsSlot());
        this.configureFacet(frameStore, this.getValueTypeFacet(), this.getValueTypeSlot());
        this.configureFacet(frameStore, this.getMaximumCardinalityFacet(), this.getMaximumCardinalitySlot());
        this.configureFacet(frameStore, this.getMinimumCardinalityFacet(), this.getMinimumCardinalitySlot());
        this.configureFacet(frameStore, this.getMaximumValueFacet(), this.getMaximumValueSlot());
        this.configureFacet(frameStore, this.getMinimumValueFacet(), this.getMinimumValueSlot());
        this.configureFacet(frameStore, this.getValuesFacet(), this.getValuesSlot());
    }

    private void setDefault(FrameStore frameStore, Slot slot, Object object) {
        SystemFrames.setOwnSlotValue(frameStore, slot, this.getDefaultValuesSlot(), object);
    }

    private void setCardinality(FrameStore frameStore, Slot slot, boolean bl) {
        Collection collection = MaximumCardinalityConstraint.getValues(bl);
        SystemFrames.setOwnSlotValues(frameStore, slot, this.getMaximumCardinalitySlot(), collection);
    }

    private void setValueType(FrameStore frameStore, Slot slot, ValueType valueType) {
        this.setValueType(frameStore, slot, valueType, Collections.EMPTY_LIST);
    }

    private void setValueType(FrameStore frameStore, Slot slot, ValueType valueType, Collection collection) {
        List list = ValueTypeConstraint.getValues(valueType, collection);
        SystemFrames.setOwnSlotValues(frameStore, slot, this.getValueTypeSlot(), list);
    }

    private void configureMultiStringSlot(FrameStore frameStore, Slot slot) {
        this.setCardinality(frameStore, slot, true);
        this.setValueType(frameStore, slot, ValueType.STRING);
    }

    private void configureSingleStringSlot(FrameStore frameStore, Slot slot) {
        this.setCardinality(frameStore, slot, false);
        this.setValueType(frameStore, slot, ValueType.STRING);
    }

    private void configureSingleSymbolSlot(FrameStore frameStore, Slot slot, Collection collection) {
        this.setCardinality(frameStore, slot, false);
        this.setValueType(frameStore, slot, ValueType.SYMBOL, collection);
    }

    private void configureMultiInstanceSlot(FrameStore frameStore, Slot slot, Cls cls) {
        this.setCardinality(frameStore, slot, true);
        this.setValueType(frameStore, slot, ValueType.INSTANCE, CollectionUtilities.createCollection(cls));
    }

    private void configureMultiClassSlot(FrameStore frameStore, Slot slot, Cls cls) {
        this.setCardinality(frameStore, slot, true);
        this.setValueType(frameStore, slot, ValueType.CLS, CollectionUtilities.createCollection(cls));
    }

    private void configureSingleInstanceSlot(FrameStore frameStore, Slot slot, Cls cls) {
        this.setCardinality(frameStore, slot, false);
        this.setValueType(frameStore, slot, ValueType.INSTANCE, CollectionUtilities.createCollection(cls));
    }

    private void configureSingleIntSlot(FrameStore frameStore, Slot slot) {
        this.setCardinality(frameStore, slot, false);
        this.setValueType(frameStore, slot, ValueType.INTEGER);
    }

    private void configureSingleFloatSlot(FrameStore frameStore, Slot slot) {
        this.setCardinality(frameStore, slot, false);
        this.setValueType(frameStore, slot, ValueType.FLOAT);
    }

    private void configureMultiAnySlot(FrameStore frameStore, Slot slot) {
        this.setCardinality(frameStore, slot, true);
        this.setValueType(frameStore, slot, ValueType.ANY);
    }

    private static void setOwnSlotValue(FrameStore frameStore, Frame frame, Slot slot, Object object) {
        Set<Object> set = Collections.singleton(object);
        SystemFrames.setOwnSlotValues(frameStore, frame, slot, set);
    }

    private static void setOwnSlotValues(FrameStore frameStore, Frame frame, Slot slot, Collection collection) {
        frameStore.setDirectOwnSlotValues(frame, slot, collection);
    }

    private void configureFacet(FrameStore frameStore, Facet facet, Slot slot) {
        SystemFrames.setOwnSlotValue(frameStore, facet, this.getAssociatedSlotSlot(), slot);
    }
}

