/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.PropertyMapUtil;
import edu.stanford.smi.protege.test.APITestCase;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapUtil_Test
extends APITestCase {
    protected Instance _mapInstance;

    public void setUp() throws Exception {
        super.setUp();
        KnowledgeBase projectKB = this.getProject().getSources().getWrappedInstance().getKnowledgeBase();
        Cls mapCls = projectKB.getCls("Map");
        this._mapInstance = projectKB.createInstance(null, mapCls);
    }

    public void testClassObject() {
        Map map = new HashMap<Object, Object>();
        map.put("foo", PropertyMapUtil_Test.class);
        map.put(PropertyMapUtil.class, "bar");
        map.put(Project.class, Model.class);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertSame((String)"string to class", PropertyMapUtil_Test.class, map.get("foo"));
        PropertyMapUtil_Test.assertEquals((String)"class to string", (Object)"bar", map.get(PropertyMapUtil.class));
        PropertyMapUtil_Test.assertSame((String)"class to class", Model.class, map.get(Project.class));
    }

    public void testFrame() {
        Frame frame1 = this.createFrame();
        Frame frame2 = this.createFrame();
        Frame frame3 = this.createFrame();
        Frame frame4 = this.createFrame();
        Map map = new HashMap<Object, Object>();
        map.put(frame1, "foo");
        map.put("bar", frame2);
        map.put(frame3, frame4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertSame((String)"frame to frame", (Object)frame4, map.get(frame3));
        PropertyMapUtil_Test.assertEquals((String)"string to frame", (Object)"foo", map.get(frame1));
        PropertyMapUtil_Test.assertSame((String)"frame to string", (Object)frame2, map.get("bar"));
    }

    public void testInteger() {
        Map map = new HashMap<Object, Object>();
        map.put(new Integer(1), "foo1");
        map.put("foo2", new Integer(2));
        map.put(new Integer(3), new Integer(4));
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"int to string", (Object)"foo1", map.get(new Integer(1)));
        PropertyMapUtil_Test.assertEquals((String)"string to int", (Object)new Integer(2), map.get("foo2"));
        PropertyMapUtil_Test.assertEquals((String)"int to int", (Object)new Integer(4), map.get(new Integer(3)));
    }

    public void testJavaClass() {
        TestClass o1 = new TestClass("a");
        TestClass o2 = new TestClass("b");
        TestClass o3 = new TestClass("c");
        TestClass o4 = new TestClass("d");
        Map map = new HashMap<Object, Object>();
        map.put(o1, "foo");
        map.put("bar", o2);
        map.put(o3, o4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"object to string", (Object)"foo", map.get(o1));
        PropertyMapUtil_Test.assertEquals((String)"string to object", (Object)o2, map.get("bar"));
        PropertyMapUtil_Test.assertEquals((String)"object to object", (Object)o4, map.get(o3));
    }

    public void testMap() {
        Map map = new HashMap();
        Map subMap1 = new HashMap<String, String>();
        subMap1.put("foo", "bar");
        map.put("submap1", subMap1);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        subMap1 = (Map)map.get("submap1");
        PropertyMapUtil_Test.assertNotNull((String)"submap", subMap1);
        PropertyMapUtil_Test.assertEquals((Object)"bar", subMap1.get("foo"));
    }

    public void testRectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(5, 6, 7, 8);
        Rectangle r3 = new Rectangle(10, 20, 30, 40);
        Rectangle r4 = new Rectangle(50, 60, 70, 80);
        Map map = new HashMap<Object, Object>();
        map.put(r1, "foo1");
        map.put("foo2", r2);
        map.put(r3, r4);
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"rect to string", (Object)"foo1", map.get(r1));
        PropertyMapUtil_Test.assertEquals((String)"string to rect", (Object)r2, map.get("foo2"));
        PropertyMapUtil_Test.assertEquals((String)"rect to rect", (Object)r4, map.get(r3));
    }

    public void testString() {
        Map map = new HashMap<String, String>();
        map.put("foo", "bar");
        PropertyMapUtil.store(map, this._mapInstance);
        map = PropertyMapUtil.load(this._mapInstance, this.getDomainKB());
        PropertyMapUtil_Test.assertEquals((String)"string to string", (Object)"bar", map.get("foo"));
    }

    public static class TestClass {
        String _value;

        public TestClass(String s) {
            this._value = s;
        }

        public String toString() {
            return this._value;
        }

        public boolean equals(Object o) {
            TestClass tco = (TestClass)o;
            return this._value.equals(tco._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }
    }
}

