/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.HashUtils;
import java.io.Serializable;

public class FrameID
implements Serializable {
    public static final int NULL_FRAME_ID_VALUE = 0;
    public static final int NULL_FRAME_ID_LOCAL_VALUE = 0;
    public static final int INITIAL_USER_FRAME_ID = 10000;
    public static final int SYSTEM_PROJECT_ID = 0;
    public static final int LOCAL_PROJECT_ID = 1;
    public static final int NULL_FRAME_ID_PROJECT_VALUE = 0;
    private int localPart;
    private int diskProjectPart;
    private int memoryProjectPart;
    private int hashCode;
    private static int lastMemoryProjectPart = 1;

    public static synchronized int allocateMemoryProjectPart() {
        return ++lastMemoryProjectPart;
    }

    public FrameID() {
    }

    public static FrameID createSystem(int n) {
        assert (0 < n && n < 10000);
        return FrameID.create(0, 0, n);
    }

    public static FrameID createLocal(int n, int n2) {
        assert (10000 <= n2);
        return FrameID.create(1, n, n2);
    }

    public static FrameID createLocal(int n) {
        Assert.assertTrue("value=" + n, 10000 <= n);
        return FrameID.create(1, 1, n);
    }

    public static FrameID create(int n, int n2, int n3) {
        return n3 == 0 ? null : new FrameID(n, n2, n3);
    }

    public static String toStringRepresentation(FrameID frameID) {
        String string = frameID == null ? FrameID.toStringRepresentation(0, 0) : frameID.toStringRepresentation();
        return string;
    }

    public String toStringRepresentation() {
        return FrameID.toStringRepresentation(this.diskProjectPart, this.localPart);
    }

    private static String toStringRepresentation(int n, int n2) {
        return n + ":" + n2;
    }

    public static FrameID fromStringRepresentation(int n, String string) {
        int n2 = string.indexOf(":");
        int n3 = Integer.parseInt(string.substring(0, n2));
        int n4 = Integer.parseInt(string.substring(n2 + 1));
        return FrameID.create(n3, n, n4);
    }

    private FrameID(int n, int n2, int n3) {
        this.diskProjectPart = n;
        this.memoryProjectPart = n2;
        this.localPart = n3;
        this.cacheHashCode();
    }

    private void cacheHashCode() {
        this.hashCode = HashUtils.getHash(this.memoryProjectPart, this.localPart);
    }

    public boolean isSystem() {
        return this.memoryProjectPart == 0;
    }

    public int getLocalPart() {
        return this.localPart;
    }

    public int getMemoryProjectPart() {
        return this.memoryProjectPart;
    }

    public int getDiskProjectPart() {
        return this.memoryProjectPart;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof FrameID) {
            FrameID frameID = (FrameID)object;
            bl = this.memoryProjectPart == frameID.memoryProjectPart && this.localPart == frameID.localPart;
        }
        return bl;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public boolean isUser() {
        return !this.isSystem();
    }

    public String toString() {
        return "FrameID(" + this.memoryProjectPart + ":" + this.localPart + " " + this.diskProjectPart + ")";
    }
}

