/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceAdapter;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotAdapter;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.ui.FrameNameComparator;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public class DefaultKnowledgeBase_Test
extends APITestCase {
    public void testFilteredInverseSlotValueNotifications() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Slot slotInverse = this.createSlotOnCls(cls);
        slot.setInverseSlot(slotInverse);
        slot.setAllowedClses(this.getDomainKB().getRootClses());
        Instance instance1 = this.createInstance(cls);
        Instance instance2 = this.createInstance(cls);
        Instance instance3 = this.createInstance(cls);
        Instance instance4 = this.createInstance(cls);
        instance1.setOwnSlotValues(slot, DefaultKnowledgeBase_Test.makeList(instance2, instance3));
        final Integer[] counter = new Integer[]{new Integer(0)};
        FrameAdapter listener = new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent event) {
                counter[0] = new Integer(counter[0] + 1);
            }
        };
        this.getDomainKB().addFrameListener(listener);
        instance1.addOwnSlotValue(slot, instance4);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)counter[0]);
    }

    public void testGetOwnSlotValuesWithSubslotInCoreProtege() {
        Slot hasMemberSlot = this.createSlot();
        Slot hasLeaderSlot = this.createSlot();
        hasLeaderSlot.addDirectSuperslot(hasMemberSlot);
        Instance person = this.getDomainKB().getRootCls().createDirectInstance("Person");
        Instance team = this.getDomainKB().getRootCls().createDirectInstance("Team");
        team.addOwnSlotValue(hasLeaderSlot, person);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)team.getOwnSlotValues(hasMemberSlot).size());
        team.addOwnSlotValue(hasMemberSlot, person);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)team.getDirectOwnSlotValues(hasMemberSlot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)team.getDirectOwnSlotValues(hasLeaderSlot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)team.getOwnSlotValues(hasMemberSlot).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)team.getOwnSlotValues(hasLeaderSlot).size());
    }

    public void testInferredInverseSlotValues() {
        Cls cls1 = this.createCls();
        Slot slot1 = this.createSlotOnCls(cls1);
        Cls cls2 = this.createCls();
        Slot slot2 = this.createSlotOnCls(cls2);
        Instance instance2 = this.createInstance(cls2);
        slot2.setInverseSlot(slot1);
        slot1.setAllowedClses(DefaultKnowledgeBase_Test.makeList(cls2));
        cls1.setTemplateSlotValues(slot1, DefaultKnowledgeBase_Test.makeList(instance2));
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(), instance2.getOwnSlotValues(slot2));
        Instance instance1 = this.createInstance(cls1);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(instance1), instance2.getOwnSlotValues(slot2));
    }

    public void testAddDirectTypeSave() {
        Cls cls1 = this.createCls();
        String cls1Name = cls1.getName();
        Cls cls2 = this.createCls();
        String cls2Name = cls2.getName();
        Instance instance = this.createInstance(cls1);
        String instanceName = instance.getName();
        instance.addDirectType(cls2);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls1, cls2), instance.getDirectTypes());
        DefaultKnowledgeBase_Test.saveAndReload();
        cls1 = this.getCls(cls1Name);
        cls2 = this.getCls(cls2Name);
        instance = this.getInstance(instanceName);
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls1, cls2), instance.getDirectTypes());
    }

    public void testGetValueTypeByOwnSlotValue() {
        Slot slot = this.createSlot();
        ValueType type = slot.getValueType();
        DefaultKnowledgeBase_Test.assertEquals((Object)type, (Object)ValueType.STRING);
        Slot valueTypeSlot = this.getSlot(":SLOT-VALUE-TYPE");
        slot.setDirectOwnSlotValues(valueTypeSlot, Collections.EMPTY_LIST);
        List values = slot.getDirectOwnSlotValues(valueTypeSlot);
        DefaultKnowledgeBase_Test.assertEqualsList(values, Collections.EMPTY_LIST);
    }

    public void testDeleteFromCache() {
        KnowledgeBase kb = this.getDomainKB();
        Cls cls = null;
        String name = "foo";
        Instance instance = kb.createInstance(name, cls);
        String instanceName = instance.getName();
        instance = kb.getInstance(instanceName);
        instance.delete();
        Instance instance2 = this.createInstance(instanceName, cls);
        instance2 = this.getInstance(instanceName);
        DefaultKnowledgeBase_Test.assertEquals((String)name, (String)instance2.getName());
    }

    public void testOwnSlotValueChangedEventOnInverseSlot() {
        final int[] eventCount = new int[1];
        Slot slotA = this.createSlot();
        slotA.setValueType(ValueType.INSTANCE);
        Slot slotB = this.createSlot();
        slotB.setValueType(ValueType.INSTANCE);
        slotA.setInverseSlot(slotB);
        Cls clsA = this.createCls();
        Cls clsB = this.createCls();
        clsA.addDirectTemplateSlot(slotA);
        clsB.addDirectTemplateSlot(slotB);
        Instance a = clsA.createDirectInstance(null);
        Instance b = clsB.createDirectInstance(null);
        a.setDirectOwnSlotValue(slotA, b);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)a.getDirectOwnSlotValues(slotA).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)b.getDirectOwnSlotValues(slotB).size());
        this.getDomainKB().addFrameListener(new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent event) {
                eventCount[0] = eventCount[0] + 1;
            }
        });
        a.setDirectOwnSlotValue(slotA, null);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)a.getDirectOwnSlotValues(slotA).size());
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)b.getDirectOwnSlotValues(slotB).size());
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)eventCount[0]);
    }

    public void testRemoveFrameStore() {
        final boolean[] called = new boolean[]{false};
        FrameStoreAdapter fs = new FrameStoreAdapter(){

            public Frame getFrame(String name) {
                called[0] = true;
                return super.getFrame(name);
            }
        };
        this.getDomainKB().insertFrameStore(fs);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertTrue((boolean)called[0]);
        called[0] = false;
        this.getDomainKB().removeFrameStore(fs);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertFalse((boolean)called[0]);
    }

    public void testRemoveFrameStoreWithPosition() {
        final boolean[] called = new boolean[]{false};
        FrameStoreAdapter fs = new FrameStoreAdapter(){

            public Frame getFrame(String name) {
                called[0] = true;
                return super.getFrame(name);
            }
        };
        this.getDomainKB().insertFrameStore(fs, 3);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertTrue((boolean)called[0]);
        called[0] = false;
        this.getDomainKB().removeFrameStore(fs);
        this.getDomainKB().getCls("foo");
        DefaultKnowledgeBase_Test.assertFalse((boolean)called[0]);
    }

    public void testGetOverriddenDefaultValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setDefaultValues(DefaultKnowledgeBase_Test.makeList("foo"));
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList("bar"));
        Cls subcls = this.createSubCls(cls);
        subcls.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList("baz"));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("bar"), cls.getTemplateSlotDefaultValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("baz"), subcls.getTemplateSlotDefaultValues(slot));
    }

    public void testGetOwnSlotDefaultValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setDefaultValues(DefaultKnowledgeBase_Test.makeList("foo"));
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList("foo"), instance.getOwnSlotDefaultValues(slot));
    }

    public void testGetDomain() {
        Cls clsA = this.createCls();
        Cls clsB = this.createCls();
        Cls clsB1 = this.createSubCls(clsB);
        Cls clsB11 = this.createSubCls(clsB1);
        Slot slot = this.createSlotOnCls(clsB);
        Collection domain = slot.getDomain();
        DefaultKnowledgeBase_Test.assertFalse((boolean)domain.contains(clsA));
        DefaultKnowledgeBase_Test.assertTrue((boolean)domain.contains(clsB));
        DefaultKnowledgeBase_Test.assertTrue((boolean)domain.contains(clsB1));
        DefaultKnowledgeBase_Test.assertTrue((boolean)domain.contains(clsB11));
        DefaultKnowledgeBase_Test.assertFalse((boolean)domain.contains(this.getDomainKB().getRootCls()));
    }

    public void testUndoCreateCls() {
        this.enableUndo();
        Cls cls = this.createCls();
        Cls standardCls = this.getCls(":STANDARD-CLASS");
        Cls metaclass = this.createSubCls(standardCls);
        Cls clsA = this.createSubClsWithType(cls, metaclass);
        String clsAName = clsA.getName();
        Cls clsB = this.createCls();
        String clsBName = clsB.getName();
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsBName));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsAName));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        this.redo();
        Cls clsAPrime = (Cls)this.getFrame(clsAName);
        DefaultKnowledgeBase_Test.assertNotNull((Object)clsAPrime);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls), clsAPrime.getDirectSuperclasses());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(metaclass), clsAPrime.getDirectTypes());
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsBName));
        this.redo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsBName));
    }

    private void enableUndo() {
        this.getDomainKB().setUndoEnabled(true);
    }

    private void undo() {
        DefaultKnowledgeBase_Test.assertTrue((boolean)this.getDomainKB().getCommandManager().canUndo());
        this.getDomainKB().getCommandManager().undo();
    }

    private void redo() {
        DefaultKnowledgeBase_Test.assertTrue((boolean)this.getDomainKB().getCommandManager().canRedo());
        this.getDomainKB().getCommandManager().redo();
    }

    public void testUndoDeleteCls() {
        Cls cls = this.createCls();
        Cls standardCls = this.getCls(":STANDARD-CLASS");
        Cls metaCls = this.createSubCls(standardCls);
        Cls clsA = this.createSubClsWithType(cls, metaCls);
        String clsAName = clsA.getName();
        this.enableUndo();
        this.getDomainKB().deleteCls(clsA);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        this.undo();
        Cls clsAPrime = this.getCls(clsAName);
        DefaultKnowledgeBase_Test.assertNotNull((Object)clsAPrime);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(cls), clsAPrime.getDirectSuperclasses());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(metaCls), clsAPrime.getDirectTypes());
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
    }

    public void testUndoDeleteInstanceWithReferences() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        Instance instanceA = cls.createDirectInstance(null);
        Instance instanceB = cls.createDirectInstance(null);
        instanceA.setOwnSlotValue(slot, instanceB);
        instanceB.setOwnSlotValue(slot, instanceA);
        this.enableUndo();
        this.delete(instanceB);
        DefaultKnowledgeBase_Test.assertNull((Object)instanceA.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertTrue((boolean)instanceB.isDeleted());
        this.undo();
        DefaultKnowledgeBase_Test.assertEquals((Object)instanceB, (Object)instanceA.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertEquals((Object)instanceA, (Object)instanceB.getOwnSlotValue(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)instanceA.getOwnSlotValue(slot));
        DefaultKnowledgeBase_Test.assertTrue((boolean)instanceB.isDeleted());
    }

    public void testDeleteClsWithSlots() {
        Cls cls = this.createCls();
        Slot slotA = this.createSlotOnCls(cls);
        Slot slotB = this.createSlotOnCls(cls);
        this.enableUndo();
        this.delete(cls);
        this.undo();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(slotA, slotB), cls.getDirectTemplateSlots());
        this.redo();
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.isDeleted());
        this.undo();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(slotA, slotB), cls.getDirectTemplateSlots());
    }

    public void testUndoDeleteWithFacetOverrides() {
        Cls cls = this.createCls();
        Cls clsA = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        slot.setAllowedClses(this.getDomainKB().getRootClses());
        cls.setTemplateSlotAllowedClses(slot, DefaultKnowledgeBase_Test.makeList(clsA));
        this.enableUndo();
        this.delete(clsA);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.undo();
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(clsA), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(), (Object)cls.getTemplateSlotAllowedClses(slot));
        this.undo();
        String clsName = cls.getName();
        this.delete(cls);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getCls(clsName));
        this.undo();
        cls = this.getCls(clsName);
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.isDeleted());
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(clsA), cls.getTemplateSlotAllowedClses(slot));
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getCls(clsName));
    }

    public void testFoo() {
        Cls clsA = this.createCls("A");
        Cls clsB = this.createCls("B");
        this.enableUndo();
        this.delete(clsA);
        this.undo();
        this.delete(clsB);
        this.undo();
    }

    public void testDeleteAfterUndo() {
        Cls clsA = this.createCls();
        String clsAName = clsA.getName();
        Cls clsB = this.createCls();
        String clsBName = clsB.getName();
        this.enableUndo();
        this.delete(clsA);
        this.delete(clsB);
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsBName));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsBName));
        this.undo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsAName));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsBName));
        this.redo();
        this.redo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsBName));
        this.undo();
        DefaultKnowledgeBase_Test.assertNull((Object)this.getFrame(clsAName));
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsBName));
        this.delete(clsB);
        this.undo();
        DefaultKnowledgeBase_Test.assertNotNull((Object)this.getFrame(clsBName));
    }

    public void testGetClsCount() {
        KnowledgeBase kb = this.getDomainKB();
        int count = kb.getClsCount();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertEquals((int)(count + 1), (int)kb.getClsCount());
        kb.deleteCls(cls);
        DefaultKnowledgeBase_Test.assertEquals((int)count, (int)kb.getClsCount());
    }

    public void testGetSlotCount() {
        KnowledgeBase kb = this.getDomainKB();
        int count = kb.getSlotCount();
        Slot slot = this.createSlot();
        DefaultKnowledgeBase_Test.assertEquals((int)(count + 1), (int)kb.getSlotCount());
        kb.deleteSlot(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)count, (int)kb.getSlotCount());
    }

    public void testGetFacetCount() {
    }

    public void testGetSimpleInstanceCount() {
    }

    public void testGetFrameCount() {
    }

    public void testGetClses() {
    }

    public void testGetSlots() {
    }

    public void testGetFacets() {
    }

    public void testGetFrames() {
    }

    public void testGetFrameByID() {
    }

    public void testGetFrameByName() {
    }

    public void testGetFrameName() {
    }

    public void testCreateCls() {
    }

    public void testCreateSlot() {
    }

    public void testCreateFacet() {
    }

    public void testCreateSimpleInstance() {
    }

    public void testDeleteSlot() {
    }

    public void testDeleteFacet() {
    }

    public void testDeleteSimpleInstance() {
    }

    public void testAddInverseSlotValue() {
        Cls c = this.createCls();
        Slot s1 = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot s2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        s1.setInverseSlot(s2);
        c.addDirectTemplateSlot(s1);
        c.addDirectTemplateSlot(s2);
        Instance instanceA = this.createInstance(c);
        Instance instanceB = this.createInstance(c);
        instanceA.addOwnSlotValue(s1, instanceB);
        DefaultKnowledgeBase_Test.assertSame((String)"forward", (Object)instanceB, (Object)instanceA.getOwnSlotValue(s1));
        DefaultKnowledgeBase_Test.assertSame((String)"backward", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s2));
    }

    public void testAddOwnSlotValue() {
        Cls c = this.createCls();
        Slot s = this.createMultiValuedSlot(ValueType.INSTANCE);
        Instance instance = this.createInstance(c);
        Instance value1 = this.createInstance(c);
        Instance value2 = this.createInstance(c);
        instance.setOwnSlotValue(s, value1);
        instance.addOwnSlotValue(s, value2);
        DefaultKnowledgeBase_Test.assertEquals((String)"pass 1", (int)2, (int)instance.getOwnSlotValues(s).size());
        instance.setOwnSlotValue(s, value1);
        instance.addOwnSlotValue(s, value2);
        DefaultKnowledgeBase_Test.assertEquals((String)"pass 2", (int)2, (int)instance.getOwnSlotValues(s).size());
        DefaultKnowledgeBase_Test.assertSame((String)"add doesn't replace", (Object)value1, (Object)instance.getOwnSlotValue(s));
    }

    public void testAreValidOwnSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.INTEGER);
        slot.setMinimumValue(new Integer(2));
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.assertFalse((String)"1", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(1))));
        DefaultKnowledgeBase_Test.assertTrue((String)"2", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(2))));
        DefaultKnowledgeBase_Test.assertTrue((String)"3", (boolean)instance.areValidOwnSlotValues(slot, Collections.singleton(new Integer(3))));
    }

    public void testCreateSubslot() {
        Cls c = this.createCls();
        Slot a = this.createMultiValuedSlot(ValueType.INSTANCE, c);
        Slot b = this.createSubSlot(a);
        DefaultKnowledgeBase_Test.assertSame((String)"a type", (Object)ValueType.INSTANCE, (Object)a.getValueType());
        DefaultKnowledgeBase_Test.assertSame((String)"b type", (Object)ValueType.INSTANCE, (Object)b.getValueType());
        DefaultKnowledgeBase_Test.assertTrue((String)"a cardinality", (boolean)a.getAllowsMultipleValues());
        DefaultKnowledgeBase_Test.assertTrue((String)"b cardinality", (boolean)b.getAllowsMultipleValues());
    }

    public void testDeleteCls() {
        Cls cls = this.createCls();
        Cls subCls1 = this.createSubCls(cls);
        Cls subCls2 = this.createSubCls(cls);
        Instance instance1 = this.createInstance(subCls1);
        Instance instance2 = this.createInstance(subCls2);
        int nFrames = this.getFrameCount();
        try {
            this.deleteFrame(subCls1);
            DefaultKnowledgeBase_Test.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with direct instance", (int)nFrames, (int)this.getFrameCount());
        try {
            this.deleteFrame(cls);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with indirect instance", (int)nFrames, (int)this.getFrameCount());
        this.deleteFrame(instance1);
        this.deleteFrame(subCls1);
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with no direct instance", (int)(nFrames -= 2), (int)this.getFrameCount());
        this.deleteFrame(instance2);
        this.deleteFrame(cls);
        DefaultKnowledgeBase_Test.assertEquals((String)"delete with no instances", (int)(nFrames -= 3), (int)this.getFrameCount());
    }

    public void testDeleteClsEvent() {
        final KnowledgeBaseEvent[] firedEvent = new KnowledgeBaseEvent[1];
        Cls cls = this.createCls();
        String name = cls.getName();
        KnowledgeBaseAdapter listener = new KnowledgeBaseAdapter(){

            public void clsDeleted(KnowledgeBaseEvent event) {
                firedEvent[0] = event;
            }
        };
        cls.getKnowledgeBase().addKnowledgeBaseListener(listener);
        this.clearEvents();
        this.deleteFrame(cls);
        cls.getKnowledgeBase().removeKnowledgeBaseListener(listener);
        DefaultKnowledgeBase_Test.assertNotNull((String)"fired", (Object)firedEvent[0]);
        DefaultKnowledgeBase_Test.assertEquals((String)"name available", (String)name, (String)firedEvent[0].getOldName());
    }

    public void testFacetOverrides() {
        Cls a = this.createCls();
        Cls b = this.createSubCls(a);
        Slot s = this.createSingleValuedSlot(ValueType.ANY);
        a.addDirectTemplateSlot(s);
        Facet valueTypeFacet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.ANY, (Object)s.getValueType());
        DefaultKnowledgeBase_Test.assertFalse((String)"a not overridden", (boolean)a.hasOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not overridden", (boolean)b.hasOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertFalse((String)"a not directly overridden", (boolean)a.hasDirectlyOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not directly overridden", (boolean)b.hasDirectlyOverriddenTemplateSlot(s));
        a.setTemplateSlotValueType(s, ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.ANY, (Object)s.getValueType());
        DefaultKnowledgeBase_Test.assertEquals((Object)ValueType.FLOAT, (Object)a.getTemplateSlotValueType(s));
        DefaultKnowledgeBase_Test.assertTrue((String)"a overridden", (boolean)a.hasOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertTrue((String)"b overridden", (boolean)b.hasOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertTrue((String)"a directly overridden", (boolean)a.hasDirectlyOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertFalse((String)"b not directly overridden", (boolean)b.hasDirectlyOverriddenTemplateSlot(s));
        DefaultKnowledgeBase_Test.assertTrue((String)"a valueType overridden", (boolean)a.hasOverriddenTemplateFacet(s, valueTypeFacet));
        DefaultKnowledgeBase_Test.assertTrue((String)"a valueType directly overridden", (boolean)a.hasDirectlyOverriddenTemplateFacet(s, valueTypeFacet));
        DefaultKnowledgeBase_Test.assertTrue((String)"b valueType overridden", (boolean)b.hasOverriddenTemplateFacet(s, valueTypeFacet));
        DefaultKnowledgeBase_Test.assertFalse((String)"b valueType direct overridden", (boolean)b.hasDirectlyOverriddenTemplateFacet(s, valueTypeFacet));
    }

    public void testIsDirectlyOverriddenFacet() {
        Cls a = this.createCls();
        Cls b = this.createSubCls(a);
        Slot s = this.createSingleValuedSlot(ValueType.INSTANCE);
        a.addDirectTemplateSlot(s);
        b.setTemplateSlotDefaultValues(s, Collections.singleton(a));
        for (Facet facet : b.getTemplateFacets(s)) {
            boolean overridden = b.hasOverriddenTemplateFacet(s, facet);
            boolean shouldBeOverridden = facet.getName().equals(":DEFAULTS");
            DefaultKnowledgeBase_Test.assertEquals((String)("facet: " + facet), (boolean)shouldBeOverridden, (boolean)overridden);
        }
    }

    public void testGetMatchingReferences() {
        Slot s = this.createMultiValuedSlot(ValueType.STRING);
        Cls a = this.createCls();
        a.addDirectTemplateSlot(s);
        Instance inst1 = this.createInstance(a);
        Instance inst2 = this.createInstance(a);
        Instance inst3 = this.createInstance(a);
        inst1.addOwnSlotValue(s, "zabcy");
        inst2.addOwnSlotValue(s, "abcz");
        inst3.addOwnSlotValue(s, "qqq");
        DefaultKnowledgeBase_Test.assertEquals((String)"exact", (int)0, (int)this.getDomainKB().getMatchingReferences("z", 0).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"starts", (int)1, (int)this.getDomainKB().getMatchingReferences("z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains", (int)2, (int)this.getDomainKB().getMatchingReferences("*z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains insensitive", (int)2, (int)this.getDomainKB().getMatchingReferences("*Z*", -1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"contains 2", (int)2, (int)this.getDomainKB().getMatchingReferences("*abc*", -1).size());
    }

    public void testGetFramesWithValue() {
        Slot s1 = this.createMultiValuedSlot(ValueType.STRING);
        Slot s2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        Cls a = this.createCls();
        a.addDirectTemplateSlot(s1);
        a.addDirectTemplateSlot(s2);
        Instance inst1 = this.createInstance(a);
        Instance inst2 = this.createInstance(a);
        Instance inst3 = this.createInstance(a);
        inst1.addOwnSlotValue(s1, "abc");
        inst2.addOwnSlotValue(s1, "abc");
        inst3.addOwnSlotValue(s1, "abc");
        inst2.addOwnSlotValue(s2, inst1);
        DefaultKnowledgeBase_Test.assertEquals((String)"string match", (int)3, (int)this.getDomainKB().getFramesWithValue(s1, null, false, "abc").size());
        DefaultKnowledgeBase_Test.assertEquals((String)"frame match", (int)1, (int)this.getDomainKB().getFramesWithValue(s2, null, false, inst1).size());
    }

    public void testGetInstances() {
        ArrayList<Instance> c = new ArrayList<Instance>(this.getProject().getSources().getKnowledgeBase().getInstances());
        Collections.sort(c, new FrameNameComparator());
        for (Instance instance : c) {
            DefaultKnowledgeBase_Test.assertNotNull((Object)instance.getName());
        }
    }

    public void testGetMatchingFrameNames() {
    }

    public void testInverseSlotRelationship() {
        Slot s1 = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot s2 = this.createSingleValuedSlot(ValueType.INSTANCE);
        s1.setInverseSlot(s2);
        DefaultKnowledgeBase_Test.assertSame((String)"created", (Object)s1, (Object)s2.getInverseSlot());
        s1.setInverseSlot(null);
        DefaultKnowledgeBase_Test.assertNull((String)"null", (Object)s2.getInverseSlot());
    }

    public void testJavaPackagesOnInstance() {
        Class<TestSimpleInstance> testJavaClass = TestSimpleInstance.class;
        String fullClsName = testJavaClass.getName();
        int index = fullClsName.lastIndexOf(46);
        String packageName = fullClsName.substring(0, index);
        String clsName = fullClsName.substring(index + 1);
        this.getProject().addJavaPackageName(packageName);
        Cls testCls = this.getCls(clsName);
        if (testCls == null) {
            testCls = this.createCls(clsName);
        }
        Instance instance = this.createInstance(testCls);
        DefaultKnowledgeBase_Test.assertEquals(testJavaClass, instance.getClass());
        DefaultKnowledgeBase_Test.saveAndReload();
        testCls = this.getCls(clsName);
        DefaultKnowledgeBase_Test.assertNotNull((String)"after reload", (Object)testCls);
        for (Instance inst : testCls.getDirectInstances()) {
            DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + inst), (boolean)testJavaClass.isInstance(instance));
        }
        this.getProject().removeJavaPackageName(packageName);
    }

    public void testJavaPackagesOnCls() {
        Class<TestCls> testClass = TestCls.class;
        String fullClsName = testClass.getName();
        int index = fullClsName.lastIndexOf(46);
        String packageName = fullClsName.substring(0, index);
        String clsName = fullClsName.substring(index + 1);
        this.getProject().addJavaPackageName(packageName);
        Cls standardCls = this.getCls(":STANDARD-CLASS");
        Cls testCls = this.getCls(clsName);
        if (testCls == null) {
            testCls = this.createCls(clsName, standardCls);
        }
        Cls cls = this.createClsWithType(testCls);
        DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + cls), (boolean)testClass.isInstance(cls));
        DefaultKnowledgeBase_Test.saveAndReload();
        testCls = this.getCls(clsName);
        DefaultKnowledgeBase_Test.assertNotNull((String)"after reload", (Object)testCls);
        for (Cls cls2 : testCls.getDirectInstances()) {
            DefaultKnowledgeBase_Test.assertTrue((String)("correct class: " + cls2.getClass()), (boolean)testClass.isInstance(cls2));
        }
        this.getProject().removeJavaPackageName(packageName);
    }

    public void testJavaPackagesCreateClsEvent() {
        final Class<TestCls> testClass = TestCls.class;
        String fullClsName = testClass.getName();
        int index = fullClsName.lastIndexOf(46);
        String packageName = fullClsName.substring(0, index);
        String clsName = fullClsName.substring(index + 1);
        this.getProject().addJavaPackageName(packageName);
        Cls standardCls = this.getCls(":STANDARD-CLASS");
        Cls testCls = this.getCls(clsName);
        if (testCls == null) {
            testCls = this.createCls(clsName, standardCls);
        }
        KnowledgeBaseAdapter listener = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent event) {
                Assert.assertTrue((boolean)testClass.isInstance(event.getCls()));
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(listener);
        this.clearEvents();
        Cls cls = this.createClsWithType(testCls);
        DefaultKnowledgeBase_Test.assertTrue((boolean)testClass.isInstance(cls));
        this.assertEventFired(601);
    }

    public void testCreateClsEvent() {
        KnowledgeBaseAdapter listener = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent event) {
                Assert.assertNotNull((Object)event.getCls());
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(listener);
        this.clearEvents();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertNotNull((Object)cls);
        this.assertEventFired(601);
    }

    public void testFrameFactoryCreateClsEvent() {
        this.getDomainKB().setFrameFactory(new TestFrameFactory(this.getDomainKB()));
        KnowledgeBaseAdapter listener = new KnowledgeBaseAdapter(){

            public void clsCreated(KnowledgeBaseEvent event) {
                Assert.assertTrue((boolean)(event.getCls() instanceof TestCls));
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(listener);
        this.clearEvents();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)(cls instanceof TestCls));
        this.assertEventFired(601);
    }

    public void testModificationSlots() throws ParseException {
        String user_name = ApplicationProperties.getUserName();
        Date start = new Date();
        SystemUtilities.sleepMsec(100);
        KnowledgeBase kb = this.getDomainKB();
        kb.setModificationRecordUpdatingEnabled(true);
        Cls metaCls = this.createSubCls(this.getCls(":STANDARD-CLASS"));
        metaCls.addDirectTemplateSlot(this.getSlot(":CREATOR"));
        metaCls.addDirectTemplateSlot(this.getSlot(":CREATION-TIMESTAMP"));
        metaCls.addDirectTemplateSlot(this.getSlot(":MODIFIER"));
        metaCls.addDirectTemplateSlot(this.getSlot(":MODIFICATION-TIMESTAMP"));
        Slot slot = this.createSingleValuedSlot(ValueType.INSTANCE);
        Cls a = (Cls)this.createInstance(metaCls);
        DefaultKnowledgeBase_Test.assertEquals((String)"creator", (String)user_name, (String)kb.getFrameCreator(a));
        String creationString = kb.getFrameCreationTimestamp(a);
        DefaultKnowledgeBase_Test.assertNotNull((String)"creation stamp", (Object)creationString);
        Date createDate = new StandardDateFormat().parse(creationString);
        SystemUtilities.sleepMsec(100);
        Date endDate = new Date();
        DefaultKnowledgeBase_Test.assertTrue((String)("create timestamp after begin: " + createDate + " - " + start), (boolean)createDate.after(start));
        DefaultKnowledgeBase_Test.assertTrue((String)("create timestamp before end: " + createDate + " - " + endDate), (boolean)createDate.before(endDate));
        a.addDirectTemplateSlot(slot);
        SystemUtilities.sleepMsec(100);
        String modifier = kb.getFrameLastModifier(a);
        DefaultKnowledgeBase_Test.assertEquals((String)"name", (String)user_name, (String)modifier);
        String modStamp = kb.getFrameLastModificationTimestamp(a);
        DefaultKnowledgeBase_Test.assertNotNull((String)"timestamp", (Object)modStamp);
        Date modDate = new StandardDateFormat().parse(modStamp);
        SystemUtilities.sleepMsec(100);
        Date end = new Date();
        DefaultKnowledgeBase_Test.assertTrue((String)("mod timestamp after begin: " + modDate + " - " + start), (boolean)modDate.after(start));
        DefaultKnowledgeBase_Test.assertTrue((String)("mod timestamp before end: " + modDate + " - " + end), (boolean)modDate.before(end));
        kb.setModificationRecordUpdatingEnabled(false);
    }

    public void testRecursiveDelete() {
        Cls clsA = this.createCls();
        Cls clsB = this.createSubCls(clsA);
        this.createSubCls(clsB);
        int count = this.getFrameCount();
        this.deleteFrame(clsB);
        int newCount = count - 2;
        DefaultKnowledgeBase_Test.assertEquals((int)newCount, (int)this.getFrameCount());
        DefaultKnowledgeBase_Test.saveAndReload();
        DefaultKnowledgeBase_Test.assertEquals((int)newCount, (int)this.getFrameCount());
    }

    public void testRemoveInverseSlotValue() {
        Cls c = this.createCls();
        Slot s1 = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot s2 = this.createSingleValuedSlot(ValueType.INSTANCE);
        s1.setInverseSlot(s2);
        c.addDirectTemplateSlot(s1);
        c.addDirectTemplateSlot(s2);
        Instance instanceA = this.createInstance(c);
        Instance instanceB = this.createInstance(c);
        instanceA.setOwnSlotValues(s1, Collections.singleton(instanceB));
        instanceA.setOwnSlotValue(s1, null);
        DefaultKnowledgeBase_Test.assertNull((String)"forward", (Object)instanceA.getOwnSlotValue(s1));
        DefaultKnowledgeBase_Test.assertNull((String)"backward", (Object)instanceB.getOwnSlotValue(s2));
    }

    public void testRemoveOwnSlotValue() {
        Cls c = this.createCls();
        Slot s = this.createSingleValuedSlot(ValueType.INSTANCE);
        c.addDirectTemplateSlot(s);
        Instance instanceA = this.createInstance(c);
        Instance instanceB = this.createInstance(c);
        Instance instanceC = this.createInstance(c);
        ArrayList<Instance> values = new ArrayList<Instance>();
        values.add(instanceB);
        values.add(instanceC);
        instanceA.setOwnSlotValues(s, values);
        instanceA.removeOwnSlotValue(s, instanceC);
        DefaultKnowledgeBase_Test.assertEquals((String)"size", (int)1, (int)instanceA.getOwnSlotValueCount(s));
        DefaultKnowledgeBase_Test.assertEquals((String)"1st value", (Object)instanceB, (Object)instanceA.getOwnSlotValue(s));
        instanceA.setOwnSlotValues(s, values);
        instanceA.removeOwnSlotValue(s, instanceB);
        DefaultKnowledgeBase_Test.assertEquals((String)"size", (int)1, (int)instanceA.getOwnSlotValueCount(s));
        DefaultKnowledgeBase_Test.assertEquals((String)"2nd value", (Object)instanceC, (Object)instanceA.getOwnSlotValue(s));
    }

    public void testSaveLoadTemplateSlotValues() {
        Cls c1 = this.createCls();
        Cls c2 = this.createCls();
        String c2Name = c2.getName();
        Slot s = this.createSingleValuedSlot(ValueType.INSTANCE);
        String sName = s.getName();
        c2.addDirectTemplateSlot(s);
        Set<Cls> values = Collections.singleton(c1);
        s.setValues(values);
        c2.setTemplateSlotValues(s, values);
        DefaultKnowledgeBase_Test.saveAndReload();
        s = this.getSlot(sName);
        c2 = this.getCls(c2Name);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)s.getValues().size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)c2.getTemplateSlotValues(s).size());
    }

    public void testSetInverseSlotValue() {
        Cls c = this.createCls();
        Slot s1 = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot s2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        s1.setInverseSlot(s2);
        c.addDirectTemplateSlot(s1);
        c.addDirectTemplateSlot(s2);
        Instance instanceA = this.createInstance(c);
        Instance instanceB = this.createInstance(c);
        String s1Name = s1.getName();
        String s2Name = s2.getName();
        String instanceAName = instanceA.getName();
        String instanceBName = instanceB.getName();
        instanceA.setOwnSlotValue(s1, instanceB);
        DefaultKnowledgeBase_Test.assertSame((String)"set with value", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s2));
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instanceB.getOwnSlotValues(s2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instanceA.getOwnSlotValues(s1).size());
        instanceA.setOwnSlotValue(s1, null);
        DefaultKnowledgeBase_Test.assertNull((Object)instanceB.getOwnSlotValue(s2));
        instanceA.setOwnSlotValue(s1, instanceB);
        DefaultKnowledgeBase_Test.saveAndReload();
        s1 = this.getSlot(s1Name);
        s2 = this.getSlot(s2Name);
        instanceA = this.getInstance(instanceAName);
        instanceB = this.getInstance(instanceBName);
        DefaultKnowledgeBase_Test.assertEquals((Object)instanceA, (Object)instanceB.getOwnSlotValue(s2));
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instanceB.getOwnSlotValues(s2).size());
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)instanceA.getOwnSlotValues(s1).size());
    }

    public void testSetInverseSlotValues1N() {
        Cls cls = this.createCls();
        Slot s1 = this.createSingleValuedSlot(ValueType.INSTANCE);
        Slot sN = this.createMultiValuedSlot(ValueType.INSTANCE);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)s1.getMaximumCardinality());
        s1.setInverseSlot(sN);
        cls.addDirectTemplateSlot(s1);
        cls.addDirectTemplateSlot(sN);
        Instance instanceA = this.createInstance(cls);
        Instance instanceB = this.createInstance(cls);
        Instance instanceC = this.createInstance(cls);
        String s1Name = s1.getName();
        String sNName = sN.getName();
        String instanceAName = instanceA.getName();
        String instanceBName = instanceB.getName();
        String instanceCName = instanceC.getName();
        instanceB.setOwnSlotValue(s1, instanceC);
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to c", (Object)instanceC, (Object)instanceB.getOwnSlotValue(s1));
        DefaultKnowledgeBase_Test.assertEquals((String)"c connected to b", (Object)instanceB, (Object)instanceC.getOwnSlotValue(sN));
        instanceA.setOwnSlotValues(sN, Collections.singleton(instanceB));
        DefaultKnowledgeBase_Test.assertEquals((String)"size b", (int)1, (int)instanceB.getOwnSlotValues(s1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to a", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s1));
        DefaultKnowledgeBase_Test.assertNull((String)"c disconnected", (Object)instanceC.getOwnSlotValue(sN));
        DefaultKnowledgeBase_Test.saveAndReload();
        s1 = this.getSlot(s1Name);
        sN = this.getSlot(sNName);
        instanceA = this.getInstance(instanceAName);
        instanceB = this.getInstance(instanceBName);
        instanceC = this.getInstance(instanceCName);
        DefaultKnowledgeBase_Test.assertEquals((String)"size b", (int)1, (int)instanceB.getOwnSlotValues(s1).size());
        DefaultKnowledgeBase_Test.assertEquals((String)"b connected to a", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s1));
        DefaultKnowledgeBase_Test.assertNull((String)"c disconnected", (Object)instanceC.getOwnSlotValue(sN));
    }

    public void testSetInverseSlotValuesNN() {
        Cls cls = this.createCls();
        Slot s1 = this.createMultiValuedSlot(ValueType.INSTANCE);
        Slot s2 = this.createMultiValuedSlot(ValueType.INSTANCE);
        s1.setInverseSlot(s2);
        cls.addDirectTemplateSlot(s1);
        cls.addDirectTemplateSlot(s2);
        Instance instanceA = this.createInstance(cls);
        Instance instanceB = this.createInstance(cls);
        String s2Name = s2.getName();
        String instanceAName = instanceA.getName();
        String instanceBName = instanceB.getName();
        instanceA.setOwnSlotValues(s1, Collections.singleton(instanceB));
        DefaultKnowledgeBase_Test.assertEquals((String)"set with values", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s2));
        instanceA.setOwnSlotValues(s1, Collections.EMPTY_LIST);
        DefaultKnowledgeBase_Test.assertNull((String)"set with empty collection", (Object)instanceB.getOwnSlotValue(s2));
        instanceA.setOwnSlotValues(s1, Collections.singleton(instanceB));
        DefaultKnowledgeBase_Test.saveAndReload();
        s2 = this.getSlot(s2Name);
        instanceA = this.getInstance(instanceAName);
        instanceB = this.getInstance(instanceBName);
        DefaultKnowledgeBase_Test.assertEquals((String)"set with values", (Object)instanceA, (Object)instanceB.getOwnSlotValue(s2));
    }

    public void testSetOwnSlotValue() {
        Cls c = this.createCls();
        Slot s = this.createMultiValuedSlot(ValueType.INSTANCE);
        c.addDirectTemplateSlot(s);
        Instance instanceA = this.createInstance(c);
        Instance instanceB = this.createInstance(c);
        instanceA.setOwnSlotValue(s, instanceB);
        Collection values = instanceA.getOwnSlotValues(s);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)values.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)instanceB, (Object)CollectionUtilities.getFirstItem(values));
        instanceA.setOwnSlotValue(s, instanceA);
        values = instanceA.getOwnSlotValues(s);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)values.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)instanceA, (Object)CollectionUtilities.getFirstItem(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOwnSlotValues() {
        this.getDomainKB().setValueChecking(true);
        Cls cls = this.createCls();
        Slot slot = this.createSingleValuedSlot(ValueType.STRING);
        cls.addDirectTemplateSlot(slot);
        Instance i = this.createInstance(cls);
        ArrayList<String> values = new ArrayList<String>();
        values.add("");
        i.setOwnSlotValues(slot, values);
        values.add("");
        try {
            i.setOwnSlotValues(slot, values);
            DefaultKnowledgeBase_Test.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException e) {
        }
        finally {
            this.getDomainKB().setValueChecking(false);
        }
    }

    public void testSubslots() {
        Cls cls = this.createCls();
        Instance instanceA = this.createInstance(cls);
        String instanceAName = instanceA.getName();
        Slot a = this.createMultiValuedSlot(ValueType.STRING);
        Slot b = this.createSubSlot(a);
        String obj1 = "a";
        String obj2 = "b";
        String aSlotName = a.getName();
        cls.addDirectTemplateSlot(a);
        cls.addDirectTemplateSlot(b);
        instanceA.setOwnSlotValue(a, obj1);
        instanceA.setOwnSlotValue(b, obj2);
        Collection aValues = instanceA.getOwnSlotValues(a);
        DefaultKnowledgeBase_Test.assertEquals((String)"a", (int)2, (int)aValues.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"a contains", (boolean)aValues.contains(obj1));
        Collection bValues = instanceA.getOwnSlotValues(b);
        DefaultKnowledgeBase_Test.assertEquals((String)"b", (int)1, (int)bValues.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"b contains", (boolean)bValues.contains(obj2));
        Collection allAValues = instanceA.getOwnSlotAndSubslotValues(a);
        DefaultKnowledgeBase_Test.assertEquals((String)"a and b", (int)2, (int)allAValues.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"a and b contains 1", (boolean)allAValues.contains(obj1));
        DefaultKnowledgeBase_Test.assertTrue((String)"a and b contains 2", (boolean)allAValues.contains(obj2));
        Collection allBValues = instanceA.getOwnSlotAndSubslotValues(b);
        DefaultKnowledgeBase_Test.assertEquals((String)"b but not a", (int)1, (int)allBValues.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"b but not a contains 2", (boolean)allBValues.contains(obj2));
        DefaultKnowledgeBase_Test.saveAndReload();
        a = this.getSlot(aSlotName);
        instanceA = this.getInstance(instanceAName);
        DefaultKnowledgeBase_Test.assertNotNull((String)"slot a", (Object)a);
        allAValues = instanceA.getOwnSlotAndSubslotValues(a);
        DefaultKnowledgeBase_Test.assertEquals((String)"save", (int)2, (int)allAValues.size());
        DefaultKnowledgeBase_Test.assertTrue((String)"save value 1", (boolean)allAValues.contains(obj1));
        DefaultKnowledgeBase_Test.assertTrue((String)"save value 2", (boolean)allAValues.contains(obj2));
    }

    public void testGetSuperslots() {
        Slot a = this.createSlot();
        Slot b = this.createSubSlot(a);
        Slot c = this.createSubSlot(b);
        Collection superslots = c.getSuperslots();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(a, b), superslots);
    }

    public void testTopLevelGetTemplateSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        List initialValues = DefaultKnowledgeBase_Test.makeList("foo", "bar");
        slot.setValues(initialValues);
        Collection directValues = slot.getValues();
        DefaultKnowledgeBase_Test.assertEqualsList(initialValues, directValues);
        cls.addDirectTemplateSlot(slot);
        Collection indirectValues = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(initialValues, indirectValues);
    }

    public void testGetTemplateSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        List initialValues = DefaultKnowledgeBase_Test.makeList("foo", "bar");
        cls.setTemplateSlotValues(slot, initialValues);
        Collection directValues = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(initialValues, directValues);
        Collection directValues2 = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)directValues2.size());
        DefaultKnowledgeBase_Test.assertEqualsList(initialValues, directValues2);
    }

    public void testAddTemplateSlotValue() {
        String VALUE = "foo";
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.addTemplateSlotValue(slot, VALUE);
        Collection values = cls.getTemplateSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)1, (int)values.size());
        DefaultKnowledgeBase_Test.assertEquals((Object)VALUE, (Object)CollectionUtilities.getFirstItem(values));
    }

    public void testValueTypeOverride() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        String clsName = cls.getName();
        String slotName = slot.getName();
        cls.addDirectTemplateSlot(slot);
        Facet facet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = (Cls)this.getFrame(clsName);
        slot = (Slot)this.getFrame(slotName);
        facet = (Facet)this.getFrame(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertFalse((String)"facet direct override 2", (boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((String)"facet override 2", (boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultKnowledgeBase_Test.assertFalse((String)"slot override 2", (boolean)cls.hasOverriddenTemplateSlot(slot));
        DefaultKnowledgeBase_Test.assertFalse((String)"slot direct override 2", (boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
    }

    public void testTemplateSlotValue() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("foo");
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        String clsName = cls.getName();
        String slotName = slot.getName();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValues(slot, values);
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getDirectTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(clsName);
        slot = this.getSlot(slotName);
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getDirectTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateSlotValues(slot));
    }

    public void testTemplateSlotValue2() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("foo");
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        Facet facet = this.getFacet(":VALUES");
        String clsName = cls.getName();
        String slotName = slot.getName();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateFacetValues(slot, facet, values);
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getDirectTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.saveAndReload();
        cls = this.getCls(clsName);
        slot = this.getSlot(slotName);
        facet = this.getFacet(":VALUES");
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getDirectTemplateFacetValues(slot, facet));
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateFacetValues(slot, facet));
    }

    public void testSetDirectTypeEvent() {
        Cls cls1 = this.createCls();
        Instance instance = this.createInstance(cls1);
        Cls cls2 = this.createCls();
        ClsAdapter clsListener1 = new ClsAdapter(){

            public void directInstanceRemoved(ClsEvent event) {
                super.directInstanceRemoved(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        cls1.addClsListener(clsListener1);
        ClsAdapter clsListener2 = new ClsAdapter(){

            public void directInstanceAdded(ClsEvent event) {
                super.directInstanceAdded(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        cls2.addClsListener(clsListener2);
        InstanceAdapter instanceListener = new InstanceAdapter(){

            public void directTypeAdded(InstanceEvent event) {
                super.directTypeAdded(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }

            public void directTypeRemoved(InstanceEvent event) {
                super.directTypeRemoved(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        instance.addInstanceListener(instanceListener);
        this.clearEvents();
        instance.setDirectType(cls2);
        this.assertEventFired(306);
        this.assertEventFired(305);
        this.assertEventFired(202);
        this.assertEventFired(203);
    }

    public void testAddFrameListener() {
        FrameAdapter listener = new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        Slot slot = this.createSlot();
        Frame frame = this.createFrame();
        frame.addFrameListener(listener);
        this.clearEvents();
        frame.setOwnSlotValue(slot, "foo");
        this.assertEventFired(110);
        frame.removeFrameListener(listener);
        this.clearEvents();
        frame.setOwnSlotValue(slot, "bar");
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addFrameListener(listener);
        frame.setOwnSlotValue(slot, "baz");
        this.assertEventFired(110);
    }

    public void testAddSlotListener() {
        SlotAdapter listener = new SlotAdapter(){

            public void templateSlotClsAdded(SlotEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }

            public void templateSlotClsRemoved(SlotEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        Slot slot = this.createSlot();
        Cls cls = this.createCls();
        slot.addSlotListener(listener);
        this.clearEvents();
        cls.addDirectTemplateSlot(slot);
        this.assertEventFired(401);
        slot.removeSlotListener(listener);
        this.clearEvents();
        cls.removeDirectTemplateSlot(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addSlotListener(listener);
        cls.addDirectTemplateSlot(slot);
        this.assertEventFired(401);
    }

    public void testAddClsListener() {
        ClsAdapter listener = new ClsAdapter(){

            public void directSuperclassAdded(ClsEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }

            public void directSuperclassRemoved(ClsEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        Cls cls = this.createCls();
        Cls clsA = this.createCls();
        cls.addClsListener(listener);
        this.clearEvents();
        cls.addDirectSuperclass(clsA);
        this.assertEventFired(301);
        cls.removeClsListener(listener);
        this.clearEvents();
        cls.removeDirectSuperclass(clsA);
        DefaultKnowledgeBase_Test.assertEquals((int)0, (int)this.getEventCount());
        this.getDomainKB().addClsListener(listener);
        cls.addDirectSuperclass(clsA);
        this.assertEventFired(301);
    }

    public void testDeleteInstanceEvent() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        KnowledgeBaseAdapter kbListener = new KnowledgeBaseAdapter(){

            public void instanceDeleted(KnowledgeBaseEvent event) {
                super.instanceDeleted(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        this.getDomainKB().addKnowledgeBaseListener(kbListener);
        ClsAdapter clsListener = new ClsAdapter(){

            public void directInstanceRemoved(ClsEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        };
        this.getDomainKB().addClsListener(cls, clsListener);
        this.clearEvents();
        this.getDomainKB().deleteInstance(instance);
        this.assertEventFired(608);
        this.assertEventFired(306);
    }

    public void testAddSuperclassEvents() {
        Cls cls = this.createCls();
        Cls supercls = this.createCls();
        this.getDomainKB().addClsListener(new ClsAdapter(){

            public void directSuperclassAdded(ClsEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }

            public void directSubclassAdded(ClsEvent event) {
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        });
        this.clearEvents();
        cls.addDirectSuperclass(supercls);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)this.getEventCount());
        this.assertEventFired(301);
        this.assertEventFired(303);
    }

    public void testAddSuperslotEvents() {
        Slot slot = this.createSlot();
        Slot superSlot = this.createSlot();
        this.getDomainKB().addSlotListener(new SlotAdapter(){

            public void directSuperslotAdded(SlotEvent event) {
                super.directSuperslotAdded(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }

            public void directSubslotAdded(SlotEvent event) {
                super.directSubslotAdded(event);
                DefaultKnowledgeBase_Test.this.recordEventFired(event);
            }
        });
        this.clearEvents();
        slot.addDirectSuperslot(superSlot);
        DefaultKnowledgeBase_Test.assertEquals((int)2, (int)this.getEventCount());
        this.assertEventFired(407);
        this.assertEventFired(405);
    }

    public void testSetBadOwnSlotValue() {
        this.getDomainKB().setValueChecking(true);
        Frame frame = this.createFrame();
        Slot slot = this.createSlot();
        Object o = new Object();
        try {
            frame.setOwnSlotValue(slot, o);
            DefaultKnowledgeBase_Test.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSetBadFrameName() {
        String GOOD_NAME = "foo";
        String BAD_NAME = "foo * foo";
        KnowledgeBase kb = this.getDomainKB();
        Cls cls = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)kb.isValidFrameName(GOOD_NAME, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)kb.getInvalidFrameNameDescription(GOOD_NAME, cls));
        DefaultKnowledgeBase_Test.assertTrue((boolean)kb.isValidFrameName(BAD_NAME, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)kb.getInvalidFrameNameDescription(BAD_NAME, cls));
        kb.setFrameNameValidator(new FrameNameValidator(){

            public String getErrorMessage(String name, Frame frame) {
                return this.isValid(name, frame) ? null : "Contains a *";
            }

            public boolean isValid(String name, Frame frame) {
                return name.indexOf("*") == -1;
            }
        });
        DefaultKnowledgeBase_Test.assertTrue((boolean)kb.isValidFrameName(GOOD_NAME, cls));
        DefaultKnowledgeBase_Test.assertNull((Object)kb.getInvalidFrameNameDescription(GOOD_NAME, cls));
        DefaultKnowledgeBase_Test.assertFalse((boolean)kb.isValidFrameName(BAD_NAME, cls));
        DefaultKnowledgeBase_Test.assertNotNull((Object)kb.getInvalidFrameNameDescription(BAD_NAME, cls));
    }

    public void testDefaultClsMetaCls() {
        Cls cls = this.createCls();
        Cls directType = cls.getDirectType();
        Cls standardCls = (Cls)this.getFrame(":STANDARD-CLASS");
        DefaultKnowledgeBase_Test.assertEquals((Object)directType, (Object)standardCls);
        Cls metaCls = this.createCls(null, standardCls);
        this.getDomainKB().setDefaultClsMetaCls(metaCls);
        Cls cls1 = this.createCls(null, cls);
        DefaultKnowledgeBase_Test.assertEquals((Object)cls1.getDirectType(), (Object)standardCls);
        Cls cls2 = this.createCls();
        DefaultKnowledgeBase_Test.assertEquals((Object)cls2.getDirectType(), (Object)metaCls);
    }

    public void testRecursiveEquivalentClassesDelete() {
        Cls clsA = this.createCls();
        Cls clsB = this.createCls();
        Cls clsC = this.createSubCls(clsB);
        int frameCount = this.getFrameCount();
        Cls clsD = this.createSubCls(clsB);
        clsC.addDirectSuperclass(clsD);
        clsD.addDirectSuperclass(clsC);
        clsD.addDirectSuperclass(clsA);
        clsD.delete();
        DefaultKnowledgeBase_Test.assertEquals((int)frameCount, (int)this.getFrameCount());
    }

    public void testDirectDomainForSubslots() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        Slot subslot1 = this.createSubSlot(slot);
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(subslot1);
        Collection c = subslot1.getDirectDomain();
        DefaultKnowledgeBase_Test.assertEqualsSet(DefaultKnowledgeBase_Test.makeList(cls), c);
    }

    public void testRemoveTemplateSlotEvent() {
        final Boolean[] fired = new Boolean[]{Boolean.FALSE};
        final Cls cls = this.createCls();
        final Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.addClsListener(new ClsAdapter(){

            public void templateSlotRemoved(ClsEvent event) {
                super.templateSlotRemoved(event);
                Collection clses = slot.getDirectDomain();
                Assert.assertFalse((boolean)clses.contains(cls));
                fired[0] = Boolean.TRUE;
            }
        });
        cls.removeDirectTemplateSlot(slot);
        DefaultKnowledgeBase_Test.assertTrue((boolean)fired[0]);
    }

    public void testModifyReturnedCollection() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        DefaultKnowledgeBase_Test.checkUnmodifiable(instance, slot, 0);
        instance.setOwnSlotValue(slot, "foo");
        DefaultKnowledgeBase_Test.checkUnmodifiable(instance, slot, 1);
    }

    private static void checkUnmodifiable(Instance instance, Slot slot, int startSize) {
        Collection c = instance.getDirectOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.checkUnmodifiable(c);
        c = instance.getDirectOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)startSize, (int)c.size());
        c = instance.getOwnSlotValues(slot);
        DefaultKnowledgeBase_Test.assertEquals((int)startSize, (int)c.size());
        DefaultKnowledgeBase_Test.checkUnmodifiable(c);
        DefaultKnowledgeBase_Test.assertEquals((int)startSize, (int)c.size());
    }

    private static void checkUnmodifiable(Collection c) {
        try {
            c.add(new Object());
            DefaultKnowledgeBase_Test.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFrameStoreInsertion() {
        final Boolean[] fired = new Boolean[]{Boolean.FALSE};
        FrameStore originalHead = ((DefaultKnowledgeBase)this.getDomainKB()).getHeadFrameStore();
        FrameStoreAdapter testFs = new FrameStoreAdapter(){

            public Slot createSlot(FrameID id, String name, Collection superslots, Collection types, boolean init) {
                fired[0] = Boolean.TRUE;
                return this.getDelegate().createSlot(id, name, superslots, types, init);
            }
        };
        this.getDomainKB().insertFrameStore(testFs);
        DefaultKnowledgeBase_Test.assertEquals((Object)originalHead, (Object)testFs.getDelegate());
        this.getDomainKB().createSlot(null);
        DefaultKnowledgeBase_Test.assertTrue((boolean)fired[0]);
    }

    public void testStrangeOverride() {
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.STRING);
        Cls cls = this.createCls();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValueType(slot, ValueType.INSTANCE);
        Cls allowedCls = this.createCls();
        Collection allowedClses = CollectionUtilities.createCollection(allowedCls);
        cls.setTemplateSlotAllowedClses(slot, allowedClses);
        Collection returnedAllowedClses = cls.getTemplateSlotAllowedClses(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(allowedClses, returnedAllowedClses);
    }

    public void testSetValueType() {
        Cls cls = this.createCls();
        Collection allowedClses = CollectionUtilities.createCollection(this.createCls());
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotAllowedClses(slot, allowedClses);
        cls.setTemplateSlotValueType(slot, ValueType.INSTANCE);
        Collection returnedAllowedClses = cls.getTemplateSlotAllowedClses(slot);
        DefaultKnowledgeBase_Test.assertEqualsList(allowedClses, returnedAllowedClses);
    }

    public void testSaveAndLoadAllowedValues() {
        Cls cls = this.createCls();
        String clsName = cls.getName();
        Slot slot = this.createSlot();
        String slotName = slot.getName();
        cls.addDirectTemplateSlot(slot);
        ArrayList<String> values = new ArrayList<String>();
        values.add("a");
        values.add("b");
        cls.setTemplateSlotAllowedValues(slot, values);
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateSlotAllowedValues(slot));
        DefaultKnowledgeBase_Test.saveAndReload();
        slot = this.getSlot(slotName);
        cls = this.getCls(clsName);
        DefaultKnowledgeBase_Test.assertEqualsList(values, cls.getTemplateSlotAllowedValues(slot));
    }

    public void testHasSuperclass() {
        Cls a = this.createCls();
        Cls a_b = this.createSubCls(a);
        Cls a_c = this.createSubCls(a);
        Cls bc_d = this.createSubCls(a_b);
        bc_d.addDirectSuperclass(a_c);
        Cls d_e = this.createSubCls(bc_d);
        Cls f = this.createCls();
        Cls ef_g = this.createSubCls(d_e);
        ef_g.addDirectSuperclass(f);
        Cls h = this.createCls();
        DefaultKnowledgeBase_Test.assertTrue((boolean)bc_d.hasSuperclass(a));
        DefaultKnowledgeBase_Test.assertTrue((boolean)d_e.hasSuperclass(a_b));
        DefaultKnowledgeBase_Test.assertTrue((boolean)d_e.hasSuperclass(a_c));
        DefaultKnowledgeBase_Test.assertTrue((boolean)d_e.hasSuperclass(bc_d));
        DefaultKnowledgeBase_Test.assertTrue((boolean)ef_g.hasSuperclass(a));
        DefaultKnowledgeBase_Test.assertTrue((boolean)ef_g.hasSuperclass(a_c));
        DefaultKnowledgeBase_Test.assertTrue((boolean)ef_g.hasSuperclass(f));
        DefaultKnowledgeBase_Test.assertFalse((boolean)ef_g.hasSuperclass(h));
    }

    public void testTopLevelDefaultValueClear() {
        Integer DEFAULT = new Integer(1);
        List defaults = DefaultKnowledgeBase_Test.makeList(DEFAULT);
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.INTEGER);
        slot.setDefaultValues(defaults);
        DefaultKnowledgeBase_Test.assertEqualsList(defaults, slot.getDefaultValues());
        slot.setValueType(ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), slot.getDefaultValues());
    }

    public void testTemplateSlotDefaultValueClear() {
        Integer DEFAULT = new Integer(1);
        List defaults = DefaultKnowledgeBase_Test.makeList(DEFAULT);
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.setTemplateSlotValueType(slot, ValueType.INTEGER);
        cls.setTemplateSlotDefaultValues(slot, defaults);
        DefaultKnowledgeBase_Test.assertEqualsList(defaults, cls.getTemplateSlotDefaultValues(slot));
        cls.setTemplateSlotValueType(slot, ValueType.FLOAT);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), cls.getTemplateSlotDefaultValues(slot));
    }

    public void testDefaultAndTemplateInstanceClear() {
        Cls cls = this.createCls();
        Instance instance = this.createInstance(cls);
        Cls clsB = this.createCls();
        Slot slot = this.createSlot();
        clsB.addDirectTemplateSlot(slot);
        clsB.setTemplateSlotAllowedClses(slot, DefaultKnowledgeBase_Test.makeList(cls));
        clsB.setTemplateSlotValues(slot, DefaultKnowledgeBase_Test.makeList(instance));
        clsB.setTemplateSlotDefaultValues(slot, DefaultKnowledgeBase_Test.makeList(instance));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(instance), clsB.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(instance), clsB.getTemplateSlotDefaultValues(slot));
        clsB.setTemplateSlotValueType(slot, ValueType.STRING);
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), clsB.getTemplateSlotValues(slot));
        DefaultKnowledgeBase_Test.assertEqualsList(DefaultKnowledgeBase_Test.makeList(), clsB.getTemplateSlotDefaultValues(slot));
    }

    public void testClearSlotValuesOnValueTypeChange() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.STRING);
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        String stringValue = "foo";
        instance.setOwnSlotValue(slot, stringValue);
        DefaultKnowledgeBase_Test.assertEquals((Object)stringValue, (Object)instance.getOwnSlotValue(slot));
        slot.setValueType(ValueType.INTEGER);
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
        Integer intValue = new Integer(1);
        instance.setOwnSlotValue(slot, intValue);
        DefaultKnowledgeBase_Test.assertEquals((Object)intValue, (Object)instance.getOwnSlotValue(slot));
        cls.setTemplateSlotValueType(slot, ValueType.STRING);
        DefaultKnowledgeBase_Test.assertNull((Object)instance.getOwnSlotValue(slot));
    }

    public void testFacetOverride() {
        Cls cls = this.createCls();
        Cls otherCls = this.createCls();
        Slot slot = this.createSlot();
        slot.setValueType(ValueType.INSTANCE);
        slot.setAllowedClses(Collections.singleton(cls));
        cls.setTemplateSlotAllowedClses(slot, Collections.singleton(otherCls));
        Facet valueTypeFacet = this.getProject().getKnowledgeBase().getFacet(":VALUE-TYPE");
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, valueTypeFacet));
        cls.setTemplateSlotAllowedClses(slot, Collections.EMPTY_LIST);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, valueTypeFacet));
    }

    public void testSubSubslot() {
        Cls cls = this.createCls();
        List clses = DefaultKnowledgeBase_Test.makeList(cls);
        Slot slot = this.createSlot();
        slot.setAllowedClses(clses);
        Slot subslot = this.createSubSlot(slot);
        Slot subsubslot = this.createSubSlot(subslot);
        Collection subclses = subslot.getAllowedClses();
        DefaultKnowledgeBase_Test.assertEqualsList(clses, subclses);
        Collection subsubclses = subsubslot.getAllowedClses();
        DefaultKnowledgeBase_Test.assertEqualsList(clses, subsubclses);
    }

    public void testCreateEvent() {
        Cls cls = this.createCls();
        cls.addFrameListener(new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent event) {
                if (event.getSlot().equals(DefaultKnowledgeBase_Test.this.getSlot(":DIRECT-INSTANCES"))) {
                    DefaultKnowledgeBase_Test.this.recordEventFired(event);
                }
            }
        });
        this.clearEvents();
        cls.createDirectInstance(null);
        this.assertEventFired(110);
    }

    public void testSetFrameName() {
        Frame frame = this.createFrame();
        String name = frame.getName();
        frame.setName(name);
        try {
            frame.setName(null);
            DefaultKnowledgeBase_Test.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String name2 = name + Math.random();
        frame.setName(name2);
        DefaultKnowledgeBase_Test.assertEquals((String)name2, (String)frame.getName());
        Frame frame2 = this.createFrame();
        try {
            frame.setName(frame2.getName());
            DefaultKnowledgeBase_Test.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSetAllowedClsesOverride() {
        Cls cls = this.createCls();
        Cls subclass = this.createSubCls(cls);
        List clses1 = DefaultKnowledgeBase_Test.makeList(cls);
        List clses2 = DefaultKnowledgeBase_Test.makeList(subclass);
        Slot slot = this.createSlotOnCls(cls);
        slot.setAllowedClses(clses1);
        DefaultKnowledgeBase_Test.assertEqualsSet(clses1, slot.getAllowedClses());
        cls.setTemplateSlotAllowedClses(slot, clses1);
        DefaultKnowledgeBase_Test.assertEqualsSet(clses1, cls.getTemplateSlotAllowedClses(slot));
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
        cls.setTemplateSlotAllowedClses(slot, clses2);
        DefaultKnowledgeBase_Test.assertTrue((boolean)cls.hasOverriddenTemplateSlot(slot));
        cls.setTemplateSlotAllowedClses(slot, clses1);
        DefaultKnowledgeBase_Test.assertFalse((boolean)cls.hasOverriddenTemplateSlot(slot));
    }

    public void testAllowedClsesAsSet() {
        Cls clsA = this.createCls();
        Slot slot = this.createSlotOnCls(clsA);
        List clses = DefaultKnowledgeBase_Test.makeList(clsA, clsA);
        slot.setAllowedClses(clses);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(clsA), (Object)slot.getAllowedClses());
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(clsA), (Object)clsA.getTemplateSlotAllowedClses(slot));
        clsA.setTemplateSlotAllowedClses(slot, clses);
        DefaultKnowledgeBase_Test.assertEquals((Object)DefaultKnowledgeBase_Test.makeList(clsA), (Object)clsA.getTemplateSlotAllowedClses(slot));
    }

    public static class TestSimpleInstance
    extends DefaultSimpleInstance
    implements TestInterface {
        public TestSimpleInstance(KnowledgeBase kb, FrameID id) {
            super(kb, id);
        }
    }

    public static class TestFacet
    extends DefaultFacet
    implements TestInterface {
        public TestFacet(KnowledgeBase kb, FrameID id) {
            super(kb, id);
        }
    }

    public static class TestSlot
    extends DefaultSlot
    implements TestInterface {
        public TestSlot(KnowledgeBase kb, FrameID id) {
            super(kb, id);
        }
    }

    public static class TestCls
    extends DefaultCls
    implements TestInterface {
        public TestCls(KnowledgeBase kb, FrameID id) {
            super(kb, id);
        }
    }

    static interface TestInterface {
    }

    static class TestFrameFactory
    implements FrameFactory {
        private KnowledgeBase kb;

        TestFrameFactory(KnowledgeBase kb) {
            this.kb = kb;
        }

        public void addJavaPackage(String packageName) {
            throw new UnsupportedOperationException();
        }

        public Cls createCls(FrameID id, Collection directTypes) {
            return new TestCls(this.kb, id);
        }

        public Facet createFacet(FrameID id, Collection directTypes) {
            return new TestFacet(this.kb, id);
        }

        public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes) {
            return new TestSimpleInstance(this.kb, id);
        }

        public Slot createSlot(FrameID id, Collection directTypes) {
            return new TestSlot(this.kb, id);
        }

        public boolean isCorrectJavaImplementationClass(FrameID id, Collection types, Class clas) {
            return clas.isAssignableFrom(TestInterface.class);
        }

        public void removeJavaPackage(String packageName) {
            throw new UnsupportedOperationException();
        }

        public int getJavaClassId(Frame frame) {
            throw new UnsupportedOperationException();
        }

        public Frame createFrameFromClassId(int javaClassId, FrameID id) {
            throw new UnsupportedOperationException();
        }

        public Collection getClsJavaClassIds() {
            return null;
        }

        public Collection getSlotJavaClassIds() {
            return null;
        }

        public Collection getFacetJavaClassIds() {
            return null;
        }

        public Collection getSimpleInstanceJavaClassIds() {
            return null;
        }
    }
}

