/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import junit.framework.Assert;

public class DefaultKnowledgeBase_SimpleTest
extends SimpleTestCase {
    public void testCreateKB() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Cls thing1 = kb.getRootCls();
        Cls thing2 = kb.getCls(":THING");
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)thing1, (Object)thing2);
    }

    public void testCreateCls() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Cls cls = kb.createCls(null, kb.getRootClses());
        Cls cls2 = kb.getCls(cls.getName());
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)cls, (Object)cls2);
    }

    public void testCreateInstanceWithNoType() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Instance instance = kb.createInstance(null, (Cls)null);
        DefaultKnowledgeBase_SimpleTest.assertNotNull((Object)instance);
        String name = instance.getName();
        Instance instance2 = kb.getInstance(name);
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)instance, (Object)instance2);
    }

    public void testGetClses() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Cls cls = kb.createCls(null, kb.getRootClses());
        DefaultKnowledgeBase_SimpleTest.assertTrue((boolean)kb.getClses().contains(cls));
        DefaultKnowledgeBase_SimpleTest.assertTrue((boolean)kb.getClses().contains(kb.getRootCls()));
    }

    public void testGetValueType() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Slot slot = kb.createSlot(null);
        Cls cls = kb.createCls(null, kb.getRootClses());
        DefaultKnowledgeBase_SimpleTest.assertEquals((boolean)false, (boolean)cls.isAbstract());
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)ValueType.STRING, (Object)slot.getValueType());
        slot.setValueType(ValueType.INSTANCE);
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)ValueType.INSTANCE, (Object)slot.getValueType());
        cls.setAbstract(true);
        DefaultKnowledgeBase_SimpleTest.assertEquals((boolean)true, (boolean)cls.isAbstract());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(), slot.getDirectDomain());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(), cls.getDirectTemplateSlots());
        cls.addDirectTemplateSlot(slot);
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(slot), cls.getDirectTemplateSlots());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(cls), slot.getDirectDomain());
    }

    public void testDeleteCls() {
        final Boolean[] fired = new Boolean[]{Boolean.FALSE};
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Cls cls = kb.createCls(null, kb.getRootClses());
        kb.addKnowledgeBaseListener(new KnowledgeBaseAdapter(){

            public void clsDeleted(KnowledgeBaseEvent event) {
                Assert.assertTrue((event.getCls() != null ? 1 : 0) != 0);
                fired[0] = Boolean.TRUE;
            }
        });
        DefaultKnowledgeBase_SimpleTest.assertTrue((fired[0] == Boolean.FALSE ? 1 : 0) != 0);
        kb.deleteCls(cls);
        DefaultKnowledgeBase_SimpleTest.assertTrue((fired[0] == Boolean.TRUE ? 1 : 0) != 0);
    }

    public void testSetSystemFrameName() {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase();
        Cls root = kb.getRootCls();
        root.setName("my root class name");
        DefaultKnowledgeBase_SimpleTest.assertEquals((String)":THING", (String)root.getName());
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get(kb);
        NarrowFrameStore oldActiveFrameStore = mnfs.setActiveFrameStore(MergingNarrowFrameStore.getSystemFrameStore(kb));
        String FOO_NAME = "foo";
        root.setName(FOO_NAME);
        DefaultKnowledgeBase_SimpleTest.assertEquals((String)FOO_NAME, (String)root.getName());
        mnfs.setActiveFrameStore(oldActiveFrameStore);
    }
}

