/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.test.APITestCase;

public class DefaultCls_Test
extends APITestCase {
    public void testHasDirectlyOverriddenTemplateFacet() {
        Cls standardSlot = this.getCls(":STANDARD-SLOT");
        Cls myMetaSlot = this.createSubCls(standardSlot);
        Slot slotWithFacet = this.createSingleValuedSlot(ValueType.STRING);
        Facet facet = this.createFacet();
        slotWithFacet.setAssociatedFacet(facet);
        myMetaSlot.addDirectTemplateSlot(slotWithFacet);
        Slot slot = (Slot)this.createInstance(myMetaSlot);
        slot.setOwnSlotValue(slotWithFacet, "foo");
        Cls cls = this.createCls();
        cls.addDirectTemplateSlot(slot);
        DefaultCls_Test.assertTrue((String)"attached", (!cls.hasDirectlyOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        cls.setTemplateFacetValue(slot, facet, "bar");
        DefaultCls_Test.assertTrue((String)"overridden", (boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        Cls subclass = this.createSubCls(cls);
        DefaultCls_Test.assertTrue((String)"not overridden in subclass", (!subclass.hasDirectlyOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        Cls subSubClass = this.createSubCls(subclass);
        DefaultCls_Test.assertTrue((String)"not overridden in subsubclass", (!subSubClass.hasDirectlyOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        subclass.setTemplateFacetValue(slot, facet, "baz");
        DefaultCls_Test.assertTrue((String)"overridden in subclass", (boolean)subclass.hasDirectlyOverriddenTemplateFacet(slot, facet));
        DefaultCls_Test.assertTrue((String)"not overridden in subsubclass - 2", (!subSubClass.hasDirectlyOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        subSubClass.setTemplateFacetValue(slot, facet, "bat");
        DefaultCls_Test.assertTrue((String)"overridden in subsubclass", (boolean)subSubClass.hasDirectlyOverriddenTemplateFacet(slot, facet));
    }

    public void testHasOverriddenTemplateFacet() {
        Facet facet = this.getFacet(":VALUE-TYPE");
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.ANY);
        cls.addDirectTemplateSlot(slot);
        Cls subclass = this.createSubCls(cls);
        DefaultCls_Test.assertTrue((String)"subclass not overridden", (!subclass.hasOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        cls.setTemplateSlotValueType(slot, ValueType.INTEGER);
        DefaultCls_Test.assertTrue((String)"class overridden", (boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultCls_Test.assertTrue((String)"subclass overridden", (boolean)subclass.hasOverriddenTemplateFacet(slot, facet));
    }
}

