/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.IntegerValidator;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class IntegerListWidget
extends AbstractListWidget {
    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_ADD){

            public void onCreate() {
                IntegerListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getDeleteAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                IntegerListWidget.this.handleRemoveAction(collection);
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){

            public void onView(Object object) {
                IntegerListWidget.this.handleViewAction((Integer)object);
            }
        };
    }

    protected void handleCreateAction() {
        String string = DisplayUtilities.editString(this, "Create Integer Value", null, new IntegerValidator());
        if (string != null) {
            this.addItem(new Integer(string));
        }
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(Integer n) {
        String string = DisplayUtilities.editString(this, "Edit Integer Value", n.toString(), null);
        if (string != null) {
            this.replaceItem(n, new Integer(string));
        }
    }

    public void initialize() {
        Action action = this.getEditAction();
        super.initialize(action);
        this.addButton(action);
        this.addButton(this.getCreateAction());
        this.addButton(this.getDeleteAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = IntegerListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.INTEGER);
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl3;
        }
        return bl;
    }
}

