/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class CheckBoxWidget
extends AbstractSlotWidget {
    private JCheckBox _checkBox;

    public JCheckBox createCheckBox() {
        JCheckBox jCheckBox = ComponentFactory.createCheckBox();
        jCheckBox.setForeground(UIManager.getColor("Label.foreground"));
        return jCheckBox;
    }

    protected JCheckBox getCheckBox() {
        return this._checkBox;
    }

    public Collection getValues() {
        boolean bl = this._checkBox.isSelected();
        return CollectionUtilities.createCollection(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void initialize() {
        this._checkBox = this.createCheckBox();
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckBoxWidget.this.valueChanged();
            }
        });
        this._checkBox.setText(this.getLabel());
        this.add(this._checkBox);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            boolean bl2 = valueType == ValueType.BOOLEAN;
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && !bl3;
        }
        return bl;
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        this._checkBox.setEnabled(bl);
    }

    public void setLabel(String string) {
        super.setLabel(string);
        this._checkBox.setText(string);
    }

    public void setValues(Collection collection) {
        Boolean bl = (Boolean)CollectionUtilities.getFirstItem(collection);
        boolean bl2 = bl == null ? false : bl;
        this._checkBox.setSelected(bl2);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = super.createWidgetConfigurationPanel();
        widgetConfigurationPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return widgetConfigurationPanel;
    }
}

