/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.transaction.Cache;
import edu.stanford.smi.protege.util.transaction.LosslessCache;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionCache<V, R> {
    private Cache<V, R> storage;
    private Map<RemoteSession, Cache<V, R>> sessionCacheMap = new HashMap<RemoteSession, Cache<V, R>>();
    private Map<RemoteSession, Map<V, R>> deferredWrites = new HashMap<RemoteSession, Map<V, R>>();
    private Map<RemoteSession, Set<V>> deferredInvalids = new HashMap<RemoteSession, Set<V>>();

    public TransactionCache(Cache<V, R> cache) {
        this.storage = cache;
    }

    public boolean isCached(V v) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        RemoteSession remoteSession = this.getCurrentSession();
        if (this.isDisabled()) {
            return false;
        }
        if (!this.inTransaction() || transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            return this.storage.isCached(v);
        }
        if (transactionIsolationLevel == TransactionIsolationLevel.READ_COMMITTED) {
            Set<V> set = this.deferredInvalids.get(remoteSession);
            boolean bl = false;
            if (set != null && set.contains(v)) {
                bl = true;
            }
            return !bl && this.storage.isCached(v) || this.getSessionCache().isCached(v);
        }
        return this.getSessionCache().isCached(v);
    }

    public R read(V v) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Cache<V, R> cache = this.getSessionCache();
        if (!this.inTransaction() || transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            return this.storage.readCache(v);
        }
        if (transactionIsolationLevel == TransactionIsolationLevel.READ_COMMITTED) {
            if (cache.isCached(v)) {
                return cache.readCache(v);
            }
            return this.storage.readCache(v);
        }
        return cache.readCache(v);
    }

    public void valueFromStore(V v, R r) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        RemoteSession remoteSession = this.getCurrentSession();
        Cache<V, R> cache = this.getSessionCache();
        if (this.isDisabled()) {
            return;
        }
        if (!this.inTransaction() || transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            this.storage.writeCache(v, r);
        } else if (transactionIsolationLevel == TransactionIsolationLevel.READ_COMMITTED) {
            Set<V> set = this.deferredInvalids.get(remoteSession);
            if (!(cache.isCached(v) || set != null && set.contains(v))) {
                this.storage.writeCache(v, r);
            }
        } else {
            cache.writeCache(v, r);
        }
    }

    public void write(V v, R r) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Cache<V, R> cache = this.getSessionCache();
        RemoteSession remoteSession = this.getCurrentSession();
        if (!this.inTransaction() || transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            this.storage.writeCache(v, r);
        } else {
            Map<R, R> map = this.deferredWrites.get(remoteSession);
            if (map == null) {
                map = new HashMap<V, R>();
                this.deferredWrites.put(remoteSession, map);
            }
            map.put(v, r);
            cache.writeCache(v, r);
            Set<V> set = this.deferredInvalids.get(remoteSession);
            if (set != null) {
                set.remove(v);
            }
        }
    }

    public void invalidate(V v) {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        RemoteSession remoteSession = this.getCurrentSession();
        Cache<V, R> cache = this.getSessionCache();
        if (this.inTransaction() && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
            cache.removeCacheEntry(v);
            Set<V> set = this.deferredInvalids.get(remoteSession);
            if (set == null) {
                set = new HashSet<V>();
                this.deferredInvalids.put(remoteSession, set);
            }
            set.add(v);
        } else {
            this.storage.removeCacheEntry(v);
        }
    }

    public void commitTransaction() {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        if (!this.inTransaction() && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
            Object object;
            Object object2;
            Object object3;
            RemoteSession remoteSession = this.getCurrentSession();
            Map<V, R> map = this.deferredWrites.get(this.getCurrentSession());
            this.deferredWrites.put(remoteSession, null);
            if (map != null) {
                object3 = map.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    object = object2.getKey();
                    Object v = object2.getValue();
                    this.storage.writeCache(object, v);
                }
            }
            if ((object3 = this.deferredInvalids.get(this.getCurrentSession())) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    this.storage.removeCacheEntry(object);
                }
            }
            this.sessionCacheMap.remove(remoteSession);
        }
    }

    public void rollbackTransaction() {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        if (!this.inTransaction() && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
            RemoteSession remoteSession = this.getCurrentSession();
            this.deferredWrites.remove(remoteSession);
            this.sessionCacheMap.remove(remoteSession);
        }
    }

    private RemoteSession getCurrentSession() {
        return ServerFrameStore.getCurrentSession();
    }

    private Cache<V, R> getSessionCache() {
        if (!this.inTransaction()) {
            throw new UnsupportedOperationException("Session cache only valid during a transaction");
        }
        RemoteSession remoteSession = this.getCurrentSession();
        Cache<V, R> cache = this.sessionCacheMap.get(remoteSession);
        if (cache == null) {
            cache = this.createSessionCache(remoteSession);
            this.sessionCacheMap.put(remoteSession, cache);
        }
        return cache;
    }

    public abstract boolean inTransaction();

    public abstract TransactionIsolationLevel getTransactionIsolationLevel();

    public abstract boolean isDisabled();

    public abstract LosslessCache<V, R> createSessionCache(RemoteSession var1);
}

