/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.util.Tree;

public class Tree_Test
extends SimpleTestCase {
    public void testCreate() {
        Object o = new Object();
        Tree<Object> tree = new Tree<Object>(o);
        Tree_Test.assertEquals((Object)o, (Object)tree.getRoot());
        tree.setRoot(null);
        Tree_Test.assertNull((Object)tree.getRoot());
        tree.setRoot(o);
        Tree_Test.assertEquals((Object)o, (Object)tree.getRoot());
    }

    public void testAddNode() {
        String foo = "foo";
        String bar = "bar";
        String baz = "baz";
        String bam = "bam";
        Tree<String> tree = new Tree<String>(foo);
        tree.addChild(foo, bar);
        tree.addChild(bar, baz);
        tree.addChild(foo, bam);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, bam), tree.getChildren(foo));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, bam, baz), tree.getDescendents(foo));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(baz), tree.getDescendents(bar));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(), tree.getDescendents(bam));
    }

    public void testRemoveNode() {
        String foo = "foo";
        String bar = "bar";
        String baz = "baz";
        Tree<String> tree = new Tree<String>(foo);
        tree.addChild(foo, bar);
        tree.addChild(bar, baz);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, baz), tree.getDescendents(foo));
        tree.removeChild(bar, baz);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar), tree.getDescendents(foo));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(), tree.getChildren(bar));
        tree.addChild(foo, baz);
        String all = "all";
        tree.addChild(baz, all);
        tree.addChild(bar, all);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, baz, all), tree.getDescendents(foo));
        tree.removeChild(baz, all);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, baz, all), tree.getDescendents(foo));
        tree.removeChild(bar, all);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(bar, baz), tree.getDescendents(foo));
    }
}

