/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.util.Log;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProtegeJob
implements Localizable,
Serializable {
    private static transient Logger log = Log.getLogger(ProtegeJob.class);
    private transient KnowledgeBase kb;
    private transient RemoteClientFrameStore clientFrameStore = null;

    public ProtegeJob(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        FrameStore frameStore = defaultKnowledgeBase.getTerminalFrameStore();
        if (frameStore instanceof RemoteClientFrameStore) {
            this.clientFrameStore = (RemoteClientFrameStore)frameStore;
        }
    }

    public void fixLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != (classLoader = this.getClass().getClassLoader())) {
            if (log.isLoggable(Level.FINEST)) {
                Log.getLogger().finest("Changing loader from " + classLoader2 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public Object execute() throws ProtegeException {
        if (this.clientFrameStore == null) {
            return this.run();
        }
        return this.clientFrameStore.executeProtegeJob(this);
    }

    public abstract Object run() throws ProtegeException;

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public ProjectInstance getMetaProjectInstance() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = Server.getInstance().getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(remoteSession);
        return serverFrameStore.getMetaProjectInstance();
    }

    public void localize(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }
}

