/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheMap_Test
extends SimpleTestCase {
    private static final Logger log = Log.getLogger(CacheMap_Test.class);

    public void testSizeLimit() {
        int limit = 15;
        int multiplier = 10;
        CacheMap<String, Integer> map = new CacheMap<String, Integer>(limit);
        HashSet<String> keep = new HashSet<String>();
        for (int i = 0; i < multiplier * limit; ++i) {
            String key = this.makeKey(i);
            map.put(key, i);
            keep.add(key);
            if (log.isLoggable(Level.FINE)) {
                log.fine("After adding " + (i + 1) + " entries the map size is " + map.size());
            }
            if (i > limit) {
                CacheMap_Test.assertTrue((map.size() <= limit && map.size() >= 4 * limit / 5 ? 1 : 0) != 0);
            }
            int counter = 0;
            for (String key2 : map.keySet()) {
                ++counter;
                CacheMap_Test.assertTrue((boolean)key2.equals(this.makeKey((Integer)map.get(key2))));
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("found " + key2 + " -> " + map.get(key2));
            }
            if (i <= limit) continue;
            CacheMap_Test.assertTrue((counter <= limit && counter >= 4 * limit / 5 ? 1 : 0) != 0);
        }
    }

    private String makeKey(int i) {
        return "Entry at " + i;
    }
}

