/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.Iterator;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<X, Y>
extends WeakHashMap<X, Y> {
    private static final int INIT_SIZE = 10007;
    private int maxSize;

    public CacheMap(int n) {
        this.maxSize = n;
    }

    public CacheMap() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public Y put(X x, Y y) {
        Y y2 = super.put(x, y);
        this.fixSize();
        return y2;
    }

    private void fixSize() {
        if (this.size() > this.maxSize) {
            Log.getLogger().info("removing elements from call cache");
            int n = 0;
            int n2 = this.maxSize / 5;
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext() && n++ < n2) {
                iterator.next();
                iterator.remove();
            }
        }
    }
}

