/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractFormatter
extends Formatter {
    private static final String lineSeparator = SystemUtilities.getLineSeparator();
    private static final DateFormat dateFormat = new StandardDateFormat();

    protected String format(LogRecord logRecord, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(AbstractFormatter.getDateString());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        Level level = logRecord.getLevel();
        stringBuffer.append(level.toString());
        stringBuffer.append(": ");
        stringBuffer.append(logRecord.getMessage());
        Throwable throwable = logRecord.getThrown();
        if (throwable == null) {
            String string2 = logRecord.getSourceClassName();
            if (bl2 && string2 != null) {
                stringBuffer.append(" -- ");
                stringBuffer.append(StringUtilities.getShortClassName(string2));
                stringBuffer.append(".");
                stringBuffer.append(logRecord.getSourceMethodName());
                stringBuffer.append("(");
                Object[] objectArray = logRecord.getParameters();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(AbstractFormatter.toString(objectArray[i]));
                    }
                }
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(" -- ");
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter.getBuffer());
        }
        stringBuffer.append(lineSeparator);
        return stringBuffer.toString();
    }

    protected static String getLineSeparator() {
        return lineSeparator;
    }

    protected static String getDateString() {
        return dateFormat.format(new Date());
    }

    protected static String toString(Object object) {
        String string;
        try {
            string = object == null ? null : (object instanceof Collection ? "[" + CollectionUtilities.toString((Collection)object) + "]" : (object.getClass().isArray() ? "{" + CollectionUtilities.toString(Arrays.asList((Object[])object)) + "}" : (object instanceof Frame ? ((Frame)object).getBrowserText() : object.toString())));
        }
        catch (Exception exception) {
            string = "<<toString() exception>>";
        }
        return string;
    }
}

