/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.MyCardPanel;
import edu.stanford.smi.protege.ui.MyJTabbedPane;
import edu.stanford.smi.protege.ui.TabbedPaneInterface;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProjectViewDispatcher;
import edu.stanford.smi.protege.util.ProjectViewEvent;
import edu.stanford.smi.protege.util.ProjectViewListener;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectView
extends JComponent {
    private static Logger log = Log.getLogger(ProjectView.class);
    private ListenerCollection projectViewListeners = new ListenerList(new ProjectViewDispatcher());
    private Project _project;
    private TabbedPaneInterface _viewHolder;
    private Collection _currentClsPath;
    private Collection _currentInstances;
    private Collection _detachedTabs = new HashSet();

    public ProjectView(Project project) {
        if (log.isLoggable(Level.FINE)) {
            this.addProjectViewListener(new ProjectViewListener(){
                {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Constructing ProjectViewListener");
                    }
                }

                public void tabAdded(ProjectViewEvent projectViewEvent) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Tab added event found " + projectViewEvent + " with widget " + projectViewEvent.getWidget());
                    }
                }

                public void saved(ProjectViewEvent projectViewEvent) {
                }

                public void closed(ProjectViewEvent projectViewEvent) {
                }
            });
        }
        this._project = project;
        this.setLayout(new BorderLayout());
        this.add("Center", this.createTabbedPane());
        if (!project.isMultiUserClient()) {
            project.getKnowledgeBase().setUndoEnabled(project.isUndoOptionEnabled());
        }
    }

    public TabWidget addTab(WidgetDescriptor widgetDescriptor) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding tab " + widgetDescriptor);
        }
        TabWidget tabWidget = WidgetUtilities.createTabWidget(widgetDescriptor, this._project);
        this.addTab(tabWidget);
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.addTab.ordinal(), tabWidget);
        return tabWidget;
    }

    private void addTab(TabWidget tabWidget) {
        this.addTab(tabWidget, -1);
    }

    private void addTab(String string, Icon icon, JComponent jComponent, String string2, int n) {
        if (n < 0) {
            this._viewHolder.addTab(string, icon, jComponent, string2);
        } else {
            this._viewHolder.insertTab(string, icon, jComponent, string2, n);
        }
    }

    private boolean isSuitable(TabWidget tabWidget) {
        String string = tabWidget.getClass().getName();
        return WidgetUtilities.isSuitableTab(string, this._project, new ArrayList());
    }

    private void addTab(final TabWidget tabWidget, int n) {
        if (this.isSuitable(tabWidget)) {
            JComponent jComponent = (JComponent)((Object)tabWidget);
            Icon icon = tabWidget.getIcon();
            String string = tabWidget.getLabel();
            String string2 = tabWidget.getShortDescription();
            this.addTab(string, icon, jComponent, string2, n);
            tabWidget.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    ArrayList arrayList = new ArrayList(tabWidget.getSelection());
                    if (!arrayList.isEmpty() && arrayList.get(0) instanceof Collection) {
                        arrayList.remove(0);
                    }
                    ProjectView.this.setCurrentClsPath(arrayList);
                    ProjectView.this.setCurrentInstances(tabWidget.getSelectedInstances());
                }
            });
        }
    }

    public boolean canClose() {
        boolean bl = true;
        Iterator iterator = this.getTabs().iterator();
        while (bl && iterator.hasNext()) {
            TabWidget tabWidget = (TabWidget)iterator.next();
            bl = tabWidget.canClose();
        }
        return bl;
    }

    public boolean attemptSave() {
        boolean bl = true;
        Iterator iterator = this.getTabs().iterator();
        while (bl && iterator.hasNext()) {
            TabWidget tabWidget = (TabWidget)iterator.next();
            bl = tabWidget.canSave();
        }
        if (bl) {
            this.save();
        }
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.save.ordinal());
        return bl;
    }

    public void close() {
        for (TabWidget tabWidget : this.getTabs()) {
            tabWidget.close();
        }
        this._project = null;
        this.projectViewListeners.postEvent(this, ProjectViewEvent.Type.close.ordinal());
    }

    private JComponent createTabbedPane() {
        this._viewHolder = SystemUtilities.showAlphaFeatures() ? new MyCardPanel() : new MyJTabbedPane();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Added view holder " + this._viewHolder + " for project " + this);
        }
        this._viewHolder.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("project view tabbed pane received change event " + changeEvent);
                }
                if (ProjectView.this.isAutosynchronizingClsTrees()) {
                    ProjectView.this.synchronizeClsTree();
                    ProjectView.this.synchronizeInstances();
                }
            }
        });
        for (WidgetDescriptor widgetDescriptor : this._project.getTabWidgetDescriptors()) {
            if (!widgetDescriptor.isVisible()) continue;
            try {
                this.addTab(widgetDescriptor);
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.WARNING, "Errors at adding tab " + widgetDescriptor.getWidgetClassName(), throwable);
            }
        }
        if (this._viewHolder.getComponentCount() > 0) {
            this._viewHolder.setSelectedIndex(0);
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        return (JComponent)((Object)this._viewHolder);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._viewHolder.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._viewHolder.removeChangeListener(changeListener);
    }

    public void addProjectViewListener(ProjectViewListener projectViewListener) {
        this.projectViewListeners.add(this, projectViewListener);
    }

    public void removeProjectViewListener(ProjectViewListener projectViewListener) {
        this.projectViewListeners.remove(this, projectViewListener);
    }

    public Project getProject() {
        return this._project;
    }

    public TabWidget getTab(String string) {
        return this.getTabByClassName(string);
    }

    public TabWidget getTabByClassName(String string) {
        TabWidget tabWidget = null;
        Component[] componentArray = this._viewHolder.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.getClass().getName().equals(string)) continue;
            tabWidget = (TabWidget)((Object)component);
            break;
        }
        return tabWidget;
    }

    public Collection getTabs() {
        return Arrays.asList(this._viewHolder.getComponents());
    }

    public void setSelectedTab(TabWidget tabWidget) {
        this._viewHolder.setSelectedComponent((Component)((Object)tabWidget));
    }

    public TabWidget getSelectedTab() {
        return (TabWidget)((Object)this._viewHolder.getSelectedComponent());
    }

    public JTabbedPane getTabbedPane() {
        return this._viewHolder instanceof JTabbedPane ? (JTabbedPane)((Object)this._viewHolder) : null;
    }

    public void reload(boolean bl) {
        if (bl) {
            this.reloadAll();
        } else {
            this.reloadPartial();
        }
    }

    private void reloadPartial() {
        this.closeDetachedDisabledTabs();
        this.synchronizeTabbedPane();
    }

    private void synchronizeTabbedPane() {
        this.removeDisabledTabs();
        this.addEnabledTabs();
        this.reorderTabs();
    }

    private void removeDisabledTabs() {
        for (TabWidget tabWidget : this.getTabs()) {
            if (ProjectView.isEnabled(tabWidget)) continue;
            this._viewHolder.remove((Component)((Object)tabWidget));
            tabWidget.dispose();
        }
    }

    private void addEnabledTabs() {
        for (WidgetDescriptor widgetDescriptor : this._project.getTabWidgetDescriptors()) {
            String string;
            if (!widgetDescriptor.isVisible() || this.getTab(string = widgetDescriptor.getWidgetClassName()) != null) continue;
            this.addTab(widgetDescriptor);
        }
    }

    private void reorderTabs() {
        int n = 0;
        for (WidgetDescriptor widgetDescriptor : this._project.getTabWidgetDescriptors()) {
            if (!widgetDescriptor.isVisible()) continue;
            int n2 = this.getTabIndex(widgetDescriptor);
            if (n2 != n && n2 != -1) {
                TabWidget tabWidget = (TabWidget)((Object)this._viewHolder.getComponent(n2));
                this.addTab(tabWidget, n);
            }
            ++n;
        }
    }

    private int getTabIndex(WidgetDescriptor widgetDescriptor) {
        return this._viewHolder.indexOfComponent((Component)((Object)this.getTab(widgetDescriptor.getWidgetClassName())));
    }

    public void reloadAll() {
        TabWidget tabWidget;
        TabWidget tabWidget2 = this.getSelectedTab();
        String string = null;
        if (tabWidget2 != null) {
            string = tabWidget2.getDescriptor().getWidgetClassName();
        }
        this.closeDetachedTabs();
        if (this._viewHolder != null) {
            ComponentUtilities.dispose((Component)((Object)this._viewHolder));
        }
        this.removeAll();
        this._project.clearCachedWidgets();
        this.add(this.createTabbedPane());
        if (string != null && (tabWidget = this.getTabByClassName(string)) != null) {
            this.setSelectedTab(tabWidget);
        }
        this.revalidate();
        this.repaint();
    }

    private void closeDetachedTabs() {
        Iterator iterator = this._detachedTabs.iterator();
        while (iterator.hasNext()) {
            TabWidget tabWidget = (TabWidget)iterator.next();
            iterator.remove();
            ProjectView.closeDetachedTab(tabWidget);
        }
    }

    private static void closeDetachedTab(TabWidget tabWidget) {
        Component component = (Component)((Object)tabWidget);
        JFrame jFrame = (JFrame)SwingUtilities.getRoot(component);
        jFrame.dispose();
    }

    private void closeDetachedDisabledTabs() {
        Iterator iterator = this._detachedTabs.iterator();
        while (iterator.hasNext()) {
            TabWidget tabWidget = (TabWidget)iterator.next();
            if (ProjectView.isEnabled(tabWidget)) continue;
            iterator.remove();
            ProjectView.closeDetachedTab(tabWidget);
        }
    }

    private static boolean isEnabled(TabWidget tabWidget) {
        return tabWidget.getDescriptor().isVisible();
    }

    private void save() {
        for (TabWidget tabWidget : this.getTabs()) {
            tabWidget.save();
        }
    }

    public String toString() {
        return "ProjectView";
    }

    public void closeCurrentView() {
        int n = this._viewHolder.getSelectedIndex();
        Component component = this._viewHolder.getSelectedComponent();
        this._viewHolder.removeTabAt(n);
        TabWidget tabWidget = (TabWidget)((Object)component);
        tabWidget.getDescriptor().setVisible(false);
        ComponentUtilities.dispose(component);
    }

    public void detachCurrentView() {
        JComponent jComponent = (JComponent)this._viewHolder.getSelectedComponent();
        int n = this._viewHolder.getSelectedIndex();
        this._viewHolder.removeTabAt(n);
        final JFrame jFrame = ComponentFactory.createFrame();
        jComponent.setPreferredSize(jComponent.getSize());
        jFrame.getContentPane().add(jComponent);
        jFrame.pack();
        String string = ((TabWidget)((Object)jComponent)).getLabel() + " Tab - " + Text.getProgramName();
        jFrame.setTitle(string);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Component component = jFrame.getContentPane().getComponent(0);
                ProjectView.this.reattachTab(component);
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.setVisible(true);
        this._detachedTabs.add(jComponent);
    }

    private void reattachTab(Component component) {
        if (this._project == null) {
            return;
        }
        int n = this.getInsertionPoint(component);
        this.addTab((TabWidget)((Object)component), n);
        this._viewHolder.setSelectedIndex(n);
        this._detachedTabs.remove(component);
    }

    private int getInsertionPoint(Component component) {
        WidgetDescriptor widgetDescriptor;
        String string;
        String string2 = component.getClass().getName();
        int n = 0;
        Iterator iterator = this._project.getTabWidgetDescriptors().iterator();
        while (iterator.hasNext() && n < this._viewHolder.getComponentCount() && !(string = (widgetDescriptor = (WidgetDescriptor)iterator.next()).getWidgetClassName()).equals(string2)) {
            if (!string.equals(this._viewHolder.getComponent(n).getClass().getName())) continue;
            ++n;
        }
        return n;
    }

    public void setAutosynchronizeClsTrees(boolean bl) {
        ApplicationProperties.setAutosynchronizingClsTrees(bl);
        this.synchronizeClsTree();
    }

    public boolean isAutosynchronizingClsTrees() {
        return ApplicationProperties.isAutosynchronizingClsTrees();
    }

    private void setCurrentClsPath(Collection collection) {
        this._currentClsPath = new ArrayList(collection);
    }

    private void setCurrentInstances(Collection collection) {
        this._currentInstances = collection == null ? null : new ArrayList(collection);
    }

    public void synchronizeClsTree() {
        TabWidget tabWidget;
        if (this._currentClsPath != null && (tabWidget = (TabWidget)((Object)this._viewHolder.getSelectedComponent())) != null) {
            tabWidget.synchronizeClsTree(this._currentClsPath);
        }
    }

    public void synchronizeInstances() {
        TabWidget tabWidget;
        if (this._currentInstances != null && (tabWidget = (TabWidget)((Object)this._viewHolder.getSelectedComponent())) != null) {
            tabWidget.synchronizeToInstances(this._currentInstances);
        }
    }
}

