/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.storage.clips.ParseException;
import edu.stanford.smi.protege.storage.clips.ParserConstants;
import edu.stanford.smi.protege.storage.clips.ParserTokenManager;
import edu.stanford.smi.protege.storage.clips.SimpleCharStream;
import edu.stanford.smi.protege.storage.clips.Token;
import edu.stanford.smi.protege.storage.clips.TokenMgrError;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public final class Parser
implements ParserConstants {
    private KnowledgeBase itsKB;
    private Collection _itsErrors;
    private boolean isInclude;
    private Cls itsDefaultMetaCls;
    private Map itsInverseSlotMap = new HashMap();
    private Map itsSuperslotsMap = new HashMap();
    private Collection itsUndefinedClses = new HashSet();
    private Collection itsUndefinedInstances = new HashSet();
    private String state;
    private static final String LOADING_CLASSES = "loading classes";
    private static final String LOADING_INSTANCES = "loading instances";
    private static final String UNDEFINED_CLASS = ":UNDEFINED";
    private int nClses;
    private static int MIN_TRACE_COUNT = 5000;
    private static int TRACE_COUNT_DELTA = 1000;
    private static int MIN_CLASS_TRACE_COUNT = MIN_TRACE_COUNT;
    private static int MIN_INSTANCE_TRACE_COUNT = MIN_TRACE_COUNT;
    private static int CLASS_TRACE_COUNT_DELTA = TRACE_COUNT_DELTA;
    private static int INSTANCE_TRACE_COUNT_DELTA = TRACE_COUNT_DELTA;
    private int nInstances;
    private int nSetTypeInstances;
    private static final String VARIABLE = "?VARIABLE";
    private Map clsToSlotToValueType = new HashMap();
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[43];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public String toString() {
        return "ClipsParser";
    }

    private void recordError(String string) {
        this.recordError(string, null);
    }

    private void recordError(String string, Throwable throwable) {
        Object object = throwable == null ? string : throwable;
        this._itsErrors.add(object);
        Log.getLogger().log(Level.SEVERE, string, throwable);
    }

    public void loadClses(KnowledgeBase knowledgeBase, boolean bl, Collection collection) {
        try {
            this.state = LOADING_CLASSES;
            this.itsKB = knowledgeBase;
            this.itsDefaultMetaCls = knowledgeBase.getCls(":STANDARD-CLASS");
            this.isInclude = bl;
            this._itsErrors = collection;
            this.parseOntology();
            this.connectInverseSlots();
            this.connectSuperslots();
            this.checkUndefinedClasses();
        }
        catch (Exception exception) {
            this.recordError("Error parsing classes", exception);
        }
    }

    private Cls getUndefinedSuperclass() {
        Cls cls = this.itsKB.getCls(UNDEFINED_CLASS);
        if (cls == null) {
            Collection collection = CollectionUtilities.createCollection(this.itsKB.getRootCls());
            cls = this.itsKB.createCls(UNDEFINED_CLASS, collection);
        }
        return cls;
    }

    private void checkUndefinedClasses() {
        if (!this.itsUndefinedClses.isEmpty()) {
            Cls cls = this.itsKB.getDefaultClsMetaCls();
            Cls cls2 = this.getUndefinedSuperclass();
            for (Cls cls3 : this.itsUndefinedClses) {
                this.recordError("Undefined class: " + cls3.getName() + " found while " + this.state);
                cls3.addDirectSuperclass(cls2);
                cls3.setDirectType(cls);
            }
            this.itsUndefinedClses.clear();
        }
    }

    private void checkUndefinedInstances() {
        if (!this.itsUndefinedInstances.isEmpty()) {
            Cls cls = this.getUndefinedSuperclass();
            for (Instance instance : this.itsUndefinedInstances) {
                this.recordError("Undefined instance: " + instance.getName());
                instance.setDirectType(cls);
            }
        }
    }

    public void loadInstances(KnowledgeBase knowledgeBase, boolean bl, Collection collection) {
        try {
            this.state = LOADING_INSTANCES;
            this.itsKB = knowledgeBase;
            this.isInclude = bl;
            this._itsErrors = collection;
            this.parseKnowledgeBase();
            this.checkUndefinedClasses();
            this.checkUndefinedInstances();
        }
        catch (Exception exception) {
            this.recordError("Error loading instances", exception);
        }
    }

    private void handleException(Throwable throwable) {
        Token token;
        this.recordError("Parsing error", throwable);
        do {
            token = this.getNextToken();
        } while (token.kind != 0 && token.kind != 12 && this.getToken((int)1).kind != 11);
    }

    private void nameConflictError(String string, String string2, Frame frame) {
        String string3 = string + " is both a " + string2 + " and a " + this.getTypeName(frame);
        this.recordError(string3, null);
    }

    private String getTypeName(Frame frame) {
        String string = frame instanceof Cls ? "class" : (frame instanceof Slot ? "slot" : (frame instanceof Facet ? "facet" : (frame instanceof SimpleInstance ? "simple instance" : frame.getClass().getName())));
        return string;
    }

    private Cls getCls(String string, String string2, Collection collection, boolean bl) {
        Cls cls;
        Frame frame;
        if (string.equals(":CLIPS_TOP_LEVEL_SLOT_CLASS")) {
            return null;
        }
        if (string.equals("USER")) {
            string = this.itsKB.getRootCls().getName();
        }
        if ((frame = this.itsKB.getFrame(string)) == null) {
            cls = this.itsKB.createCls(string, collection, this.itsDefaultMetaCls, false);
            if (++this.nClses % CLASS_TRACE_COUNT_DELTA == 0 && this.nClses >= MIN_CLASS_TRACE_COUNT) {
                Log.getLogger().info("Loaded " + this.nClses + " classes: " + string);
            }
            if (string2 != null) {
                cls.setDocumentation(string2);
            }
            if (!bl) {
                this.itsUndefinedClses.add(cls);
            }
        } else if (frame instanceof Cls) {
            cls = (Cls)frame;
            if (bl) {
                boolean bl2 = this.itsUndefinedClses.remove(cls);
                if (bl2) {
                    if (string2 != null) {
                        cls.setDocumentation(string2);
                    }
                    if (!collection.isEmpty()) {
                        this.addDirectSuperclasses(cls, collection);
                    }
                } else {
                    this.recordError("Duplicate definition of class " + string + " was ignored");
                }
            }
        } else if (frame instanceof SimpleInstance && ((Instance)frame).getDirectType() == null) {
            this.itsKB.setDirectType((Instance)frame, this.itsKB.getDefaultClsMetaCls());
            cls = this.itsKB.getCls(string);
            for (Cls cls2 : collection) {
                cls.addDirectSuperclass(cls2);
            }
        } else {
            this.nameConflictError(string, "class", frame);
            cls = this.getCls(string + "_", string2, collection, bl);
        }
        if (this.isInclude) {
            cls.setIncluded(true);
        }
        return cls;
    }

    private void addDirectSuperclasses(Cls cls, Collection collection) {
        for (Cls cls2 : collection) {
            cls.addDirectSuperclass(cls2);
        }
    }

    private boolean hasSlot(String string) {
        return this.itsKB.containsFrame(string);
    }

    private Slot getExistingSlot(String string) {
        Slot slot;
        Frame frame = this.itsKB.getFrame(string);
        if (frame instanceof Slot) {
            slot = (Slot)frame;
        } else {
            this.recordError("non-existent slot: " + string);
            slot = this.getSlot(string);
        }
        return slot;
    }

    private Slot getSlot(String string) {
        Slot slot;
        Frame frame = this.itsKB.getFrame(string);
        if (frame == null) {
            slot = this.itsKB.createSlot(string, this.itsKB.getDefaultSlotMetaCls(), false);
        } else if (frame instanceof Slot) {
            slot = (Slot)frame;
        } else {
            this.nameConflictError(string, "slot", frame);
            slot = this.getSlot(string + "_");
        }
        if (this.isInclude) {
            slot.setIncluded(true);
        }
        return slot;
    }

    private Instance getInstance(String string, Collection collection) {
        Instance instance = this.itsKB.getInstance(string);
        if (instance == null) {
            Collection collection2 = collection == null ? Collections.EMPTY_LIST : collection;
            instance = this.itsKB.createInstance(null, string, collection2, false);
            if (++this.nInstances % INSTANCE_TRACE_COUNT_DELTA == 0 && this.nInstances >= MIN_INSTANCE_TRACE_COUNT) {
                Log.getLogger().info("Loaded " + this.nInstances + " instances: " + string);
            }
            if (collection == null) {
                this.itsUndefinedInstances.add(instance);
            }
            if (instance instanceof Cls) {
                this.itsUndefinedClses.add(instance);
            }
        } else if (collection != null && !CollectionUtilities.equalsSet(instance.getDirectTypes(), collection)) {
            if (Parser.isTypeMismatch(instance, collection)) {
                this.recordError("type mismatch: " + instance + " cannot become an instance of " + collection);
            }
            Instance instance2 = instance;
            instance = instance.setDirectTypes(collection);
            if (++this.nSetTypeInstances % INSTANCE_TRACE_COUNT_DELTA == 0 && this.nSetTypeInstances >= MIN_INSTANCE_TRACE_COUNT) {
                Log.getLogger().info("Set type on " + this.nSetTypeInstances + " instances: " + string);
            }
            this.itsUndefinedInstances.remove(instance2);
        }
        if (this.isInclude) {
            instance.setIncluded(true);
        }
        return instance;
    }

    private static boolean isTypeMismatch(Instance instance, Collection collection) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        boolean bl = instance instanceof Cls ? !cls.isClsMetaCls() : (instance instanceof Slot ? !cls.isSlotMetaCls() : (instance instanceof Facet ? !cls.isFacetMetaCls() : false));
        return bl;
    }

    private void checkBooleanAndSetValues(Cls cls, Slot slot, Collection collection) {
        if (this.areBooleanValues(collection)) {
            if (cls == null) {
                Collection collection2 = slot.getDefaultValues();
                collection2 = this.convertToBooleanDefaults(collection2);
                slot.setValueType(ValueType.BOOLEAN);
                slot.setDefaultValues(collection2);
            } else {
                Collection collection3 = cls.getTemplateSlotDefaultValues(slot);
                collection3 = this.convertToBooleanDefaults(collection3);
                cls.setTemplateSlotValueType(slot, ValueType.BOOLEAN);
                cls.setTemplateSlotDefaultValues(slot, collection3);
            }
        } else if (cls == null) {
            slot.setAllowedValues(collection);
        } else {
            cls.setTemplateSlotAllowedValues(slot, collection);
        }
    }

    private boolean areBooleanValues(Collection collection) {
        String string;
        Iterator iterator;
        String string2;
        boolean bl = false;
        if (collection.size() == 2 && Parser.isBooleanValue(string2 = (String)(iterator = collection.iterator()).next()) && Parser.isBooleanValue(string = (String)iterator.next())) {
            bl = !string2.equalsIgnoreCase(string);
        }
        return bl;
    }

    private Collection convertToBooleanDefaults(Collection collection) {
        ArrayList<Boolean> arrayList;
        if (collection.isEmpty()) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Boolean>();
            for (Object e : collection) {
                arrayList.add(Boolean.valueOf(e.toString()));
            }
        }
        return arrayList;
    }

    private static boolean isBooleanValue(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
    }

    private void checkedValueAdd(Collection collection, ValueType valueType, Object object) {
        try {
            this.tryCheckedValueAdd(collection, valueType, object);
        }
        catch (Exception exception) {
            this.recordError("invalid object type", exception);
        }
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    private void tryCheckedValueAdd(Collection collection, ValueType valueType, Object object) {
        Object object2;
        if (valueType == ValueType.CLS && object instanceof String) {
            object = this.getCls((String)object, null, Collections.EMPTY_LIST, false);
        } else if (valueType == ValueType.INSTANCE && object instanceof String) {
            object = this.getInstance((String)object, null);
        } else if (valueType == ValueType.FLOAT) {
            object = this.toFloat((String)object);
        } else if (valueType == ValueType.INTEGER) {
            object = this.toInteger((String)object);
        } else if (valueType == ValueType.BOOLEAN) {
            object = new Boolean((String)object);
        } else if (valueType == ValueType.ANY && object instanceof String && (object2 = CollectionUtilities.getFirstItem(collection)) != null && Parser.appearsToBeValueType(collection)) {
            object = this.getInstance((String)object, null);
        }
        if (object == null) {
            throw new IllegalArgumentException("null value");
        }
        collection.add(object);
    }

    private static boolean appearsToBeValueType(Collection collection) {
        boolean bl = false;
        Object object = CollectionUtilities.getFirstItem(collection);
        if (object != null) {
            bl = object.equals(ValueType.INSTANCE.toString()) || object.equals(ValueType.CLS.toString());
        }
        return bl;
    }

    Slot createTemplateSlot(String string, boolean bl, Cls cls, boolean bl2) {
        Slot slot = this.getSlot(string);
        if (cls != null && !cls.hasTemplateSlot(slot)) {
            cls.addDirectTemplateSlot(slot);
        }
        if (!bl) {
            if (bl2) {
                slot.setAllowsMultipleValues(true);
            } else {
                cls.setTemplateSlotAllowsMultipleValues(slot, true);
            }
        }
        return slot;
    }

    ValueType getSlotType(Cls cls, Slot slot) {
        return cls == null ? slot.getValueType() : cls.getTemplateSlotValueType(slot);
    }

    private Integer toInteger(String string) {
        Integer n = null;
        try {
            if (!string.equals(VARIABLE)) {
                n = new Integer(string);
            }
        }
        catch (Exception exception) {
            try {
                Float f = new Float(string);
                n = new Integer(f.intValue());
            }
            catch (Exception exception2) {
                this.recordError("Invalid integer: " + string, exception2);
                n = null;
            }
        }
        return n;
    }

    private Float toFloat(String string) {
        Float f = null;
        try {
            if (!string.equals(VARIABLE)) {
                f = new Float(string);
            }
        }
        catch (Exception exception) {
            this.recordError("Invalid floating point number: " + string, exception);
            f = null;
        }
        return f;
    }

    private void addInverseSlotPair(Slot slot, Slot slot2) {
        Slot slot3 = (Slot)this.itsInverseSlotMap.get(slot2);
        if (slot3 == null) {
            this.itsInverseSlotMap.put(slot, slot2);
        } else if (!Parser.equals(slot3, slot)) {
            this.recordError("mismatched inverse slots: " + slot + ", " + slot2 + ", " + slot3);
        }
    }

    private void addSuperslots(Slot slot, Collection collection) {
        this.itsSuperslotsMap.put(slot, collection);
    }

    private void connectInverseSlots() {
        for (Slot slot : this.itsInverseSlotMap.keySet()) {
            Slot slot2 = (Slot)this.itsInverseSlotMap.get(slot);
            slot.setInverseSlot(slot2);
        }
    }

    private void connectSuperslots() {
        for (Slot slot : this.itsSuperslotsMap.keySet()) {
            Collection collection = (Collection)this.itsSuperslotsMap.get(slot);
            this.connectSuperslots(slot, collection);
        }
    }

    private void connectSuperslots(Slot slot, Collection collection) {
        for (String string : collection) {
            Slot slot2 = this.itsKB.getSlot(string);
            slot.addDirectSuperslot(slot2);
        }
    }

    private Facet getOrCreateFacet(String string) {
        Facet facet = this.itsKB.getFacet(string);
        if (facet == null) {
            facet = this.itsKB.createFacet(string, this.itsKB.getDefaultFacetMetaCls(), false);
        }
        return facet;
    }

    private ValueType getOwnSlotValueType(Instance instance, Collection collection, Slot slot) {
        ValueType valueType;
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            HashMap<Slot, ValueType> hashMap = (HashMap<Slot, ValueType>)this.clsToSlotToValueType.get(cls);
            if (hashMap == null) {
                hashMap = new HashMap<Slot, ValueType>();
                this.clsToSlotToValueType.put(cls, hashMap);
            }
            if ((valueType = (ValueType)hashMap.get(slot)) == null) {
                valueType = instance.getOwnSlotValueType(slot);
                hashMap.put(slot, valueType);
            }
        } else {
            valueType = instance.getOwnSlotValueType(slot);
        }
        return valueType;
    }

    public final void accessFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(17);
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedClassesValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(18);
        List list = this.clsesList();
        if (cls == null) {
            slot.setAllowedClses(list);
        } else {
            cls.setTemplateSlotAllowedClses(slot, list);
        }
    }

    public final void allowedConstantValueDescription(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 19: {
                this.allowedFloatsValueDescription(cls, slot);
                break;
            }
            case 21: {
                this.allowedIntegersValueDescription(cls, slot);
                break;
            }
            case 24: {
                this.allowedSymbolsValueDescription(cls, slot);
                break;
            }
            case 23: {
                this.allowedStringsValueDescription(cls, slot);
                break;
            }
            case 25: {
                this.allowedValuesValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedConstantValueDescriptionExtension(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 18: {
                this.allowedClassesValueDescription(cls, slot);
                break;
            }
            case 20: {
                this.allowedGrammarValueDescription(cls, slot);
                break;
            }
            case 22: {
                this.allowedParentsValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedFloatsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(19);
        block3: while (true) {
            String string = this.symbol();
            arrayList.add(string);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
    }

    public final void allowedGrammarValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(20);
        this.string();
        switch (this.jj_nt.kind) {
            case 77: {
                this.string();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final void allowedIntegersValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(21);
        block3: while (true) {
            String string = this.symbol();
            arrayList.add(string);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
    }

    public final void allowedParentsValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(22);
        List list = this.clsesList();
        if (cls == null) {
            slot.setAllowedParents(list);
        } else {
            cls.setTemplateSlotAllowedParents(slot, list);
        }
    }

    public final void allowedStringsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(23);
        block3: while (true) {
            String string = this.string();
            arrayList.add(string);
            switch (this.jj_nt.kind) {
                case 77: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[6] = this.jj_gen;
        if (cls == null) {
            slot.setAllowedValues(arrayList);
        } else {
            cls.setTemplateSlotAllowedValues(slot, arrayList);
        }
    }

    public final void allowedSymbolsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(24);
        block3: while (true) {
            String string = this.symbol();
            arrayList.add(string);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[7] = this.jj_gen;
        if (cls == null) {
            slot.setAllowedValues(arrayList);
        } else {
            cls.setTemplateSlotAllowedValues(slot, arrayList);
        }
    }

    public final void allowedValuesValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(25);
        List list = this.constants();
        this.checkBooleanAndSetValues(cls, slot, list);
    }

    public final void cardinalityValueDescription(Cls cls, Slot slot) throws ParseException {
        Integer n;
        this.jj_consume_token(29);
        String string = this.symbol();
        String string2 = this.symbol();
        Integer n2 = this.toInteger(string);
        if (n2 != null && n2 != 0) {
            if (cls == null) {
                slot.setMinimumCardinality(n2);
            } else {
                cls.setTemplateSlotMinimumCardinality(slot, n2);
            }
        }
        if ((n = this.toInteger(string2)) != null) {
            if (cls == null) {
                slot.setMaximumCardinality(n);
            } else {
                cls.setTemplateSlotMaximumCardinality(slot, n);
            }
        }
    }

    public final void cls() throws ParseException {
        String string = null;
        try {
            this.jj_consume_token(11);
            this.jj_consume_token(35);
            String string2 = this.symbol();
            switch (this.jj_nt.kind) {
                case 77: {
                    string = this.string();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
            this.jj_consume_token(11);
            this.jj_consume_token(44);
            List list = this.clsesList();
            this.jj_consume_token(12);
            Cls cls = this.getCls(string2, string, list, true);
            this.clsRole(cls);
            block9: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block9;
                    }
                }
                this.slot(cls);
            }
            this.jj_consume_token(12);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        catch (TokenMgrError tokenMgrError) {
            this.handleException(tokenMgrError);
        }
    }

    public final Cls clsReference() throws ParseException {
        String string = this.symbol();
        return this.getCls(string, null, Collections.EMPTY_LIST, false);
    }

    public final List clsesList() throws ParseException {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            Cls cls = this.clsReference();
            arrayList.add(cls);
        }
        return arrayList;
    }

    public final void clsRole(Cls cls) throws ParseException {
        boolean bl;
        this.jj_consume_token(11);
        this.jj_consume_token(61);
        switch (this.jj_nt.kind) {
            case 32: {
                this.jj_consume_token(32);
                bl = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(12);
        if (cls != null) {
            cls.setAbstract(bl);
        }
    }

    public final Object constant() throws ParseException {
        Object object;
        switch (this.jj_nt.kind) {
            case 77: {
                object = this.string();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: {
                object = this.symbol();
                break;
            }
            case 76: {
                object = this.instanceReference();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    public final List constants() throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block3: while (true) {
            Object object = this.constant();
            arrayList.add(object);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[13] = this.jj_gen;
        return arrayList;
    }

    public final void constraintValueDescription(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 70: {
                this.typeValueDescription(cls, slot);
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                this.allowedConstantValueDescription(cls, slot);
                break;
            }
            case 56: {
                this.rangeValueDescription(cls, slot);
                break;
            }
            case 29: {
                this.cardinalityValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void constraintValueDescriptionExtension(Cls cls, Slot slot) throws ParseException {
        this.allowedConstantValueDescriptionExtension(cls, slot);
    }

    public final void createAccessorFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(33);
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void defaultFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList arrayList = new ArrayList();
        ValueType valueType = this.getSlotType(cls, slot);
        this.jj_consume_token(34);
        block3: while (true) {
            Object object = this.constant();
            this.checkedValueAdd(arrayList, valueType, object);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
        if (cls == null) {
            slot.setDefaultValues(arrayList);
        } else {
            cls.setTemplateSlotDefaultValues(slot, arrayList);
        }
    }

    public final String facetName() throws ParseException {
        String string = this.symbol();
        return string;
    }

    public final void userFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.jj_consume_token(71);
        String string = this.facetName();
        block3: while (true) {
            Object object = this.constant();
            arrayList.add(object);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[17] = this.jj_gen;
        Facet facet = this.getOrCreateFacet(string);
        ValueType valueType = facet.getValueType();
        ArrayList arrayList2 = new ArrayList();
        for (Object e : arrayList) {
            this.checkedValueAdd(arrayList2, valueType, e);
        }
        if (cls != null) {
            cls.setTemplateFacetValues(slot, facet, arrayList2);
        }
    }

    public final void templateSlotValueFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList arrayList = new ArrayList();
        ValueType valueType = this.getSlotType(cls, slot);
        this.jj_consume_token(72);
        block3: while (true) {
            Object object = this.constant();
            this.checkedValueAdd(arrayList, valueType, object);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        if (cls == null) {
            slot.setValues(arrayList);
        } else {
            cls.setTemplateSlotValues(slot, arrayList);
        }
    }

    public final void facet(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 34: {
                this.defaultFacet(cls, slot);
                break;
            }
            case 66: {
                this.storageFacet(cls, slot);
                break;
            }
            case 17: {
                this.accessFacet(cls, slot);
                break;
            }
            case 71: {
                this.userFacet(cls, slot);
                break;
            }
            case 54: {
                this.propagationFacet(cls, slot);
                break;
            }
            case 65: {
                this.sourceFacet(cls, slot);
                break;
            }
            case 52: {
                this.patternMatchFacet(cls, slot);
                break;
            }
            case 73: {
                this.visibilityFacet(cls, slot);
                break;
            }
            case 33: {
                this.createAccessorFacet(cls, slot);
                break;
            }
            case 51: {
                this.overrideMessageFacet(cls, slot);
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 56: 
            case 70: {
                this.constraintValueDescription(cls, slot);
                break;
            }
            case 30: {
                this.slotDocumentationFacet(cls, slot);
                break;
            }
            case 43: {
                this.inverseSlotProperty(cls, slot);
                break;
            }
            case 72: {
                this.templateSlotValueFacet(cls, slot);
                break;
            }
            case 68: {
                this.superslotProperty(cls, slot);
                break;
            }
            case 27: {
                this.associatedFacet(cls, slot);
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                this.constraintValueDescriptionExtension(cls, slot);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void facetStatement(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
        this.facet(cls, slot);
        this.jj_consume_token(12);
    }

    public final void includeOntologies() throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(38);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            String string = this.string();
            arrayList.add(string);
        }
        this.jj_consume_token(12);
    }

    public final void instance() throws ParseException {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        try {
            this.jj_consume_token(11);
            String string = this.instanceName();
            this.jj_consume_token(50);
            block9: while (true) {
                Cls cls = this.clsReference();
                arrayList.add(cls);
                switch (this.jj_nt.kind) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 78: {
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[22] = this.jj_gen;
            Instance instance = this.getInstance(string, arrayList);
            block10: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block10;
                    }
                }
                this.slotValue(instance, arrayList);
            }
            this.jj_consume_token(12);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        catch (TokenMgrError tokenMgrError) {
            this.handleException(tokenMgrError);
        }
    }

    public final String instanceName() throws ParseException {
        Token token = this.jj_consume_token(76);
        String string = token.image;
        string = string.substring(1, string.length() - 1);
        string = ClipsUtil.toInternalSymbol(string);
        return string;
    }

    public final Instance instanceReference() throws ParseException {
        String string = this.instanceName();
        return this.getInstance(string, null);
    }

    public final void oldStuff() throws ParseException {
        this.jj_consume_token(15);
        this.string();
        this.jj_consume_token(15);
        this.instanceName();
    }

    public final void overrideMessageFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(51);
        switch (this.jj_nt.kind) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: {
                this.symbol();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void versionInfo() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(74);
        String string = this.string();
        this.jj_consume_token(12);
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(28);
        String string2 = this.string();
        this.jj_consume_token(12);
        this.itsKB.setVersionString(string);
        this.itsKB.setBuildString(string2);
    }

    public final void parseKnowledgeBase() throws ParseException {
        if (this.jj_2_1(3)) {
            this.oldStuff();
        }
        switch (this.jj_nt.kind) {
            case 15: {
                this.versionInfo();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block6;
                }
            }
            this.instance();
        }
        this.jj_consume_token(0);
    }

    public final void parseOntology() throws ParseException {
        if (this.jj_2_2(3)) {
            this.includeOntologies();
        }
        switch (this.jj_nt.kind) {
            case 15: {
                this.versionInfo();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            this.cls();
        }
        this.jj_consume_token(0);
    }

    public final void patternMatchFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(52);
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void patternMatchRole(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(52);
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(12);
    }

    public final void propagationFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(54);
        switch (this.jj_nt.kind) {
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rangeValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(56);
        String string = this.symbol();
        String string2 = this.symbol();
        Float f = this.toFloat(string);
        Float f2 = this.toFloat(string2);
        if (cls == null) {
            slot.setMinimumValue(f);
            slot.setMaximumValue(f2);
        } else {
            cls.setTemplateSlotMinimumValue(slot, f);
            cls.setTemplateSlotMaximumValue(slot, f2);
        }
    }

    public final void slot(Cls cls) throws ParseException {
        try {
            this.jj_consume_token(11);
            boolean bl = this.slotCardinality();
            String string = this.slotName();
            boolean bl2 = cls == null || !this.hasSlot(string);
            Slot slot = this.createTemplateSlot(string, bl, cls, bl2);
            if (bl2) {
                cls = null;
            }
            block5: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: 
                    case 15: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block5;
                    }
                }
                this.facetStatement(cls, slot);
            }
            this.jj_consume_token(12);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public final boolean slotCardinality() throws ParseException {
        boolean bl = true;
        switch (this.jj_nt.kind) {
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                bl = false;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return bl;
    }

    public final void slotDocumentationFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(30);
        String string = this.string();
        if (cls == null) {
            slot.setDocumentation(string);
        } else {
            cls.setTemplateSlotDocumentation(slot, string);
        }
    }

    public final void inverseSlotProperty(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(43);
        String string = this.slotName();
        Slot slot2 = this.getSlot(string);
        this.addInverseSlotPair(slot, slot2);
    }

    public final void superslotProperty(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(68);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            String string = this.slotName();
            arrayList.add(string);
        }
        this.addSuperslots(slot, arrayList);
    }

    public final void associatedFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(27);
        String string = this.facetName();
        Facet facet = this.getOrCreateFacet(string);
        slot.setAssociatedFacet(facet);
        facet.setAssociatedSlot(slot);
    }

    public final String slotName() throws ParseException {
        String string = this.symbol();
        if (string.equals("name_")) {
            string = "name";
        } else if (string.equals("is-a_")) {
            string = "is-a";
        } else if (string.charAt(0) == ':' && (string.equals(":domain-value") || string.equals(":range-value") || string.equals(":entry-slot") || string.equals(":domain-value-slots") || string.equals(":range-value-slots"))) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public final void slotValue(Instance instance, Collection collection) throws ParseException {
        this.jj_consume_token(11);
        String string = this.slotName();
        Slot slot = this.getExistingSlot(string);
        ValueType valueType = this.getOwnSlotValueType(instance, collection, slot);
        Collection collection2 = this.slotValueFields(instance, slot, valueType);
        this.jj_consume_token(12);
        if (slot == null) {
            this.recordError("value for unknown slot: " + string + " in instance " + instance);
        } else {
            instance.setOwnSlotValues(slot, collection2);
        }
    }

    public final Collection slotValueFields(Instance instance, Slot slot, ValueType valueType) throws ParseException {
        ArrayList arrayList = new ArrayList();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            Object object = this.constant();
            this.checkedValueAdd(arrayList, valueType, object);
        }
        return arrayList;
    }

    public final void slotValueFieldProperty() throws ParseException {
        this.jj_consume_token(11);
        this.symbol();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            this.constant();
        }
        this.jj_consume_token(12);
    }

    public final void sourceFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(65);
        switch (this.jj_nt.kind) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void storageFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(66);
        switch (this.jj_nt.kind) {
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String string() throws ParseException {
        Token token = this.jj_consume_token(77);
        return ClipsUtil.toInternalString(token.image);
    }

    public final String symbol() throws ParseException {
        String string;
        switch (this.jj_nt.kind) {
            case 78: {
                Token token = this.jj_consume_token(78);
                string = token.image;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                string = this.keyword();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ClipsUtil.toInternalSymbol(string);
    }

    public final void typeValueDescription(Cls cls, Slot slot) throws ParseException {
        ValueType valueType;
        this.jj_consume_token(70);
        switch (this.jj_nt.kind) {
            case 37: {
                this.jj_consume_token(37);
                valueType = ValueType.FLOAT;
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                valueType = ValueType.INSTANCE;
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                valueType = ValueType.INTEGER;
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                valueType = ValueType.STRING;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                valueType = ValueType.SYMBOL;
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                valueType = ValueType.ANY;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (cls == null) {
            if (slot.getValueType() != valueType) {
                slot.setValueType(valueType);
            }
        } else if (cls.getTemplateSlotValueType(slot) != valueType) {
            cls.setTemplateSlotValueType(slot, valueType);
        }
    }

    public final void visibilityFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(73);
        switch (this.jj_nt.kind) {
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String keyword() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 27: {
                token = this.jj_consume_token(27);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 19: {
                token = this.jj_consume_token(19);
                break;
            }
            case 20: {
                token = this.jj_consume_token(20);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            case 25: {
                token = this.jj_consume_token(25);
                break;
            }
            case 26: {
                token = this.jj_consume_token(26);
                break;
            }
            case 28: {
                token = this.jj_consume_token(28);
                break;
            }
            case 29: {
                token = this.jj_consume_token(29);
                break;
            }
            case 30: {
                token = this.jj_consume_token(30);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 37: {
                token = this.jj_consume_token(37);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                break;
            }
            case 39: {
                token = this.jj_consume_token(39);
                break;
            }
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 41: {
                token = this.jj_consume_token(41);
                break;
            }
            case 42: {
                token = this.jj_consume_token(42);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            case 45: {
                token = this.jj_consume_token(45);
                break;
            }
            case 46: {
                token = this.jj_consume_token(46);
                break;
            }
            case 47: {
                token = this.jj_consume_token(47);
                break;
            }
            case 48: {
                token = this.jj_consume_token(48);
                break;
            }
            case 49: {
                token = this.jj_consume_token(49);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            case 51: {
                token = this.jj_consume_token(51);
                break;
            }
            case 52: {
                token = this.jj_consume_token(52);
                break;
            }
            case 53: {
                token = this.jj_consume_token(53);
                break;
            }
            case 54: {
                token = this.jj_consume_token(54);
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                break;
            }
            case 56: {
                token = this.jj_consume_token(56);
                break;
            }
            case 57: {
                token = this.jj_consume_token(57);
                break;
            }
            case 58: {
                token = this.jj_consume_token(58);
                break;
            }
            case 59: {
                token = this.jj_consume_token(59);
                break;
            }
            case 60: {
                token = this.jj_consume_token(60);
                break;
            }
            case 61: {
                token = this.jj_consume_token(61);
                break;
            }
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 63: {
                token = this.jj_consume_token(63);
                break;
            }
            case 64: {
                token = this.jj_consume_token(64);
                break;
            }
            case 65: {
                token = this.jj_consume_token(65);
                break;
            }
            case 66: {
                token = this.jj_consume_token(66);
                break;
            }
            case 67: {
                token = this.jj_consume_token(67);
                break;
            }
            case 68: {
                token = this.jj_consume_token(68);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 70: {
                token = this.jj_consume_token(70);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 72: {
                token = this.jj_consume_token(72);
                break;
            }
            case 74: {
                token = this.jj_consume_token(74);
                break;
            }
            case 73: {
                token = this.jj_consume_token(73);
                break;
            }
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_3R_20();
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_20() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_21();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 61341696, 0x540000, -65536, 0, -65536, 0, -65536, 0, 2048, -65536, 65536, -65536, -65536, 598212608, 512, -65536, -65536, -65536, 1811808256, 32768, 0, -65536, 2048, -64512, 32768, 2048, 32768, 2048, 0, 0, 0, 34816, 0, -65536, -65536, -65536, Integer.MIN_VALUE, 0, -65536, 0x4000000, 0, -65536};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0x18000100, 0, 0, -1, 0, -1, 0, -1, 0, 0, -1, 1, -1, -1, 0x1000000, 0x14000000, -1, -1, -1, 22546438, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0x2010000, 0x2010000, 32896, 0, 0x40004000, -1, -1, -1, 16, -2147475456, -1, 1568, 0xA00000, -1};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 20479, 8192, 20479, 8192, 20479, 8192, 0, 20479, 0, Short.MAX_VALUE, Short.MAX_VALUE, 64, 2048, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, 982, 0, 8192, 20479, 0, 20479, 0, 0, 0, 0, 0, 0, 0, 0, 1, 20479, Short.MAX_VALUE, Short.MAX_VALUE, 0, 0, 20479, 40, 0, 4095};
    }

    public Parser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new SimpleCharStream(inputStream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public Parser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager parserTokenManager) {
        int n;
        this.token_source = parserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager parserTokenManager) {
        int n;
        this.token_source = parserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 43; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[81];
        for (n2 = 0; n2 < 81; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 43; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 81; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        Parser.jj_la1_0();
        Parser.jj_la1_1();
        Parser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

